/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.view.DotView;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;

public class ScuflDiagram
extends JComponent
implements ScuflModelEventListener,
ScuflUIComponent {
    private ScuflModel model;
    private DotView dot;
    private BufferedImage image = null;
    private boolean fitToWindow = false;
    private boolean lralign = false;
    private Timer updateTimer = null;
    private boolean listenToMouse = true;
    int lastFrameHeight = -1;
    int lastFrameWidth = -1;
    int lastImageHeight = -1;
    int lastImageWidth = -1;
    double lastScaleFactor = 0.0;
    Image rescaledImage = null;
    boolean graphicValid = false;

    public void setLRAlignment(boolean align) {
        if (align != this.lralign) {
            this.lralign = align;
            this.dot.setAlignment(align);
            this.updateGraphic();
        }
    }

    public boolean getLRAlignment() {
        return this.dot.getAlignment();
    }

    public String getDot() {
        return this.dot.getDot();
    }

    public void disableMouseListener() {
        this.listenToMouse = false;
    }

    public ImageIcon getIcon() {
        return ScuflIcons.windowDiagram;
    }

    public ScuflDiagram() {
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doEvent(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doEvent(e);
                }
            }

            void doEvent(MouseEvent e) {
                if (ScuflDiagram.this.listenToMouse) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem title = new JMenuItem("Port display");
                    title.setEnabled(false);
                    menu.add(title);
                    menu.addSeparator();
                    JMenuItem none = new JMenuItem("No ports");
                    menu.add(none);
                    none.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            1.access$100(this.this$1).setPortDisplay(2);
                        }
                    });
                    JMenuItem bound = new JMenuItem("Bound ports only");
                    menu.add(bound);
                    bound.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            1.access$100(this.this$1).setPortDisplay(1);
                        }
                    });
                    JMenuItem all = new JMenuItem("All ports");
                    menu.add(all);
                    all.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            1.access$100(this.this$1).setPortDisplay(0);
                        }
                    });
                    JCheckBoxMenuItem types = new JCheckBoxMenuItem("Show types", ScuflDiagram.this.dot.getTypeLabelDisplay());
                    menu.add(types);
                    types.addItemListener(new ItemListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 2) {
                                1.access$100(this.this$1).setDisplayTypes(false);
                            } else if (e.getStateChange() == 1) {
                                1.access$100(this.this$1).setDisplayTypes(true);
                            }
                        }
                    });
                    menu.addSeparator();
                    JCheckBoxMenuItem scale = new JCheckBoxMenuItem("Fit to window", ScuflIcons.zoomIcon, ScuflDiagram.this.fitToWindow);
                    menu.add(scale);
                    scale.addItemListener(new ItemListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 2) {
                                1.access$100(this.this$1).setFitToWindow(false);
                            } else if (e.getStateChange() == 1) {
                                1.access$100(this.this$1).setFitToWindow(true);
                            }
                        }
                    });
                    menu.show(ScuflDiagram.this, e.getX(), e.getY());
                }
            }

            static /* synthetic */ ScuflDiagram access$100(1 x0) {
                return x0.ScuflDiagram.this;
            }
        });
    }

    public void setFitToWindow(boolean fitToWindow) {
        this.fitToWindow = fitToWindow;
        if (!fitToWindow) {
            this.rescaledImage = null;
        }
        this.repaint();
    }

    public void setDisplayTypes(boolean displayTypes) {
        if (this.dot != null) {
            this.dot.setTypeLabelDisplay(displayTypes);
            this.updateGraphic();
        }
    }

    public void setPortDisplay(int portDisplayPolicy) {
        if (this.dot != null) {
            this.dot.setPortDisplay(portDisplayPolicy);
            this.updateGraphic();
        }
    }

    public Dimension getMinimumSize() {
        if (this.image != null && !this.fitToWindow) {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
        return super.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        if (this.image != null && !this.fitToWindow) {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
        return super.getMaximumSize();
    }

    public Dimension getPreferredSize() {
        if (this.image != null && !this.fitToWindow) {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
        return super.getPreferredSize();
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g);
    }

    public void paintComponent_old(Graphics g) {
        if (this.image != null) {
            int iy;
            double sy;
            Graphics2D g2d = (Graphics2D)g;
            int fx = this.getWidth();
            int fy = this.getHeight();
            int ix = this.image.getWidth();
            double sx = (double)fx / (double)ix;
            double scale = sx < (sy = (double)fy / (double)(iy = this.image.getHeight())) ? sx : sy;
            scale = scale > 1.0 ? 1.0 : scale;
            AffineTransform tx = new AffineTransform();
            if (scale != 1.0) {
                tx.scale(scale, scale);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawImage(this.image, tx, null);
        }
    }

    public void paintComponent(Graphics g) {
        if (this.image != null) {
            if (!this.fitToWindow) {
                g.drawImage(this.image, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
            } else if (this.getWidth() == this.lastFrameWidth && this.getHeight() == this.lastFrameHeight && this.image.getWidth() == this.lastImageWidth && this.image.getHeight() == this.lastImageHeight && this.rescaledImage != null) {
                g.drawImage(this.rescaledImage, 0, 0, null);
            } else {
                double frameHeight;
                double yscale;
                double imageWidth = this.image.getWidth();
                double imageHeight = this.image.getHeight();
                double frameWidth = this.getWidth();
                double xscale = frameWidth / imageWidth;
                double scale = xscale < (yscale = (frameHeight = (double)this.getHeight()) / imageHeight) ? xscale : yscale;
                this.lastFrameHeight = this.getHeight();
                this.lastFrameWidth = this.getWidth();
                this.lastImageHeight = this.image.getHeight();
                this.lastImageWidth = this.image.getWidth();
                this.lastScaleFactor = scale;
                if (scale > 1.0) {
                    scale = 1.0;
                    g.drawImage(this.image, 0, 0, null);
                } else {
                    if (this.rescaledImage != null) {
                        this.rescaledImage.flush();
                    }
                    this.rescaledImage = this.image.getScaledInstance((int)(imageWidth * scale), (int)(imageHeight * scale), 4);
                    g.drawImage(this.rescaledImage, 0, 0, null);
                }
                this.lastFrameHeight = this.getHeight();
                this.lastFrameWidth = this.getWidth();
                this.lastImageHeight = this.image.getHeight();
                this.lastImageWidth = this.image.getWidth();
                this.lastScaleFactor = scale;
            }
        }
    }

    public void attachToModel(ScuflModel model) {
        if (this.model == null) {
            this.dot = new DotView(model);
            this.dot.setPortDisplay(1);
            model.addListener(this);
            this.updateTimer = new Timer();
            this.updateTimer.schedule((TimerTask)new UpdateTimer(), 0L, 2000L);
        }
    }

    public void detachFromModel() {
        if (this.model != null) {
            this.model.removeListener(this);
            this.model.removeListener(this.dot);
            this.dot = null;
            this.model = null;
            if (this.image != null) {
                this.image.flush();
            }
            if (this.rescaledImage != null) {
                this.rescaledImage.flush();
            }
            this.rescaledImage = null;
            this.image = null;
            this.repaint();
            this.updateTimer.cancel();
        }
    }

    private void updateGraphic2() {
        this.receiveModelEvent(null);
    }

    private void updateGraphic() {
        try {
            String imageSuffix = System.getProperty("taverna.scufldiagram.imagetype", "png");
            String dotText = this.dot.getDot();
            String dotLocation = System.getProperty("taverna.dotlocation");
            if (dotLocation == null) {
                dotLocation = "dot";
            }
            Process dotProcess = Runtime.getRuntime().exec(new String[]{dotLocation, "-T" + imageSuffix});
            BufferedOutputStream out = new BufferedOutputStream(dotProcess.getOutputStream());
            ((OutputStream)out).write(dotText.getBytes());
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            BufferedInputStream in = new BufferedInputStream(dotProcess.getInputStream());
            ImageInputStream iis = ImageIO.createImageInputStream(in);
            Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(imageSuffix);
            ImageReader imageReader = readers.next();
            imageReader.setInput(iis, false);
            this.image = imageReader.read(0);
            ((InputStream)in).close();
            this.rescaledImage = null;
            this.doLayout();
            this.repaint();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error!", 0);
        }
    }

    public void receiveModelEvent(ScuflModelEvent event) {
        this.graphicValid = false;
    }

    public String getName() {
        return "Scufl Diagram";
    }

    class UpdateTimer
    extends TimerTask {
        public void run() {
            if (!ScuflDiagram.this.graphicValid) {
                ScuflDiagram.this.graphicValid = true;
                ScuflDiagram.this.updateGraphic();
            }
        }
    }
}

