/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.ConcurrencyConstraint;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.MinorScuflModelEvent;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scuflui.LinkingMenus;
import org.embl.ebi.escience.scuflui.NoContextMenuFoundException;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflSemanticMarkupEditor;
import org.embl.ebi.escience.scuflui.UIUtils;
import org.embl.ebi.escience.scuflworkers.ProcessorEditor;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;

public class ScuflContextMenuFactory {
    public static JPopupMenu getMenuForObject(DefaultMutableTreeNode theNode, Object theObject, ScuflModel methodSigModel) throws NoContextMenuFoundException {
        final ScuflModel model = methodSigModel;
        if (theObject == null) {
            throw new NoContextMenuFoundException("Supplied user object was null, giving up.");
        }
        if (theObject instanceof Processor) {
            return ScuflContextMenuFactory.getProcessorMenu((Processor)theObject);
        }
        if (theObject instanceof AlternateProcessor) {
            return ScuflContextMenuFactory.getAlternateProcessorMenu((AlternateProcessor)theObject);
        }
        if (theObject instanceof Port) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)theNode.getParent();
            final Port thePort = (Port)theObject;
            if (parent.getUserObject() instanceof AlternateProcessor) {
                final AlternateProcessor ap = (AlternateProcessor)parent.getUserObject();
                JPopupMenu theMenu = new JPopupMenu();
                JMenuItem title = new JMenuItem("Map port '" + thePort.getName() + "' to...");
                theMenu.add(title);
                title.setEnabled(false);
                theMenu.addSeparator();
                if (theObject instanceof OutputPort) {
                    OutputPort[] originalPorts = ap.getOriginalProcessor().getOutputPorts();
                    for (int i = 0; i < originalPorts.length; ++i) {
                        JMenuItem item = new JMenuItem(originalPorts[i].getName(), ScuflIcons.outputPortIcon);
                        final OutputPort originalPort = originalPorts[i];
                        item.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent ae) {
                                ap.getOutputMapping().put(originalPort.getName(), thePort.getName());
                                ap.getOriginalProcessor().fireModelEvent(new MinorScuflModelEvent(ap.getProcessor(), "Port mapping changed"));
                            }
                        });
                        theMenu.add(item);
                    }
                } else {
                    InputPort[] originalPorts = ap.getOriginalProcessor().getInputPorts();
                    for (int i = 0; i < originalPorts.length; ++i) {
                        JMenuItem item = new JMenuItem(originalPorts[i].getName(), ScuflIcons.inputPortIcon);
                        final InputPort originalPort = originalPorts[i];
                        item.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent ae) {
                                ap.getInputMapping().put(originalPort.getName(), thePort.getName());
                                ap.getOriginalProcessor().fireModelEvent(new MinorScuflModelEvent(ap.getProcessor(), "Port mapping changed"));
                            }
                        });
                        theMenu.add(item);
                    }
                }
                return theMenu;
            }
            if (thePort instanceof OutputPort) {
                return LinkingMenus.linkFrom(thePort);
            }
            if (thePort instanceof InputPort && thePort.getProcessor() == model.getWorkflowSinkProcessor()) {
                JPopupMenu theMenu = new JPopupMenu();
                JMenuItem title = new JMenuItem("Workflow sink : " + thePort.getName());
                final Port sinkPort = thePort;
                theMenu.add(title);
                title.setEnabled(false);
                theMenu.addSeparator();
                JMenuItem edit = new JMenuItem("Edit metadata...", ScuflIcons.editIcon);
                edit.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        UIUtils.createFrame(model, new ScuflSemanticMarkupEditor(sinkPort.getMetadata()), 100, 100, 400, 600);
                    }
                });
                theMenu.add(edit);
                theMenu.addSeparator();
                JMenuItem delete = new JMenuItem("Remove from model", ScuflIcons.deleteIcon);
                delete.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        sinkPort.getProcessor().removePort(sinkPort);
                    }
                });
                theMenu.add(delete);
                return theMenu;
            }
        } else {
            if (theObject instanceof DataConstraint) {
                return ScuflContextMenuFactory.getDataConstraintMenu((DataConstraint)theObject, model);
            }
            if (theObject instanceof ConcurrencyConstraint) {
                return ScuflContextMenuFactory.getConcurrencyConstraintMenu((ConcurrencyConstraint)theObject, model);
            }
            if (theObject instanceof String) {
                String choice = (String)theObject;
                if (choice.equals("Workflow inputs")) {
                    JPopupMenu theMenu = new JPopupMenu();
                    JMenuItem title = new JMenuItem("Workflow inputs");
                    theMenu.add(title);
                    title.setEnabled(false);
                    theMenu.addSeparator();
                    JMenuItem createInput = new JMenuItem("Create new input", ScuflIcons.inputIcon);
                    theMenu.add(createInput);
                    final ScuflModel theModel = model;
                    createInput.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            String name = (String)JOptionPane.showInputDialog(null, "Name for the new workflow input?", "Name required", 3, null, null, "");
                            if (name != null) {
                                try {
                                    theModel.getWorkflowSourceProcessor().addPort(new OutputPort(theModel.getWorkflowSourceProcessor(), name));
                                    theModel.forceUpdate();
                                }
                                catch (PortCreationException pce) {
                                    JOptionPane.showMessageDialog(null, "Port creation exception : \n" + pce.getMessage(), "Exception!", 0);
                                }
                                catch (DuplicatePortNameException dpne) {
                                    JOptionPane.showMessageDialog(null, "Duplicate name : \n" + dpne.getMessage(), "Exception!", 0);
                                }
                            }
                        }
                    });
                    return theMenu;
                }
                if (choice.equals("Workflow outputs")) {
                    JPopupMenu theMenu = new JPopupMenu();
                    JMenuItem title = new JMenuItem("Workflow outputs");
                    theMenu.add(title);
                    title.setEnabled(false);
                    theMenu.addSeparator();
                    JMenuItem createOutput = new JMenuItem("Create new output", ScuflIcons.outputIcon);
                    theMenu.add(createOutput);
                    final ScuflModel theModel = model;
                    createOutput.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            String name = (String)JOptionPane.showInputDialog(null, "Name for the new workflow output?", "Name required", 3, null, null, "");
                            if (name != null) {
                                try {
                                    theModel.getWorkflowSinkProcessor().addPort(new InputPort(theModel.getWorkflowSinkProcessor(), name));
                                    theModel.forceUpdate();
                                }
                                catch (PortCreationException pce) {
                                    JOptionPane.showMessageDialog(null, "Port creation exception : \n" + pce.getMessage(), "Exception!", 0);
                                }
                                catch (DuplicatePortNameException dpne) {
                                    JOptionPane.showMessageDialog(null, "Duplicate name : \n" + dpne.getMessage(), "Exception!", 0);
                                }
                            }
                        }
                    });
                    return theMenu;
                }
            }
        }
        throw new NoContextMenuFoundException("Didn't know how to create a context menu for a " + theObject.getClass().toString());
    }

    private static JPopupMenu getDataConstraintMenu(DataConstraint dc, ScuflModel model) {
        final DataConstraint theConstraint = dc;
        final ScuflModel theModel = model;
        JPopupMenu theMenu = new JPopupMenu();
        JMenuItem title = new JMenuItem("Link : " + theConstraint.getName());
        title.setEnabled(false);
        theMenu.add(title);
        theMenu.addSeparator();
        JMenuItem delete = new JMenuItem("Remove from model", ScuflIcons.deleteIcon);
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                theModel.destroyDataConstraint(theConstraint);
            }
        });
        theMenu.add(delete);
        return theMenu;
    }

    private static JPopupMenu getConcurrencyConstraintMenu(ConcurrencyConstraint cc, ScuflModel model) {
        final ConcurrencyConstraint theConstraint = cc;
        final ScuflModel theModel = model;
        JPopupMenu theMenu = new JPopupMenu();
        JMenuItem title = new JMenuItem("Coordination : " + theConstraint.getName());
        title.setEnabled(false);
        theMenu.add(title);
        theMenu.addSeparator();
        JMenuItem delete = new JMenuItem("Remove from model", ScuflIcons.deleteIcon);
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                theModel.destroyConcurrencyConstraint(theConstraint);
            }
        });
        theMenu.add(delete);
        return theMenu;
    }

    private static JPopupMenu getProcessorMenu(Processor processor) {
        final Processor theProcessor = processor;
        JPopupMenu theMenu = new JPopupMenu();
        JMenuItem title = new JMenuItem("Processor : " + theProcessor.getName());
        title.setEnabled(false);
        theMenu.add(title);
        theMenu.addSeparator();
        JMenuItem delete = new JMenuItem("Remove from model", ScuflIcons.deleteIcon);
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                theProcessor.getModel().destroyProcessor(theProcessor);
            }
        });
        theMenu.add(delete);
        String tagName = ProcessorHelper.getTagNameForClassName(theProcessor.getClass().getName());
        ProcessorEditor pe = ProcessorHelper.getEditorForTagName(tagName);
        if (pe != null) {
            JMenuItem edit = new JMenuItem(pe.getEditorDescription(), ScuflIcons.editIcon);
            edit.addActionListener(pe.getListener(theProcessor));
            theMenu.add(edit);
        }
        JMenu block = new JMenu("Coordinate from");
        block.setIcon(ScuflIcons.constraintIcon);
        theMenu.add(block);
        Processor[] gp = processor.getModel().getProcessors();
        for (int i = 0; i < gp.length; ++i) {
            if (gp[i] == processor) continue;
            JMenuItem gpi = new JMenuItem(gp[i].getName());
            gpi.setIcon(ProcessorHelper.getPreferredIcon(gp[i]));
            ((Container)block).add(gpi);
            final Processor controller = gp[i];
            final Processor target = processor;
            final ScuflModel model = processor.getModel();
            gpi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    String ccName = target.getName() + "_BLOCKON_" + controller.getName();
                    try {
                        ConcurrencyConstraint cc = new ConcurrencyConstraint(model, ccName, controller, target, 0, 1, 2);
                        model.addConcurrencyConstraint(cc);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Something wasn't happy : \n" + e.getMessage(), "Exception!", 0);
                    }
                }
            });
        }
        return theMenu;
    }

    private static JPopupMenu getAlternateProcessorMenu(AlternateProcessor ap) {
        JPopupMenu theMenu = new JPopupMenu();
        JMenuItem title = new JMenuItem("Alternate processor");
        title.setEnabled(false);
        theMenu.add(title);
        theMenu.addSeparator();
        final Processor parentProcessor = ap.getOriginalProcessor();
        final AlternateProcessor alternate = ap;
        Processor theProcessor = ap.getProcessor();
        String tagName = ProcessorHelper.getTagNameForClassName(theProcessor.getClass().getName());
        ProcessorEditor pe = ProcessorHelper.getEditorForTagName(tagName);
        if (pe != null) {
            JMenuItem edit = new JMenuItem(pe.getEditorDescription(), ScuflIcons.editIcon);
            edit.addActionListener(pe.getListener(theProcessor));
            theMenu.add(edit);
        }
        JMenuItem delete = new JMenuItem("Remove this alternate", ScuflIcons.deleteIcon);
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                parentProcessor.removeAlternate(alternate);
            }
        });
        theMenu.add(delete);
        int numberOfAlternates = parentProcessor.getAlternatesList().size();
        final int alternateIndex = parentProcessor.getAlternatesList().indexOf(alternate);
        if (numberOfAlternates > 1 && alternateIndex != -1) {
            if (alternateIndex > 0) {
                JMenuItem promote = new JMenuItem("Promote alternate");
                promote.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent a) {
                        List theList = parentProcessor.getAlternatesList();
                        Object o = theList.get(alternateIndex);
                        theList.remove(o);
                        theList.add(alternateIndex - 1, o);
                        parentProcessor.fireModelEvent(new ScuflModelEvent(parentProcessor, "Alternates reordered"));
                    }
                });
                theMenu.add(promote);
            }
            if (alternateIndex < numberOfAlternates - 1) {
                JMenuItem demote = new JMenuItem("Demote alternate");
                demote.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent a) {
                        List theList = parentProcessor.getAlternatesList();
                        Object o = theList.get(alternateIndex);
                        theList.remove(o);
                        theList.add(alternateIndex + 1, o);
                        parentProcessor.fireModelEvent(new ScuflModelEvent(parentProcessor, "Alternates reordered"));
                    }
                });
                theMenu.add(demote);
            }
        }
        return theMenu;
    }
}

