/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflModelExplorerRenderer;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflui.workbench.ScavengerTree;

public class ScavengerTreePanel
extends JPanel
implements ScuflUIComponent {
    ScavengerTree tree;
    JTextField regex = null;
    JButton find;
    JCheckBox watchLoads = new JCheckBox("Watch loads", true);
    boolean isWatchingLoads = true;
    ScuflModelEventListener eventListener = new ScuflModelEventListener(){

        public void receiveModelEvent(ScuflModelEvent event) {
            if (event.getEventType() == ScuflModelEvent.LOAD && ScavengerTreePanel.this.isWatchingLoads) {
                new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        try {
                            1.access$000(this.this$1).tree.addScavengersFromModel();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }

        static /* synthetic */ ScavengerTreePanel access$000(1 x0) {
            return x0.ScavengerTreePanel.this;
        }
    };
    private ScuflModel model = null;

    public ScavengerTreePanel() {
        this.setLayout(new BorderLayout());
        this.tree = new ScavengerTree(true);
        JScrollPane treePane = new JScrollPane(this.tree);
        treePane.setPreferredSize(new Dimension(0, 0));
        this.add((Component)treePane, "Center");
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add(new JLabel(" Search list "));
        this.regex = new JTextField();
        this.regex.setPreferredSize(new Dimension(100, 20));
        this.regex.setMaximumSize(new Dimension(100, 20));
        toolbar.add(this.regex);
        this.find = new JButton(ScuflIcons.findIcon);
        this.find.setPreferredSize(new Dimension(20, 20));
        this.find.setEnabled(false);
        toolbar.add(this.find);
        toolbar.addSeparator();
        toolbar.add(this.watchLoads);
        toolbar.add(Box.createHorizontalGlue());
        this.add((Component)toolbar, "First");
        this.watchLoads.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ScavengerTreePanel.this.isWatchingLoads = e.getStateChange() != 2;
            }
        });
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScavengerTreePanel.this.jumpToAndHighlight();
            }
        });
        this.regex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ScavengerTreePanel.this.regex.getText().equals("")) {
                    ScavengerTreePanel.this.jumpToAndHighlight();
                }
            }
        });
        this.regex.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.checkStatus();
            }

            public void removeUpdate(DocumentEvent e) {
                this.checkStatus();
            }

            public void changedUpdate(DocumentEvent e) {
                this.checkStatus();
            }

            private void checkStatus() {
                ScavengerTreePanel.this.cancelHighlight();
                if (!ScavengerTreePanel.this.regex.getText().equals("")) {
                    ScavengerTreePanel.this.find.setEnabled(true);
                } else {
                    ScavengerTreePanel.this.find.setEnabled(false);
                }
            }
        });
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private void cancelHighlight() {
        ScuflModelExplorerRenderer r = (ScuflModelExplorerRenderer)this.tree.getCellRenderer();
        if (this.regex.getText().equals("")) {
            r.setPattern(null);
        } else {
            String regexString = ".*" + this.regex.getText().toLowerCase() + ".*";
            r.setPattern(regexString);
        }
        this.tree.repaint();
    }

    private void jumpToAndHighlight() {
        String regexString = ".*" + this.regex.getText().toLowerCase() + ".*";
        ScuflModelExplorerRenderer r = (ScuflModelExplorerRenderer)this.tree.getCellRenderer();
        r.setPattern(regexString);
        this.expandAll(this.tree, false);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
        Enumeration<TreeNode> en = rootNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)en.nextElement();
            if (!theNode.getUserObject().toString().toLowerCase().matches(regexString)) continue;
            TreePath path = new TreePath(treeModel.getPathToRoot(theNode));
            this.tree.makeVisible(path);
        }
    }

    public void attachToModel(ScuflModel model) {
        this.model = model;
        this.tree.attachToModel(model);
        model.addListener(this.eventListener);
    }

    public void detachFromModel() {
        this.model.removeListener(this.eventListener);
        this.tree.detachFromModel();
        this.model = null;
    }

    public String getName() {
        return "Available services";
    }

    public ImageIcon getIcon() {
        return ScuflIcons.windowScavenger;
    }
}

