/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.scufl.CrossNode;
import org.embl.ebi.escience.scufl.DotNode;
import org.embl.ebi.escience.scufl.IterationStrategy;
import org.embl.ebi.escience.scufl.LeafNode;
import org.embl.ebi.escience.scuflui.CArrowImage;
import org.embl.ebi.escience.scuflui.CTransferableTreePath;

public class IterationStrategyEditor
extends JTree
implements DragSourceListener,
DragGestureListener,
Autoscroll,
TreeModelListener {
    private TreePath pathSource;
    private BufferedImage imgGhost;
    private Point ptOffset = new Point();
    private IterationStrategy strategy;
    static ImageIcon joinIteratorIcon;
    static ImageIcon lockStepIteratorIcon;
    static ImageIcon baclavaIteratorIcon;
    private static final int AUTOSCROLL_MARGIN = 12;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllNodesExpanded() {
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            this.expandAll(this, new TreePath(this.getModel().getRoot()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeModel treeModel = this.getModel();
        synchronized (treeModel) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
    }

    public IterationStrategyEditor(IterationStrategy strategy) {
        super(strategy.getTreeModel());
        this.strategy = strategy;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        DropTarget dropTarget = new DropTarget(this, new CDropTargetListener());
        dropTarget.setDefaultActions(2);
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof CrossNode) {
                    this.setIcon(joinIteratorIcon);
                    this.setText("cross product");
                } else if (value instanceof DotNode) {
                    this.setIcon(lockStepIteratorIcon);
                    this.setText("dot product");
                } else if (value instanceof LeafNode) {
                    this.setIcon(baclavaIteratorIcon);
                }
                return this;
            }
        });
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        Point ptDragOrigin = e.getDragOrigin();
        TreePath path = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
        if (path == null) {
            return;
        }
        if (this.isRootPath(path)) {
            return;
        }
        Rectangle raPath = this.getPathBounds(path);
        this.ptOffset.setLocation(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        JLabel lbl = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, path.getLastPathComponent(), false, this.isExpanded(path), this.getModel().isLeaf(path.getLastPathComponent()), 0, false);
        lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
        this.imgGhost = new BufferedImage((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
        Graphics2D g2 = this.imgGhost.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        lbl.paint(g2);
        Icon icon = lbl.getIcon();
        int nStartOfText = icon == null ? 0 : icon.getIconWidth() + lbl.getIconTextGap();
        g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
        g2.setPaint(new GradientPaint(nStartOfText, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
        g2.fillRect(nStartOfText, 0, this.getWidth(), this.imgGhost.getHeight());
        g2.dispose();
        this.setSelectionPath(path);
        System.out.println("DRAGGING: " + path.getLastPathComponent());
        CTransferableTreePath transferable = new CTransferableTreePath(path);
        this.pathSource = path;
        e.startDrag(null, this.imgGhost, new Point(5, 5), transferable, this);
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
        if (e.getDropSuccess()) {
            int nAction = e.getDropAction();
            if (nAction == 2) {
                System.out.println("REMOVING: " + this.pathSource.getLastPathComponent());
                this.pathSource = null;
            }
        } else {
            this.repaint();
        }
    }

    public void autoscroll(Point pt) {
        int nRow = this.getRowForLocation(pt.x, pt.y);
        if (nRow < 0) {
            return;
        }
        Rectangle raOuter = this.getBounds();
        nRow = pt.y + raOuter.y <= 12 ? (nRow <= 0 ? 0 : nRow - 1) : (nRow < this.getRowCount() - 1 ? nRow + 1 : nRow);
        this.scrollRowToVisible(nRow);
    }

    public Insets getAutoscrollInsets() {
        Rectangle raOuter = this.getBounds();
        Rectangle raInner = this.getParent().getBounds();
        return new Insets(raInner.y - raOuter.y + 12, raInner.x - raOuter.x + 12, raOuter.height - raInner.height - raInner.y + raOuter.y + 12, raOuter.width - raInner.width - raInner.x + raOuter.x + 12);
    }

    public void treeNodesChanged(TreeModelEvent e) {
        System.out.println("treeNodesChanged");
        this.sayWhat(e);
    }

    public void treeNodesInserted(TreeModelEvent e) {
        System.out.println("treeNodesInserted ");
        this.sayWhat(e);
        int nChildIndex = e.getChildIndices()[0];
        TreePath pathParent = e.getTreePath();
        this.setSelectionPath(this.getChildPath(pathParent, nChildIndex));
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        System.out.println("treeNodesRemoved ");
        this.sayWhat(e);
    }

    public void treeStructureChanged(TreeModelEvent e) {
        System.out.println("treeStructureChanged ");
        this.sayWhat(e);
    }

    private TreePath getChildPath(TreePath pathParent, int nChildIndex) {
        TreeModel model = this.getModel();
        return pathParent.pathByAddingChild(model.getChild(pathParent.getLastPathComponent(), nChildIndex));
    }

    private boolean isRootPath(TreePath path) {
        return this.isRootVisible() && this.getRowForPath(path) == 0;
    }

    private void sayWhat(TreeModelEvent e) {
        System.out.println(e.getTreePath().getLastPathComponent());
        int[] nIndex = e.getChildIndices();
        for (int i = 0; i < nIndex.length; ++i) {
            System.out.println(i + ". " + nIndex[i]);
        }
    }

    static /* synthetic */ boolean access$300(IterationStrategyEditor x0, TreePath x1) {
        return x0.isRootPath(x1);
    }

    static {
        try {
            Class<?> c = Class.forName("org.embl.ebi.escience.scuflui.IterationStrategyEditor");
            joinIteratorIcon = new ImageIcon(c.getResource("icons/iteration/crossproducticon.png"));
            lockStepIteratorIcon = new ImageIcon(c.getResource("icons/iteration/dotproducticon.png"));
            baclavaIteratorIcon = new ImageIcon(c.getResource("icons/iteration/baclavaiteratoricon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class CDropTargetListener
    implements DropTargetListener {
        private TreePath _pathLast = null;
        private Rectangle2D _raCueLine = new Rectangle2D.Float();
        private Rectangle2D _raGhost = new Rectangle2D.Float();
        private Color _colorCueLine;
        private Point _ptLast = new Point();
        private Timer _timerHover;
        private int _nLeftRight = 0;
        private BufferedImage _imgRight = new CArrowImage(15, 15, 3);
        private BufferedImage _imgLeft = new CArrowImage(15, 15, 2);
        private int _nShift = 0;

        public CDropTargetListener() {
            this._colorCueLine = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 64);
            this._timerHover = new Timer(1000, new ActionListener(this){
                private final /* synthetic */ CDropTargetListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    CDropTargetListener.access$002(this.this$1, 0);
                    if (IterationStrategyEditor.access$300(CDropTargetListener.access$200(this.this$1), CDropTargetListener.access$100(this.this$1))) {
                        return;
                    }
                    if (CDropTargetListener.access$200(this.this$1).isExpanded(CDropTargetListener.access$100(this.this$1))) {
                        CDropTargetListener.access$200(this.this$1).collapsePath(CDropTargetListener.access$100(this.this$1));
                    } else {
                        CDropTargetListener.access$200(this.this$1).expandPath(CDropTargetListener.access$100(this.this$1));
                    }
                }
            });
            this._timerHover.setRepeats(false);
        }

        public void dragEnter(DropTargetDragEvent e) {
            if (!this.isDragAcceptable(e)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void dragExit(DropTargetEvent e) {
            if (!DragSource.isDragImageSupported()) {
                IterationStrategyEditor.this.repaint(this._raGhost.getBounds());
            }
        }

        public void dragOver(DropTargetDragEvent e) {
            Point pt = e.getLocation();
            if (pt.equals(this._ptLast)) {
                return;
            }
            int nDeltaLeftRight = pt.x - this._ptLast.x;
            if (this._nLeftRight > 0 && nDeltaLeftRight < 0 || this._nLeftRight < 0 && nDeltaLeftRight > 0) {
                this._nLeftRight = 0;
            }
            this._nLeftRight += nDeltaLeftRight;
            this._ptLast = pt;
            Graphics2D g2 = (Graphics2D)IterationStrategyEditor.this.getGraphics();
            if (!DragSource.isDragImageSupported()) {
                IterationStrategyEditor.this.paintImmediately(this._raGhost.getBounds());
                this._raGhost.setRect(pt.x - ((IterationStrategyEditor)IterationStrategyEditor.this).ptOffset.x, pt.y - ((IterationStrategyEditor)IterationStrategyEditor.this).ptOffset.y, IterationStrategyEditor.this.imgGhost.getWidth(), IterationStrategyEditor.this.imgGhost.getHeight());
                g2.drawImage(IterationStrategyEditor.this.imgGhost, AffineTransform.getTranslateInstance(this._raGhost.getX(), this._raGhost.getY()), null);
            } else {
                IterationStrategyEditor.this.paintImmediately(this._raCueLine.getBounds());
            }
            TreePath path = IterationStrategyEditor.this.getClosestPathForLocation(pt.x, pt.y);
            if (path != this._pathLast) {
                this._nLeftRight = 0;
                this._pathLast = path;
                this._timerHover.restart();
            }
            Rectangle raPath = IterationStrategyEditor.this.getPathBounds(path);
            this._raCueLine.setRect(0.0, raPath.y + (int)raPath.getHeight(), IterationStrategyEditor.this.getWidth(), 2.0);
            g2.setColor(this._colorCueLine);
            g2.fill(this._raCueLine);
            if (this._nLeftRight > 20) {
                g2.drawImage(this._imgRight, AffineTransform.getTranslateInstance(pt.x - ((IterationStrategyEditor)IterationStrategyEditor.this).ptOffset.x, pt.y - ((IterationStrategyEditor)IterationStrategyEditor.this).ptOffset.y), null);
                this._nShift = 1;
            } else if (this._nLeftRight < -20) {
                g2.drawImage(this._imgLeft, AffineTransform.getTranslateInstance(pt.x - ((IterationStrategyEditor)IterationStrategyEditor.this).ptOffset.x, pt.y - ((IterationStrategyEditor)IterationStrategyEditor.this).ptOffset.y), null);
                this._nShift = -1;
            } else {
                this._nShift = 0;
            }
            this._raGhost = this._raGhost.createUnion(this._raCueLine);
            if (!this.isDragAcceptable(e)) {
                e.rejectDrag();
            }
            if (path.equals(IterationStrategyEditor.this.pathSource)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            if (!this.isDragAcceptable(e)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void drop(DropTargetDropEvent e) {
            this._timerHover.stop();
            if (!this.isDropAcceptable(e)) {
                e.rejectDrop();
                IterationStrategyEditor.this.repaint();
                return;
            }
            e.acceptDrop(e.getDropAction());
            Transferable transferable = e.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor flavor = flavors[i];
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Point pt = e.getLocation();
                    TreePath pathTarget = IterationStrategyEditor.this.getClosestPathForLocation(pt.x, pt.y);
                    TreePath pathSource = (TreePath)transferable.getTransferData(flavor);
                    System.out.println("DROPPING: " + pathSource.getLastPathComponent());
                    DefaultTreeModel model = (DefaultTreeModel)IterationStrategyEditor.this.getModel();
                    MutableTreeNode draggedNode = (MutableTreeNode)pathSource.getLastPathComponent();
                    MutableTreeNode dropNode = (MutableTreeNode)pathTarget.getLastPathComponent();
                    System.out.println("Removing node " + draggedNode.toString() + " of type " + draggedNode.getClass().getName());
                    model.removeNodeFromParent(draggedNode);
                    if (dropNode instanceof LeafNode || !IterationStrategyEditor.this.isExpanded(pathTarget) && this._nShift <= 0) {
                        System.out.println("Drop target is a leaf node");
                        MutableTreeNode newParentNode = (MutableTreeNode)dropNode.getParent();
                        System.out.println("Drop target parent : " + newParentNode.toString() + " of type " + newParentNode.getClass().getName());
                        int index = model.getIndexOfChild(dropNode.getParent(), dropNode);
                        System.out.println("Drop target has index " + index + " in its parent's child list");
                        model.insertNodeInto(draggedNode, newParentNode, index + 1);
                        System.out.println("Node inserted");
                        System.out.println("New node parent is " + draggedNode.getParent().toString() + " of type " + draggedNode.getParent().getClass().getName());
                    } else {
                        System.out.println("Drop target is not a leaf");
                        System.out.println("Drop target : " + dropNode.toString() + " of type " + dropNode.getClass().getName());
                        model.insertNodeInto(draggedNode, dropNode, 0);
                        System.out.println("Node inserted");
                    }
                    IterationStrategyEditor.this.setSelectionPath(new TreePath(model.getPathToRoot(draggedNode)));
                    break;
                }
                catch (UnsupportedFlavorException ufe) {
                    System.out.println(ufe);
                    e.dropComplete(false);
                    return;
                }
                catch (IOException ioe) {
                    System.out.println(ioe);
                    e.dropComplete(false);
                    return;
                }
                catch (ClassCastException cce) {
                    System.out.println(cce);
                    e.dropComplete(false);
                    return;
                }
            }
            e.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            if ((e.getDropAction() & 2) == 0) {
                return false;
            }
            if (!e.isDataFlavorSupported(CTransferableTreePath.TREEPATH_FLAVOR)) {
                return false;
            }
            Point pt = e.getLocation();
            TreePath path = IterationStrategyEditor.this.getClosestPathForLocation(pt.x, pt.y);
            if (path.equals(IterationStrategyEditor.this.pathSource)) {
                return false;
            }
            return !IterationStrategyEditor.this.pathSource.isDescendant(path);
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            if ((e.getDropAction() & 2) == 0) {
                return false;
            }
            if (!e.isDataFlavorSupported(CTransferableTreePath.TREEPATH_FLAVOR)) {
                return false;
            }
            Point pt = e.getLocation();
            TreePath path = IterationStrategyEditor.this.getClosestPathForLocation(pt.x, pt.y);
            System.out.println(path.toString() + " " + IterationStrategyEditor.this.pathSource.toString());
            if (path.equals(IterationStrategyEditor.this.pathSource)) {
                return false;
            }
            return !IterationStrategyEditor.this.pathSource.isDescendant(path);
        }

        static /* synthetic */ int access$002(CDropTargetListener x0, int x1) {
            x0._nLeftRight = x1;
            return x0._nLeftRight;
        }

        static /* synthetic */ TreePath access$100(CDropTargetListener x0) {
            return x0._pathLast;
        }

        static /* synthetic */ IterationStrategyEditor access$200(CDropTargetListener x0) {
            return x0.IterationStrategyEditor.this;
        }
    }
}

