/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scuflui.InvalidStatusReportException;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class EnactorStatusTableModel
extends AbstractTableModel {
    private ScuflModel scuflModel;
    private int rows = 0;
    private Object[][] data;
    final String[] columnNames = new String[]{"Type", "Name", "Last event", "Event timestamp", "Event detail"};

    public EnactorStatusTableModel(ScuflModel scufl) {
        this.scuflModel = scufl;
        Processor[] processors = this.scuflModel.getProcessors();
        this.rows = processors.length;
        this.data = new Object[this.rows][this.columnNames.length];
        for (int i = 0; i < this.rows; ++i) {
            Processor p = processors[i];
            this.data[i][0] = ProcessorHelper.getPreferredIcon(p);
            this.data[i][1] = p.getName();
            this.data[i][2] = "No data";
            this.data[i][3] = "--";
            this.data[i][4] = "--";
        }
    }

    public void setStatusString(String processorName, String statusString) {
        for (int i = 0; i < this.rows; ++i) {
            if (!((String)this.data[i][1]).equals(processorName)) continue;
            String colour = "black";
            if (statusString.equals("ProcessComplete")) {
                colour = "#1C7366";
            } else if (statusString.equals("ServiceError") || statusString.equals("ServiceFailure")) {
                colour = "red";
            } else if (statusString.startsWith("Invoking")) {
                colour = "purple";
            } else if (statusString.equals("ProcessScheduled")) {
                colour = "#CE7220";
            }
            this.setValueAt("<html><font color=\"" + colour + "\">" + statusString + "</font></html>", i, 2);
            return;
        }
    }

    public void setEventTime(String processorName, String theString) {
        for (int i = 0; i < this.rows; ++i) {
            if (!((String)this.data[i][1]).equals(processorName)) continue;
            this.setValueAt(theString, i, 3);
            return;
        }
    }

    public void setEventDetail(String processorName, String theString) {
        for (int i = 0; i < this.rows; ++i) {
            if (!((String)this.data[i][1]).equals(processorName)) continue;
            this.setValueAt(theString, i, 4);
            return;
        }
    }

    public String update(String progressReport) throws InvalidStatusReportException {
        Element processorList;
        String workflowID = null;
        String workflowStatus = null;
        Object documentNamespace = null;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build((Reader)new StringReader(progressReport));
            processorList = document.getRootElement().getChild("processorList");
            workflowID = document.getRootElement().getAttributeValue("workflowID");
            workflowStatus = document.getRootElement().getAttributeValue("workflowStatus");
        }
        catch (JDOMException jde) {
            throw new InvalidStatusReportException("Unable to handle the status report, error was : " + jde.getMessage());
        }
        catch (IOException ioe) {
            throw new InvalidStatusReportException("Unable to handle the status report, error was : " + ioe.getMessage());
        }
        if (workflowID == null) {
            throw new InvalidStatusReportException("Workflow ID was null, exiting.");
        }
        if (workflowStatus == null) {
            throw new InvalidStatusReportException("Workflow status was null, exiting.");
        }
        if (processorList == null) {
            throw new InvalidStatusReportException("Workflow progress report didn't contain a processorList");
        }
        Iterator i = processorList.getChildren("processor").iterator();
        while (i.hasNext()) {
            Element processorElement = (Element)i.next();
            String processorName = processorElement.getAttributeValue("name");
            String processorStatus = "Unknown";
            String eventTime = "--";
            String eventDetail = "--";
            List childElementList = processorElement.getChildren();
            if (!childElementList.isEmpty()) {
                Element firstChildElement = (Element)childElementList.get(0);
                processorStatus = firstChildElement.getName();
                eventTime = firstChildElement.getAttributeValue("TimeStamp");
                StringBuffer eventDetailBuffer = new StringBuffer();
                Iterator j = firstChildElement.getAttributes().iterator();
                while (j.hasNext()) {
                    Attribute a = (Attribute)j.next();
                    String attributeName = a.getName();
                    if (attributeName.equalsIgnoreCase("TimeStamp")) continue;
                    eventDetailBuffer.append(attributeName + "='" + a.getValue() + "' ");
                }
                eventDetail = eventDetailBuffer.toString();
            }
            this.setEventDetail(processorName, eventDetail);
            this.setEventTime(processorName, eventTime);
            this.setStatusString(processorName, processorStatus);
        }
        return workflowStatus;
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return ImageIcon.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public int getRowCount() {
        return this.rows;
    }

    public Object getValueAt(int row, int column) {
        return this.data[row][column];
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }
}

