/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.UnknownProcessorException;
import org.embl.ebi.escience.scufl.enactor.EnactorProxy;
import org.embl.ebi.escience.scufl.enactor.UserContext;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.WorkflowSubmissionException;
import org.embl.ebi.escience.scuflui.EnactorInvocationStatusThread;
import org.embl.ebi.escience.scuflui.EnactorStatusTableModel;
import org.embl.ebi.escience.scuflui.ResultItemPanel;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflui.XMLTree;
import org.embl.ebi.escience.scuflui.results.ResultMapSaveRegistry;
import org.embl.ebi.escience.scuflui.results.ResultMapSaveSPI;
import org.embl.ebi.escience.scuflui.results.ResultTablePanel;
import uk.ac.soton.itinnovation.freefluo.main.InvalidInputException;

public class EnactorInvocation
extends JPanel
implements ScuflUIComponent {
    public static UserContext USERCONTEXT = null;
    private ScuflModel theModel;
    private String instanceID = null;
    private EnactorStatusTableModel statusTableModel = null;
    private WorkflowInstance workflowInstance = null;
    private JTextArea resultsText = null;
    private JTextArea provenanceText = null;
    private JPanel provenancePanel = null;
    private JTabbedPane individualResults = new JTabbedPane();
    private JPanel resultsPanel = null;
    private JTabbedPane tabs = null;
    private JButton saveResultsButton = null;
    private JToolBar toolbar = null;

    public void attachToModel(ScuflModel theModel) {
    }

    public void detachFromModel() {
        try {
            this.workflowInstance.cancel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return "Enactor invocation";
    }

    public ImageIcon getIcon() {
        return ScuflIcons.windowRun;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public String getStatusText() {
        return this.workflowInstance.getProgressReportXMLString();
    }

    protected void ensureGotResults() {
        String results = "";
        try {
            System.out.println("Getting results...");
            boolean gotResults = false;
            while (!gotResults) {
                results = this.workflowInstance.getOutputXMLString();
                if (!results.equals("")) {
                    gotResults = true;
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ie) {
            this.resultsText.setText("No results available : " + ie.toString());
        }
    }

    public void showResults() {
        this.ensureGotResults();
        this.tabs.add("Results", this.individualResults);
        Map resultMap = this.workflowInstance.getOutput();
        ResultMapSaveSPI[] savePlugins = ResultMapSaveRegistry.plugins();
        for (int i = 0; i < savePlugins.length; ++i) {
            JButton saveAction = new JButton(savePlugins[i].getName(), savePlugins[i].getIcon());
            saveAction.addActionListener(savePlugins[i].getListener(resultMap, this));
            this.toolbar.add(saveAction);
            if (i >= savePlugins.length) continue;
            this.toolbar.addSeparator();
        }
        this.toolbar.add(Box.createHorizontalGlue());
        Iterator i = resultMap.keySet().iterator();
        while (i.hasNext()) {
            String resultName = (String)i.next();
            DataThing resultValue = (DataThing)resultMap.get(resultName);
            this.individualResults.add(resultName, new ResultItemPanel(resultValue));
        }
        this.tabs.setSelectedComponent(this.individualResults);
    }

    public void saveResults() {
        this.ensureGotResults();
        Map resultMap = this.workflowInstance.getOutput();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showSaveDialog(this);
        Iterator i = resultMap.keySet().iterator();
        while (i.hasNext()) {
            String resultName = (String)i.next();
            DataThing resultValue = (DataThing)resultMap.get(resultName);
            try {
                if (returnVal != 0) continue;
                File f = chooser.getSelectedFile();
                String name = resultName;
                resultValue.writeToFileSystem(f, name);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void showProvenance() {
        String provenance = "";
        try {
            provenance = this.workflowInstance.getProvenanceXMLString();
            this.tabs.add("Provenance Tree", new JScrollPane(new XMLTree(provenance)));
        }
        catch (Exception ex) {
            this.provenanceText.setText("No provenance available : " + ex.toString());
        }
    }

    public void showResultTable() {
        try {
            this.tabs.add("Result Table", new JScrollPane(new ResultTablePanel(this.theModel, this.workflowInstance)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showProgressReport() {
        String progressReport = "";
        try {
            progressReport = this.workflowInstance.getProgressReportXMLString();
            this.tabs.add("Process report", new JScrollPane(new XMLTree(progressReport)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EnactorStatusTableModel getTableModel() {
        return this.statusTableModel;
    }

    public EnactorInvocation(EnactorProxy enactor, ScuflModel model, Map inputDataThings) throws WorkflowSubmissionException {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(100, 100));
        this.theModel = model;
        this.workflowInstance = enactor.compileWorkflow(model, inputDataThings, USERCONTEXT);
        this.toolbar = new JToolBar("Invocation tools");
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setMaximumSize(new Dimension(2000, 30));
        this.add((Component)this.toolbar, "First");
        this.tabs = new JTabbedPane();
        this.setLayout(new BoxLayout(this, 3));
        this.add((Component)this.tabs, "Center");
        JPanel processorListPanel = new JPanel();
        processorListPanel.setLayout(new BoxLayout(processorListPanel, 3));
        processorListPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Processor statii"));
        this.statusTableModel = new EnactorStatusTableModel(this.theModel);
        JTable processorTable = new JTable(this.statusTableModel);
        processorTable.setGridColor(new Color(235, 235, 235));
        processorTable.setSelectionBackground(new Color(232, 242, 254));
        processorTable.setSelectionForeground(Color.BLACK);
        processorTable.setIntercellSpacing(new Dimension(0, 1));
        processorTable.setShowVerticalLines(false);
        processorTable.getColumnModel().getColumn(0).setMaxWidth(30);
        processorTable.getColumnModel().getColumn(0).setResizable(false);
        JTabbedPane intermediateResults = new JTabbedPane();
        final JTabbedPane intermediateOutputs = new JTabbedPane();
        final JTabbedPane intermediateInputs = new JTabbedPane();
        intermediateResults.add("Intermediate inputs", intermediateInputs);
        intermediateResults.add("Intermediate outputs", intermediateOutputs);
        processorTable.setSelectionMode(0);
        ListSelectionModel rowSM = processorTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    try {
                        DataThing value;
                        String name;
                        String processorName = (String)EnactorInvocation.this.statusTableModel.getValueAt(selectedRow, 1);
                        Map[] intermediateResultMaps = EnactorInvocation.this.workflowInstance.getIntermediateResultsForProcessor(processorName);
                        intermediateInputs.removeAll();
                        intermediateOutputs.removeAll();
                        Iterator i = intermediateResultMaps[0].keySet().iterator();
                        while (i.hasNext()) {
                            name = (String)i.next();
                            value = (DataThing)intermediateResultMaps[0].get(name);
                            intermediateInputs.add(name, new ResultItemPanel(value));
                        }
                        i = intermediateResultMaps[1].keySet().iterator();
                        while (i.hasNext()) {
                            name = (String)i.next();
                            value = (DataThing)intermediateResultMaps[1].get(name);
                            intermediateOutputs.add(name, new ResultItemPanel(value));
                        }
                    }
                    catch (UnknownProcessorException upe) {
                        // empty catch block
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(processorTable);
        scrollPane.setPreferredSize(new Dimension(500, 200));
        JSplitPane statusSplitPane = new JSplitPane(0, scrollPane, intermediateResults);
        processorListPanel.add(statusSplitPane);
        this.tabs.add((Component)processorListPanel, "Status");
        this.resultsPanel = new JPanel();
        this.resultsPanel.setLayout(new BorderLayout());
        this.resultsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Workflow results"));
        this.resultsText = new JTextArea();
        JScrollPane resultsScrollPane = new JScrollPane(this.resultsText);
        resultsScrollPane.setPreferredSize(new Dimension(100, 100));
        this.resultsPanel.add((Component)resultsScrollPane, "Center");
        this.provenancePanel = new JPanel();
        this.provenancePanel.setLayout(new BorderLayout());
        this.provenancePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Workflow provenance"));
        this.provenanceText = new JTextArea();
        JScrollPane provenanceScrollPane = new JScrollPane(this.provenanceText);
        provenanceScrollPane.setPreferredSize(new Dimension(100, 100));
        this.provenancePanel.add((Component)provenanceScrollPane, "Center");
        this.setVisible(true);
        try {
            this.workflowInstance.run();
        }
        catch (InvalidInputException e) {
            WorkflowSubmissionException wse = new WorkflowSubmissionException(e.getMessage());
            throw wse;
        }
        EnactorInvocationStatusThread s = new EnactorInvocationStatusThread(this);
    }
}

