/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.enactor.WorkflowEventAdapter;
import org.embl.ebi.escience.scufl.enactor.WorkflowEventListener;
import org.embl.ebi.escience.scufl.enactor.event.CollectionConstructionEvent;
import org.embl.ebi.escience.scufl.enactor.event.IterationCompletionEvent;
import org.embl.ebi.escience.scufl.enactor.event.ProcessCompletionEvent;
import org.embl.ebi.escience.scufl.enactor.event.ProcessFailureEvent;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowCompletionEvent;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowCreationEvent;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowFailureEvent;
import org.embl.ebi.escience.scufl.enactor.implementation.WorkflowEventDispatcher;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;

public class EnactorEventMonitor
extends JTextArea
implements ScuflModelEventListener,
ScuflUIComponent {
    WorkflowEventDispatcher dispatcher = WorkflowEventDispatcher.DISPATCHER;
    WorkflowEventListener listener = null;

    public EnactorEventMonitor() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setEditable(false);
        this.listener = new WorkflowEventAdapter(){

            public void processCompleted(ProcessCompletionEvent e) {
                EnactorEventMonitor.this.addText(e.toString());
            }

            public void processCompletedWithIteration(IterationCompletionEvent e) {
                EnactorEventMonitor.this.addText(e.toString());
            }

            public void processFailed(ProcessFailureEvent e) {
                EnactorEventMonitor.this.addText(e.toString());
            }

            public void collectionConstructed(CollectionConstructionEvent e) {
                EnactorEventMonitor.this.addText(e.toString());
            }

            public void workflowCreated(WorkflowCreationEvent e) {
                EnactorEventMonitor.this.addText(e.toString());
            }

            public void workflowFailed(WorkflowFailureEvent e) {
                EnactorEventMonitor.this.addText(e.toString());
            }

            public void workflowCompleted(WorkflowCompletionEvent e) {
                EnactorEventMonitor.this.addText(e.toString());
            }
        };
    }

    public void attachToModel(ScuflModel model) {
        this.dispatcher.addListener(this.listener);
    }

    public void detachFromModel() {
        this.dispatcher.removeListener(this.listener);
    }

    public void receiveModelEvent(ScuflModelEvent event) {
    }

    public synchronized void addText(String text) {
        this.setText(this.getText() + "\n" + text);
        this.repaint();
    }

    public ImageIcon getIcon() {
        return ScuflIcons.inputValueIcon;
    }

    public String getName() {
        return "DEBUG - Enactor event monitor";
    }
}

