/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.view.DotView;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;

public class DotTextArea
extends JTextArea
implements ScuflModelEventListener,
ScuflUIComponent {
    private DotView dot = null;
    private ScuflModel model = null;
    private int updateStatus = 0;

    public DotTextArea() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setEditable(false);
    }

    public void attachToModel(ScuflModel model) {
        if (this.model == null) {
            this.dot = new DotView(model);
            model.addListener(this);
            this.updateText();
        }
    }

    public ImageIcon getIcon() {
        return ScuflIcons.inputValueIcon;
    }

    public void detachFromModel() {
        if (this.model != null) {
            this.model.removeListener(this);
            this.model.removeListener(this.dot);
            this.model = null;
            this.dot = null;
            this.updateText();
        }
    }

    private void updateText() {
        if (this.dot != null) {
            this.setText(this.dot.getDot());
        } else {
            this.setText(null);
        }
        this.repaint();
    }

    public void receiveModelEvent(ScuflModelEvent event) {
        if (this.updateStatus == 0) {
            this.updateStatus = 1;
            while (this.updateStatus != 0) {
                this.updateText();
                if (this.updateStatus == 2) {
                    this.updateStatus = 1;
                    continue;
                }
                this.updateStatus = 0;
            }
        } else {
            this.updateStatus = 2;
        }
    }

    public String getName() {
        return "Dot text";
    }
}

