/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.factory.DataThingFactory;
import org.embl.ebi.escience.baclava.factory.DataThingXMLFactory;
import org.embl.ebi.escience.baclava.factory.Flavours;
import org.embl.ebi.escience.baclava.store.BaclavaDataService;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflui.XMLTree;
import org.embl.ebi.escience.scuflui.renderers.RendererException;
import org.embl.ebi.escience.scuflui.renderers.RendererRegistry;
import org.embl.ebi.escience.scuflui.renderers.RendererSPI;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class DataThingConstructionPanel
extends JPanel
implements ScuflUIComponent,
ScuflModelEventListener {
    static JFileChooser fileChooser = new JFileChooser();
    static BaclavaDataService store = null;
    ScuflModel model = null;
    InputsRootNode rootNode = new InputsRootNode();
    DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    JSplitPane splitter;
    JTree portTree;
    JButton loadInputsButton;
    JButton newInputButton;
    JButton newListButton;
    JButton removeButton;
    ActionListener newInputAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)DataThingConstructionPanel.this.portTree.getSelectionPath().getLastPathComponent();
            if (parent instanceof InputDataThingNode) {
                parent = (DefaultMutableTreeNode)parent.getParent();
            }
            InputDataThingNode newNode = new InputDataThingNode("Some input data goes here");
            parent.add(newNode);
            DataThingConstructionPanel.this.treeModel.nodeStructureChanged(parent);
            DataThingConstructionPanel.this.portTree.setSelectionPath(new TreePath(newNode.getPath()));
        }
    };
    ActionListener newListAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)DataThingConstructionPanel.this.portTree.getSelectionPath().getLastPathComponent();
            if (parent instanceof InputDataThingNode) {
                parent = (DefaultMutableTreeNode)parent.getParent();
            }
            InputListNode newNode = new InputListNode(null);
            parent.add(newNode);
            DataThingConstructionPanel.this.treeModel.nodeStructureChanged(parent);
            DataThingConstructionPanel.this.portTree.setSelectionPath(new TreePath(newNode.getPath()));
        }
    };
    ActionListener removeAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)DataThingConstructionPanel.this.portTree.getSelectionPath().getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            DefaultMutableTreeNode previousNode = node.getPreviousNode();
            parent.remove(node);
            DataThingConstructionPanel.this.treeModel.nodeStructureChanged(parent);
            DataThingConstructionPanel.this.portTree.setSelectionPath(new TreePath(previousNode.getPath()));
        }
    };
    ActionListener loadFilesAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            fileChooser.setMultiSelectionEnabled(true);
            int returnVal = fileChooser.showOpenDialog(DataThingConstructionPanel.this);
            if (returnVal == 0) {
                File[] files = fileChooser.getSelectedFiles();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)DataThingConstructionPanel.this.portTree.getSelectionPath().getLastPathComponent();
                if (parent instanceof InputDataThingNode) {
                    parent = (DefaultMutableTreeNode)parent.getParent();
                }
                DefaultMutableTreeNode newNode = null;
                for (int index = 0; index < files.length; ++index) {
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(files[index]));
                        StringBuffer stringBuffer = new StringBuffer();
                        String string = null;
                        while ((string = reader.readLine()) != null) {
                            stringBuffer.append(string);
                            stringBuffer.append("\n");
                        }
                        newNode = new InputDataThingNode(stringBuffer.toString());
                        parent.add(newNode);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                DataThingConstructionPanel.this.treeModel.nodeStructureChanged(parent);
                if (newNode != null) {
                    DataThingConstructionPanel.this.portTree.setSelectionPath(new TreePath(newNode.getPath()));
                }
            }
            fileChooser.setMultiSelectionEnabled(false);
        }
    };

    public Map bakeInputMap() {
        HashMap<String, DataThing> inputMap = new HashMap<String, DataThing>();
        Enumeration<TreeNode> children = this.rootNode.children();
        while (children.hasMoreElements()) {
            InputPortNode portNode = (InputPortNode)children.nextElement();
            inputMap.put(portNode.getPort().getName(), portNode.getDataThing());
        }
        return inputMap;
    }

    public abstract void launchEnactorDisplay(Map var1);

    public void attachToModel(ScuflModel model) {
        this.portTree = new JTree(this.treeModel);
        this.portTree.setRowHeight(0);
        this.portTree.setCellRenderer(new InputNodeRenderer());
        this.portTree.setDragEnabled(true);
        this.portTree.getSelectionModel().setSelectionMode(1);
        this.portTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                if (event.getPath().getLastPathComponent() instanceof PanelTreeNode) {
                    PanelTreeNode node = (PanelTreeNode)event.getPath().getLastPathComponent();
                    DataThingConstructionPanel.this.splitter.setRightComponent(node.getPanel());
                    if (node instanceof InputsRootNode) {
                        DataThingConstructionPanel.this.loadInputsButton.setEnabled(false);
                        DataThingConstructionPanel.this.newInputButton.setEnabled(false);
                        DataThingConstructionPanel.this.newListButton.setEnabled(false);
                        DataThingConstructionPanel.this.removeButton.setEnabled(false);
                    } else if (node instanceof InputPortNode) {
                        DataThingConstructionPanel.this.loadInputsButton.setEnabled(true);
                        DataThingConstructionPanel.this.newInputButton.setEnabled(this.canAddInputs((InputListNode)node));
                        DataThingConstructionPanel.this.newListButton.setEnabled(this.canAddLists((InputListNode)node));
                        DataThingConstructionPanel.this.removeButton.setEnabled(false);
                    } else if (node instanceof InputListNode) {
                        DataThingConstructionPanel.this.loadInputsButton.setEnabled(true);
                        DataThingConstructionPanel.this.removeButton.setEnabled(true);
                        InputListNode parent = (InputListNode)((InputListNode)node).getParent();
                        if (parent != null) {
                            boolean canAddList = true;
                            boolean canAddInput = true;
                            for (int index = 0; index < parent.getChildCount(); ++index) {
                                InputListNode aListNode = (InputListNode)parent.getChildAt(index);
                                if (aListNode.getChildCount() <= 0) continue;
                                canAddList = aListNode.getFirstChild() instanceof InputListNode;
                                canAddInput = !canAddList;
                                break;
                            }
                            DataThingConstructionPanel.this.newListButton.setEnabled(canAddList);
                            DataThingConstructionPanel.this.newInputButton.setEnabled(canAddInput);
                        } else {
                            DataThingConstructionPanel.this.newInputButton.setEnabled(false);
                            DataThingConstructionPanel.this.newListButton.setEnabled(false);
                        }
                    } else if (node instanceof InputDataThingNode) {
                        InputDataThingNode thingNode = (InputDataThingNode)node;
                        InputListNode parent = (InputListNode)thingNode.getParent();
                        if (parent == null) {
                            DataThingConstructionPanel.this.newInputButton.setEnabled(false);
                            DataThingConstructionPanel.this.newListButton.setEnabled(false);
                        } else {
                            DataThingConstructionPanel.this.newInputButton.setEnabled(this.canAddInputs(parent));
                            DataThingConstructionPanel.this.newListButton.setEnabled(this.canAddLists(parent));
                        }
                        DataThingConstructionPanel.this.loadInputsButton.setEnabled(true);
                        DataThingConstructionPanel.this.removeButton.setEnabled(true);
                    }
                } else {
                    if (DataThingConstructionPanel.this.splitter.getRightComponent() != null) {
                        DataThingConstructionPanel.this.splitter.remove(DataThingConstructionPanel.this.splitter.getRightComponent());
                    }
                    DataThingConstructionPanel.this.loadInputsButton.setEnabled(false);
                    DataThingConstructionPanel.this.newInputButton.setEnabled(false);
                    DataThingConstructionPanel.this.newListButton.setEnabled(false);
                    DataThingConstructionPanel.this.removeButton.setEnabled(false);
                }
                DataThingConstructionPanel.this.splitter.validate();
            }

            private boolean canAddLists(InputListNode node) {
                return node.getChildCount() <= 0 || !(node.getFirstChild() instanceof InputDataThingNode);
            }

            private boolean canAddInputs(InputListNode node) {
                return node.getChildCount() <= 0 || !(node.getFirstChild() instanceof InputListNode);
            }
        });
        this.portTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    try {
                        PanelTreeNode node = (PanelTreeNode)DataThingConstructionPanel.this.portTree.getPathForLocation(event.getX(), event.getY()).getLastPathComponent();
                        JPopupMenu popup = new JPopupMenu();
                        node.fillMenu(popup);
                        popup.show(event.getComponent(), event.getX(), event.getY());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        new TreeTransferHandler(this.portTree);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.portTree);
        this.splitter = new JSplitPane(1);
        this.splitter.setContinuousLayout(false);
        this.splitter.setLeftComponent(scrollPane);
        this.splitter.setPreferredSize(new Dimension(0, 0));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton runButton = new JButton("Run Workflow", ScuflIcons.runIcon);
        runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Map inputObject = DataThingConstructionPanel.this.bakeInputMap();
                try {
                    DataThingConstructionPanel.this.launchEnactorDisplay(inputObject);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        buttonPanel.add(runButton);
        this.loadInputsButton = new JButton("Load Inputs", ScuflIcons.openIcon);
        this.loadInputsButton.setEnabled(false);
        this.loadInputsButton.addActionListener(this.loadFilesAction);
        this.newInputButton = new JButton("New Input", ScuflIcons.newInputIcon);
        this.newInputButton.setEnabled(false);
        this.newInputButton.addActionListener(this.newInputAction);
        this.newListButton = new JButton("New List", ScuflIcons.newListIcon);
        this.newListButton.setEnabled(false);
        this.newListButton.addActionListener(this.newListAction);
        this.removeButton = new JButton("Remove", ScuflIcons.deleteIcon);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this.removeAction);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add(this.loadInputsButton);
        toolbar.add(this.newInputButton);
        toolbar.add(this.newListButton);
        toolbar.add(this.removeButton);
        this.setLayout(new BorderLayout());
        this.add((Component)toolbar, "North");
        this.add((Component)this.splitter, "Center");
        this.add((Component)buttonPanel, "South");
        this.setVisible(true);
        if (this.model == null) {
            this.model = model;
            model.addListener(this);
            this.updateModel();
        }
    }

    public void detachFromModel() {
        if (this.model != null) {
            this.model.removeListener(this);
            this.model = null;
            this.rootNode.removeAllChildren();
            try {
                this.splitter.remove(this.splitter.getRightComponent());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void updateModel() {
        Port[] inputs = this.model.getWorkflowSourcePorts();
        for (int index = 0; index < inputs.length; ++index) {
            InputPortNode portNode = null;
            for (int nodeIndex = index; nodeIndex < this.rootNode.getChildCount(); ++nodeIndex) {
                InputPortNode tempNode = (InputPortNode)this.rootNode.getChildAt(nodeIndex);
                if (!inputs[index].equals(tempNode.getPort())) continue;
                this.rootNode.remove(nodeIndex);
                portNode = tempNode;
            }
            if (portNode == null) {
                portNode = new InputPortNode(inputs[index]);
            }
            this.rootNode.insert(portNode, index);
        }
        while (this.rootNode.getChildCount() > inputs.length) {
            this.rootNode.remove(inputs.length);
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
    }

    public String getName() {
        return "Run Workflow";
    }

    public ImageIcon getIcon() {
        return ScuflIcons.windowInput;
    }

    public void receiveModelEvent(ScuflModelEvent event) {
        this.updateModel();
    }

    static {
        String storageClassName = System.getProperty("taverna.datastore.class");
        if (storageClassName != null) {
            try {
                Class<?> c = Class.forName(storageClassName);
                store = (BaclavaDataService)c.newInstance();
            }
            catch (Exception ex) {
                System.out.println("Unable to initialize data store class : " + storageClassName);
                ex.printStackTrace();
            }
        }
    }

    private class InputNodeRenderer
    extends DefaultTreeCellRenderer {
        private InputNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof InputPortNode) {
                this.setIcon(ScuflIcons.inputIcon);
            } else if (value instanceof InputDataThingNode) {
                this.setIcon(ScuflIcons.inputValueIcon);
                InputDataThingNode thingNode = (InputDataThingNode)value;
                Object userObject = thingNode.getUserObject();
                String summaryText = "bleh";
                if (userObject instanceof String && (summaryText = (String)userObject).length() > 25) {
                    summaryText = "<html><em>Click to edit...</em></html>";
                }
                this.setText(summaryText);
            } else if (value instanceof InputListNode) {
                if (expanded) {
                    this.setIcon(ScuflIcons.folderOpenIcon);
                } else {
                    this.setIcon(ScuflIcons.folderClosedIcon);
                }
                this.setText("Input List");
            } else if (expanded) {
                this.setIcon(ScuflIcons.folderOpenIcon);
            } else {
                this.setIcon(ScuflIcons.folderClosedIcon);
            }
            return this;
        }
    }

    private class InputDataThingNode
    extends DefaultMutableTreeNode
    implements PanelTreeNode,
    DataThingNode {
        private DataThing thing;
        private JComponent panel;
        JTextArea editor;
        private ActionListener loadURLAction;
        private ActionListener loadFileAction;
        private ActionListener loadLSIDAction;

        public InputDataThingNode(Object inputValue) {
            super(inputValue);
            this.loadURLAction = new ActionListener(this){
                private final /* synthetic */ InputDataThingNode this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    try {
                        String name = (String)JOptionPane.showInputDialog(null, "URL to open?", "URL Required", 3, null, null, "http://");
                        if (name != null) {
                            InputStream is = new URL(name).openStream();
                            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                            StringBuffer sb = new StringBuffer();
                            String s = null;
                            while ((s = reader.readLine()) != null) {
                                sb.append(s);
                                sb.append("\n");
                            }
                            this.this$1.editor.setText(sb.toString());
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Problem opening content from web : \n" + ex.getMessage(), "Exception!", 0);
                    }
                }
            };
            this.loadFileAction = new ActionListener(this){
                private final /* synthetic */ InputDataThingNode this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    try {
                        int returnVal = fileChooser.showOpenDialog(InputDataThingNode.access$100(this.this$1));
                        if (returnVal == 0) {
                            File file = fileChooser.getSelectedFile();
                            BufferedReader reader = new BufferedReader(new FileReader(file));
                            StringBuffer sb = new StringBuffer();
                            String s = null;
                            while ((s = reader.readLine()) != null) {
                                sb.append(s);
                                sb.append("\n");
                            }
                            this.this$1.editor.setText(sb.toString());
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Problem opening content from web : \n" + ex.getMessage(), "Exception!", 0);
                    }
                }
            };
            this.loadLSIDAction = new ActionListener(this){
                private final /* synthetic */ InputDataThingNode this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    try {
                        String lsid = (String)JOptionPane.showInputDialog(null, "LSID to open?", "LSID Required", 3, null, null, "URN:LSID:");
                        if (lsid != null && store != null) {
                            DataThing thing = store.fetchDataThing(lsid);
                            this.this$1.setDataThing(thing);
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Problem opening content from web : \n" + ex.getMessage(), "Exception!", 0);
                    }
                }
            };
        }

        public InputDataThingNode(DataThing thing) {
            super(thing.getDataObject());
            this.loadURLAction = new /* invalid duplicate definition of identical inner class */;
            this.loadFileAction = new /* invalid duplicate definition of identical inner class */;
            this.loadLSIDAction = new /* invalid duplicate definition of identical inner class */;
            this.thing = thing;
        }

        public JComponent getPanel() {
            if (this.panel == null) {
                if (this.getUserObject() instanceof String) {
                    this.editor = new JTextArea();
                    this.editor.setText((String)this.getUserObject());
                    this.editor.getDocument().addDocumentListener(new DocumentListener(this){
                        private final /* synthetic */ InputDataThingNode this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void insertUpdate(DocumentEvent e) {
                            this.this$1.setUserObject(this.this$1.editor.getText());
                            InputDataThingNode.access$100((InputDataThingNode)this.this$1).treeModel.nodeChanged(this.this$1);
                        }

                        public void removeUpdate(DocumentEvent e) {
                            this.this$1.setUserObject(this.this$1.editor.getText());
                            InputDataThingNode.access$100((InputDataThingNode)this.this$1).treeModel.nodeChanged(this.this$1);
                        }

                        public void changedUpdate(DocumentEvent e) {
                            this.this$1.setUserObject(this.this$1.editor.getText());
                            InputDataThingNode.access$100((InputDataThingNode)this.this$1).treeModel.nodeChanged(this.this$1);
                        }
                    });
                    JToolBar toolbar = new JToolBar();
                    JButton loadButton = new JButton("Load", ScuflIcons.openIcon);
                    JButton loadURLButton = new JButton("Load from URL", ScuflIcons.webIcon);
                    loadButton.setToolTipText("Load from File");
                    loadButton.addActionListener(this.loadFileAction);
                    loadURLButton.addActionListener(this.loadURLAction);
                    toolbar.setFloatable(false);
                    toolbar.setRollover(true);
                    toolbar.add(loadButton);
                    toolbar.add(loadURLButton);
                    if (store != null) {
                        JButton loadLSIDButton = new JButton("Load LSID");
                        loadLSIDButton.addActionListener(this.loadLSIDAction);
                        toolbar.add(loadLSIDButton);
                    }
                    JScrollPane scrollPane = new JScrollPane(this.editor);
                    scrollPane.setPreferredSize(new Dimension(0, 0));
                    this.panel = new JPanel(new BorderLayout());
                    this.panel.add((Component)scrollPane, "Center");
                    this.panel.add((Component)toolbar, "North");
                } else if (this.thing != null) {
                    RendererRegistry registry = RendererRegistry.instance();
                    RendererSPI renderer = registry.getRenderer(this.thing);
                    try {
                        this.panel = new JScrollPane(renderer.getComponent(registry, this.thing));
                        this.panel.setPreferredSize(new Dimension(0, 0));
                    }
                    catch (RendererException e) {
                        e.printStackTrace();
                    }
                }
            }
            return this.panel;
        }

        public DataThing getDataThing() {
            DataThing newThing = DataThingFactory.bake(this.getUserObject());
            if (this.thing != null) {
                newThing.copyMetadataFrom(this.thing);
            }
            this.thing = newThing;
            return this.thing;
        }

        public void setDataThing(DataThing thing) {
            this.thing = thing;
            this.setUserObject(thing.getDataObject());
            this.panel = null;
        }

        public String toString() {
            return this.getUserObject().toString();
        }

        public void fillMenu(JPopupMenu menu) {
            JMenuItem removeItem = new JMenuItem("Remove", ScuflIcons.deleteIcon);
            removeItem.addActionListener(DataThingConstructionPanel.this.removeAction);
            JMenuItem loadFileItem = new JMenuItem("Load Input from File", ScuflIcons.openIcon);
            loadFileItem.addActionListener(this.loadFileAction);
            JMenuItem loadURLItem = new JMenuItem("Load Input from URL", ScuflIcons.openIcon);
            loadURLItem.addActionListener(this.loadURLAction);
            menu.add(removeItem);
            menu.add(loadFileItem);
            menu.add(loadURLItem);
            if (store != null) {
                JMenuItem loadLSIDItem = new JMenuItem("Load Input from LSID");
                loadLSIDItem.addActionListener(this.loadLSIDAction);
                menu.add(loadLSIDItem);
            }
        }

        static /* synthetic */ DataThingConstructionPanel access$100(InputDataThingNode x0) {
            return x0.DataThingConstructionPanel.this;
        }
    }

    private class InputPortNode
    extends InputListNode {
        private Port port;
        private JPanel portPanel;

        public InputPortNode(Port port) {
            super(port);
            this.port = port;
        }

        public Port getPort() {
            return this.port;
        }

        public JComponent getPanel() {
            if (this.portPanel == null) {
                this.portPanel = new JPanel(new BorderLayout(3, 3));
                this.portPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                JPanel descriptionPanel = new JPanel();
                StringBuffer sb = new StringBuffer();
                sb.append("<html><h2>Workflow Input : " + this.port.getName() + "</h2>");
                sb.append("<table border=\"1\"><tr><td bgcolor=\"#ddeeff\" colspan=\"2\"><b>Input Metadata</b></td></tr><tr><td bgcolor=\"#ddeeff\"><b>Semantic type</b></td><td>\n");
                if (this.port.getMetadata().getSemanticType() != null && this.port.getMetadata().getSemanticType() != "") {
                    sb.append(this.port.getMetadata().getSemanticType());
                } else {
                    sb.append("<font color=\"#666666\"><i>not specified</i></font>");
                }
                sb.append("</td></tr>\n");
                sb.append("<tr><td bgcolor=\"#ddeeff\"><b>Syntactic type</b></td><td>");
                sb.append(this.port.getSyntacticType());
                sb.append("</td></tr>\n");
                sb.append("<tr><td bgcolor=\"#ddeeff\"colspan=\"2\"><b>Description</b></td></tr>\n");
                sb.append("<tr><td colspan=\"2\">");
                if (this.port.getMetadata().getDescription() != null && this.port.getMetadata().getDescription() != "") {
                    sb.append(this.port.getMetadata().getDescription());
                } else {
                    sb.append("<font color=\"#666666\"><i>no description</i></font>");
                }
                sb.append("</td></tr></table>");
                sb.append("<h2>Instructions</h2><p>To input data into this workflow you must first create either a single item or a list. Having done this you can select the item from the tree to the left of this panel and either enter the data manually, upload from a file on your local machine or load from a location on the internet. When all workflow inputs have been populated as required you can click the 'run workflow' button to run the workflow on these inputs.</p>");
                sb.append("</html>");
                JEditorPane portDetails = new JEditorPane("text/html", sb.toString());
                portDetails.setEditable(false);
                JScrollPane scrollPane = new JScrollPane(portDetails);
                scrollPane.setPreferredSize(new Dimension(0, 0));
                descriptionPanel.setLayout(new BoxLayout(descriptionPanel, 1));
                descriptionPanel.add(scrollPane);
                this.portPanel.add((Component)descriptionPanel, "Center");
            }
            return this.portPanel;
        }

        public String toString() {
            return this.port.toString();
        }

        public void fillMenu(JPopupMenu menu) {
            JMenuItem createItem = new JMenuItem("New Input Value", ScuflIcons.newInputIcon);
            createItem.addActionListener(DataThingConstructionPanel.this.newInputAction);
            JMenuItem createListItem = new JMenuItem("New List", ScuflIcons.newListIcon);
            createListItem.addActionListener(DataThingConstructionPanel.this.newListAction);
            menu.add(createItem);
            menu.add(createListItem);
        }

        public DataThing getDataThing() {
            if (this.getChildCount() == 1) {
                return ((DataThingNode)((Object)this.getFirstChild())).getDataThing();
            }
            return super.getDataThing();
        }
    }

    private class InputListNode
    extends DefaultMutableTreeNode
    implements PanelTreeNode,
    DataThingNode {
        private DataThing thing;

        public InputListNode(Object stuff) {
            super(stuff);
        }

        public InputListNode(DataThing thing) {
            this.thing = thing;
        }

        public JComponent getPanel() {
            this.getDataThing();
            if (this.thing != null) {
                RendererRegistry registry = RendererRegistry.instance();
                RendererSPI renderer = registry.getRenderer(this.thing);
                try {
                    JScrollPane scrollPane = new JScrollPane(renderer.getComponent(registry, this.thing));
                    scrollPane.setPreferredSize(new Dimension(0, 0));
                    return scrollPane;
                }
                catch (RendererException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public void fillMenu(JPopupMenu menu) {
            JMenuItem createItem = new JMenuItem("New Input Value", ScuflIcons.newInputIcon);
            createItem.addActionListener(DataThingConstructionPanel.this.newInputAction);
            JMenuItem createListItem = new JMenuItem("New List", ScuflIcons.newListIcon);
            createListItem.addActionListener(DataThingConstructionPanel.this.newListAction);
            JMenuItem removeItem = new JMenuItem("Remove", ScuflIcons.deleteIcon);
            removeItem.addActionListener(DataThingConstructionPanel.this.removeAction);
            menu.add(createItem);
            menu.add(createListItem);
            menu.add(removeItem);
        }

        public DataThing getDataThing() {
            ArrayList<Object> inputList = new ArrayList<Object>();
            HashMap<Object, DataThing> dataThingList = new HashMap<Object, DataThing>();
            for (int index = 0; index < this.getChildCount(); ++index) {
                DataThingNode inputNode = (DataThingNode)((Object)this.getChildAt(index));
                DataThing childThing = inputNode.getDataThing();
                inputList.add(childThing.getDataObject());
                dataThingList.put(childThing.getDataObject(), childThing);
            }
            DataThing result = DataThingFactory.bake(inputList);
            for (int index = 0; index < inputList.size(); ++index) {
                result.copyMetadataFrom((DataThing)dataThingList.get(inputList.get(index)));
            }
            if (this.thing != null) {
                result.copyMetadataFrom(this.thing);
            }
            this.thing = result;
            return this.thing;
        }

        public void setDataThing(DataThing thing) {
            if (thing != null) {
                Object dataObject = thing.getDataObject();
                if (dataObject instanceof Element) {
                    dataObject = DataThingXMLFactory.configureDataThing((Element)dataObject, thing);
                }
                if (dataObject instanceof Collection) {
                    Iterator iterator = thing.childIterator();
                    while (iterator.hasNext()) {
                        Object next = iterator.next();
                        if (!(next instanceof DataThing)) continue;
                        DataThing childThing = (DataThing)next;
                        this.addDataThing(childThing);
                    }
                } else {
                    this.addDataThing(thing);
                }
                DataThingConstructionPanel.this.treeModel.nodeStructureChanged(this);
                this.thing = thing;
            }
        }

        public void addDataThing(DataThing thing) {
            if (thing.getDataObject() instanceof Collection) {
                InputListNode child = new InputListNode(thing);
                this.add(child);
                child.setDataThing(thing);
            } else {
                InputDataThingNode child = new InputDataThingNode(thing);
                this.add(child);
            }
        }
    }

    private class InputsRootNode
    extends DefaultMutableTreeNode
    implements PanelTreeNode {
        JComponent panel;
        XMLTree xmlTree;
        JScrollPane scrollPane;
        private ActionListener loadInputDocAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int returnVal = fileChooser.showOpenDialog(DataThingConstructionPanel.this);
                    if (returnVal == 0) {
                        File file = fileChooser.getSelectedFile();
                        Document inputDoc = new SAXBuilder(false).build((Reader)new FileReader(file));
                        Map inputMap = DataThingXMLFactory.parseDataDocument(inputDoc);
                        for (int index = 0; index < ((InputsRootNode)this).DataThingConstructionPanel.this.rootNode.getChildCount(); ++index) {
                            InputPortNode portNode = (InputPortNode)((InputsRootNode)this).DataThingConstructionPanel.this.rootNode.getChildAt(index);
                            DataThing thing = (DataThing)inputMap.get(portNode.toString());
                            portNode.removeAllChildren();
                            portNode.addDataThing(thing);
                        }
                        this.getPanel();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Problem opening content from web : \n" + ex.getMessage(), "Exception!", 0);
                }
            }
        };
        private ActionListener saveInputDocAction = new ActionListener(this){
            private final /* synthetic */ InputsRootNode this$1;
            {
                this.this$1 = this$1;
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    int returnVal = fileChooser.showSaveDialog(this.this$1.panel);
                    if (returnVal == 0) {
                        File file = fileChooser.getSelectedFile();
                        FileWriter fileWriter = new FileWriter(file);
                        BufferedWriter writer = new BufferedWriter(fileWriter);
                        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
                        BufferedReader reader = new BufferedReader(new StringReader(outputter.outputString(DataThingXMLFactory.getDataDocument(InputsRootNode.access$000(this.this$1).bakeInputMap()))));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            writer.write(line);
                            writer.newLine();
                        }
                        writer.flush();
                        fileWriter.flush();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Problem opening content from web : \n" + ex.getMessage(), "Exception!", 0);
                }
            }
        };

        private InputsRootNode() {
        }

        public JComponent getPanel() {
            if (this.panel == null) {
                this.panel = new JPanel(new BorderLayout());
                this.scrollPane = new JScrollPane();
                this.scrollPane.setPreferredSize(new Dimension(0, 0));
                JToolBar toolbar = new JToolBar();
                JButton loadInputDocButton = new JButton("Load Input Doc", ScuflIcons.openIcon);
                JButton saveInputDocButton = new JButton("Save Input Doc", ScuflIcons.saveIcon);
                loadInputDocButton.setToolTipText("Load Input Document");
                loadInputDocButton.addActionListener(this.loadInputDocAction);
                saveInputDocButton.setToolTipText("Save Input Document");
                saveInputDocButton.addActionListener(this.saveInputDocAction);
                toolbar.setFloatable(false);
                toolbar.setRollover(true);
                toolbar.add(loadInputDocButton);
                toolbar.add(saveInputDocButton);
                this.panel.add((Component)this.scrollPane, "Center");
                this.panel.add((Component)toolbar, "North");
                this.panel.setPreferredSize(new Dimension(0, 0));
            }
            try {
                this.scrollPane.setViewportView(new XMLTree(DataThingXMLFactory.getDataDocument(DataThingConstructionPanel.this.bakeInputMap())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.panel;
        }

        public void fillMenu(JPopupMenu menu) {
            JMenuItem loadItem = new JMenuItem("Load Input Document", ScuflIcons.openIcon);
            loadItem.addActionListener(this.loadInputDocAction);
            JMenuItem saveItem = new JMenuItem("Save Input Document", new ImageIcon(ClassLoader.getSystemResource("org/embl/ebi/escience/scuflui/workbench/save.gif")));
            saveItem.addActionListener(this.saveInputDocAction);
            menu.add(loadItem);
            menu.add(saveItem);
        }

        public String toString() {
            return "Input Document";
        }
    }

    public class TreeTransferHandler
    implements DropTargetListener {
        private JTree tree;

        public TreeTransferHandler(JTree tree) {
            this.tree = tree;
            new DropTarget(tree, this);
        }

        public boolean canDrop(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(Flavours.DATATHING_FLAVOUR)) {
                try {
                    Point pt = dtde.getLocation();
                    TreePath pathTarget = this.tree.getPathForLocation(pt.x, pt.y);
                    Object targetNode = pathTarget.getLastPathComponent();
                    return targetNode instanceof InputListNode;
                }
                catch (NullPointerException e) {
                    return false;
                }
            }
            return dtde.isDataFlavorSupported(Flavours.LSID_FLAVOUR);
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            int action = dtde.getDropAction();
            if (this.canDrop(dtde)) {
                dtde.acceptDrag(action);
            } else {
                dtde.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            int action = dtde.getDropAction();
            if (this.canDrop(dtde)) {
                dtde.acceptDrag(action);
            } else {
                dtde.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                int action = dtde.getDropAction();
                Transferable transferable = dtde.getTransferable();
                Point pt = dtde.getLocation();
                TreePath pathTarget = this.tree.getPathForLocation(pt.x, pt.y);
                TreeNode targetNode = (TreeNode)pathTarget.getLastPathComponent();
                if (this.executeDrop(targetNode, transferable, action)) {
                    dtde.acceptDrop(action);
                    dtde.dropComplete(true);
                    return;
                }
                dtde.rejectDrop();
                dtde.dropComplete(false);
            }
            catch (Exception e) {
                System.out.println(e);
                dtde.rejectDrop();
                dtde.dropComplete(false);
            }
        }

        private boolean executeDrop(TreeNode targetNode, Transferable transferable, int action) {
            if (transferable.isDataFlavorSupported(Flavours.DATATHING_FLAVOUR) && targetNode instanceof InputListNode) {
                try {
                    String elementText = (String)transferable.getTransferData(Flavours.DATATHING_FLAVOUR);
                    Document inputDoc = new SAXBuilder(false).build((Reader)new StringReader(elementText));
                    DataThing thing = new DataThing(inputDoc.getRootElement());
                    InputListNode node = (InputListNode)targetNode;
                    node.setDataThing(thing);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        public void dragExit(DropTargetEvent dte) {
        }
    }

    private static interface DataThingNode {
        public DataThing getDataThing();
    }

    private static interface PanelTreeNode {
        public JComponent getPanel();

        public void fillMenu(JPopupMenu var1);
    }
}

