/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.view;

import java.io.Serializable;
import java.util.Iterator;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.AnnotationTemplate;
import org.embl.ebi.escience.scufl.ConcurrencyConstraint;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.IterationStrategy;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.WorkflowDescription;
import org.embl.ebi.escience.scufl.XScufl;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XScuflView
implements ScuflModelEventListener,
Serializable {
    private ScuflModel model = null;
    private boolean cacheValid = false;
    private String cachedRepresentation = null;
    private Document cachedDocument = null;

    public XScuflView(ScuflModel model) {
        this.model = model;
        this.cacheValid = false;
        this.model.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument() {
        XScuflView xScuflView = this;
        synchronized (xScuflView) {
            if (!this.cacheValid) {
                this.updateCachedView();
            }
            return this.cachedDocument;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLText() {
        XScuflView xScuflView = this;
        synchronized (xScuflView) {
            if (!this.cacheValid) {
                this.updateCachedView();
            }
            return this.cachedRepresentation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveModelEvent(ScuflModelEvent event) {
        XScuflView xScuflView = this;
        synchronized (xScuflView) {
            this.cacheValid = false;
        }
    }

    private void updateCachedView() {
        Element root = new Element("scufl", this.scuflNS());
        root.setAttribute("version", "0.2");
        root.setAttribute("log", "" + this.model.getLogLevel());
        this.cachedDocument = new Document(root);
        WorkflowDescription wd = this.model.getDescription();
        root.addContent((Content)WorkflowDescription.getElement(wd));
        Processor[] processors = this.model.getProcessors();
        for (int i = 0; i < processors.length; ++i) {
            String description;
            Element processor = new Element("processor", this.scuflNS());
            processor.setAttribute("name", processors[i].getName());
            if (processors[i].getRealLogLevel() > -1) {
                processor.setAttribute("log", "" + processors[i].getLogLevel());
            }
            if (!(description = processors[i].getDescription()).equals("")) {
                Element de = new Element("description", this.scuflNS());
                de.setText(description);
                processor.addContent((Content)de);
            }
            Element spec = ProcessorHelper.elementForProcessor(processors[i]);
            processor.addContent((Content)spec);
            IterationStrategy iterationStrategy = processors[i].getIterationStrategy();
            if (iterationStrategy != null && processors[i].getInputPorts().length > 0) {
                processor.addContent((Content)iterationStrategy.getElement());
            }
            AnnotationTemplate[] templates = processors[i].getAnnotationTemplates();
            for (int j = 0; j < templates.length; ++j) {
                processor.addContent((Content)templates[j].getElement());
            }
            AlternateProcessor[] ap = processors[i].getAlternatesArray();
            for (int j = 0; j < ap.length; ++j) {
                Element mappingElement;
                String value;
                String key;
                Element alternateElement = new Element("alternate", XScufl.XScuflNS);
                Processor alternateProcessor = ap[j].getProcessor();
                alternateElement.addContent((Content)ProcessorHelper.elementForProcessor(alternateProcessor));
                Iterator ii = ap[j].getOutputMapping().keySet().iterator();
                while (ii.hasNext()) {
                    key = (String)ii.next();
                    value = (String)ap[j].getOutputMapping().get(key);
                    mappingElement = new Element("outputmap", XScufl.XScuflNS);
                    mappingElement.setAttribute("key", key);
                    mappingElement.setAttribute("value", value);
                    alternateElement.addContent((Content)mappingElement);
                }
                ii = ap[j].getInputMapping().keySet().iterator();
                while (ii.hasNext()) {
                    key = (String)ii.next();
                    value = (String)ap[j].getInputMapping().get(key);
                    mappingElement = new Element("inputmap", XScufl.XScuflNS);
                    mappingElement.setAttribute("key", key);
                    mappingElement.setAttribute("value", value);
                    alternateElement.addContent((Content)mappingElement);
                }
                processor.addContent((Content)alternateElement);
            }
            root.addContent((Content)processor);
        }
        DataConstraint[] dataconstraints = this.model.getDataConstraints();
        for (int i = 0; i < dataconstraints.length; ++i) {
            DataConstraint dc = dataconstraints[i];
            String sourceProcessorName = dc.getSource().getProcessor().getName();
            String sourcePortName = dc.getSource().getName();
            String sinkProcessorName = dc.getSink().getProcessor().getName();
            String sinkPortName = dc.getSink().getName();
            Element link = new Element("link", this.scuflNS());
            if (dc.getSink().getProcessor() != this.model.getWorkflowSinkProcessor()) {
                sinkPortName = sinkProcessorName + ":" + sinkPortName;
            }
            if (dc.getSource().getProcessor() != this.model.getWorkflowSourceProcessor()) {
                sourcePortName = sourceProcessorName + ":" + sourcePortName;
            }
            link.setAttribute("source", sourcePortName);
            link.setAttribute("sink", sinkPortName);
            Element inputNode = new Element("input", this.scuflNS());
            inputNode.setText(sinkPortName);
            Element outputNode = new Element("output", this.scuflNS());
            outputNode.setText(sourcePortName);
            root.addContent((Content)link);
        }
        Port[] sources = this.model.getWorkflowSourceProcessor().getPorts();
        for (int i = 0; i < sources.length; ++i) {
            Element sourceElement = new Element("source", this.scuflNS());
            sourceElement.setAttribute("name", sources[i].getName());
            Element metadataElement = sources[i].getMetadata().getConfigurationElement();
            if (!metadataElement.getChildren().isEmpty()) {
                sourceElement.addContent((Content)metadataElement);
            }
            root.addContent((Content)sourceElement);
        }
        Port[] sinks = this.model.getWorkflowSinkProcessor().getPorts();
        for (int i = 0; i < sinks.length; ++i) {
            Element sinkElement = new Element("sink", this.scuflNS());
            sinkElement.setAttribute("name", sinks[i].getName());
            Element metadataElement = sinks[i].getMetadata().getConfigurationElement();
            if (!metadataElement.getChildren().isEmpty()) {
                sinkElement.addContent((Content)metadataElement);
            }
            root.addContent((Content)sinkElement);
        }
        ConcurrencyConstraint[] constraints = this.model.getConcurrencyConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            Element coordination = new Element("coordination", this.scuflNS());
            coordination.setAttribute("name", constraints[i].getName());
            root.addContent((Content)coordination);
            Element condition = new Element("condition", this.scuflNS());
            Element action = new Element("action", this.scuflNS());
            coordination.addContent((Content)condition);
            coordination.addContent((Content)action);
            Element state = new Element("state", this.scuflNS());
            state.setText(ConcurrencyConstraint.statusCodeToString(constraints[i].getControllerStateGuard()));
            condition.addContent((Content)state);
            Element ctarget = new Element("target", this.scuflNS());
            ctarget.setText(constraints[i].getControllingProcessor().getName());
            condition.addContent((Content)ctarget);
            Element target = new Element("target", this.scuflNS());
            target.setText(constraints[i].getTargetProcessor().getName());
            action.addContent((Content)target);
            Element statechange = new Element("statechange", this.scuflNS());
            action.addContent((Content)statechange);
            Element from = new Element("from", this.scuflNS());
            Element to = new Element("to", this.scuflNS());
            from.setText(ConcurrencyConstraint.statusCodeToString(constraints[i].getTargetStateFrom()));
            to.setText(ConcurrencyConstraint.statusCodeToString(constraints[i].getTargetStateTo()));
            statechange.addContent((Content)from);
            statechange.addContent((Content)to);
        }
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        this.cachedRepresentation = xo.outputString(this.cachedDocument);
        this.cacheValid = true;
    }

    private Namespace scuflNS() {
        return XScufl.XScuflNS;
    }
}

