/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.view;

import javax.swing.tree.DefaultMutableTreeNode;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.view.TreeModelView;
import org.embl.ebi.escience.treetable.TreeTableModel;

public class TreeTableModelView
extends TreeModelView
implements TreeTableModel {
    private static String[] columnNames = new String[]{"Workflow object", "Retries", "Delay", "Backoff", "Critical"};
    private static Class[] columnClasses = new Class[]{TreeTableModel.class, Integer.class, Integer.class, Double.class, Boolean.class};

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int column) {
        return columnNames[column];
    }

    public Class getColumnClass(int column) {
        return columnClasses[column];
    }

    public Object getValueAt(Object nodeObject, int column) {
        if (nodeObject == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        Processor p = null;
        if (node.getUserObject() instanceof Processor) {
            p = (Processor)node.getUserObject();
        } else if (node.getUserObject() instanceof AlternateProcessor) {
            p = ((AlternateProcessor)node.getUserObject()).getProcessor();
        }
        switch (column) {
            case 0: {
                return node.getUserObject().toString();
            }
            case 1: {
                if (p != null) {
                    return new Integer(p.getRetries());
                }
            }
            case 2: {
                if (p != null) {
                    return new Integer(p.getRetryDelay());
                }
            }
            case 3: {
                if (p != null) {
                    return new Double(p.getBackoff());
                }
            }
            case 4: {
                if (p == null) break;
                return new Boolean(p.getCritical());
            }
        }
        return null;
    }

    public boolean isCellEditable(Object nodeObject, int column) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        if (node == null) {
            return false;
        }
        Processor p = null;
        if (node.getUserObject() instanceof Processor) {
            p = (Processor)node.getUserObject();
        } else if (node.getUserObject() instanceof AlternateProcessor) {
            p = ((AlternateProcessor)node.getUserObject()).getProcessor();
        }
        if (column == 0) {
            if (node.getUserObject() instanceof Processor) {
                return true;
            }
            if (node.getUserObject() instanceof Port) {
                Port port = (Port)node.getUserObject();
                if (port.isSource() || port.isSink()) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return p != null;
    }

    public void setValueAt(Object value, Object nodeObject, int column) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeObject;
        Processor p = null;
        if (node.getUserObject() instanceof Processor) {
            p = (Processor)node.getUserObject();
        } else if (node.getUserObject() instanceof AlternateProcessor) {
            p = ((AlternateProcessor)node.getUserObject()).getProcessor();
        }
        if (p != null) {
            switch (column) {
                case 0: {
                    p.setName((String)value);
                    return;
                }
                case 1: {
                    Integer retries = (Integer)value;
                    p.setRetries(retries);
                    return;
                }
                case 2: {
                    Integer retryDelay = (Integer)value;
                    p.setRetryDelay(retryDelay);
                    return;
                }
                case 3: {
                    Double backoff = (Double)value;
                    p.setBackoff(backoff);
                    return;
                }
                case 4: {
                    p.setCritical((Boolean)value);
                    return;
                }
            }
        } else if (node.getUserObject() instanceof Port) {
            Port thePort = (Port)node.getUserObject();
            Processor theProcessor = thePort.getProcessor();
            ScuflModel model = theProcessor.getModel();
            if (thePort.isSource() || thePort.isSink()) {
                thePort.setName((String)value);
            }
        }
    }

    public void receiveModelEvent(ScuflModelEvent event) {
        super.receiveModelEvent(event);
    }
}

