/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.view;

import java.io.Serializable;
import org.embl.ebi.escience.scufl.ConcurrencyConstraint;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;

public class DotView
implements ScuflModelEventListener,
Serializable {
    private ScuflModel model = null;
    private boolean cacheValid = false;
    private String cachedRepresentation = null;
    private int portDisplay = 2;
    private boolean displayTypes = true;
    private boolean lralign = false;
    public static final int ALL = 0;
    public static final int BOUND = 1;
    public static final int NONE = 2;

    public DotView(ScuflModel model) {
        this.model = model;
        this.cacheValid = false;
        this.model.addListener(this);
    }

    public void setAlignment(boolean alignment) {
        if (alignment != this.lralign) {
            this.cacheValid = false;
            this.lralign = alignment;
        }
    }

    public boolean getAlignment() {
        return this.lralign;
    }

    public void setPortDisplay(int policy) {
        this.cacheValid = false;
        this.portDisplay = policy;
        this.lralign = policy == 0;
    }

    public void setTypeLabelDisplay(boolean display) {
        this.displayTypes = display;
    }

    public boolean getTypeLabelDisplay() {
        return this.displayTypes;
    }

    public String getDot() {
        if (!this.cacheValid) {
            this.generateDot();
        }
        return this.cachedRepresentation;
    }

    private String q(String name) {
        return "\"" + name + "\"";
    }

    void generateDot() {
        StringBuffer dot = new StringBuffer();
        dot.append("digraph scufl_graph {\n");
        dot.append(" graph [             \n");
        dot.append("  style=\"\"         \n");
        if (System.getProperty("taverna.scufldiagram.ranksep") != null) {
            dot.append("  ranksep=\"" + System.getProperty("taverna.scufldiagram.ranksep") + "\"\n");
        }
        if (System.getProperty("taverna.scufldiagram.nodesep") != null) {
            dot.append("  nodesep=\"" + System.getProperty("taverna.scufldiagram.nodesep") + "\"\n");
        }
        if (this.lralign) {
            dot.append("  rankdir=\"LR\"     \n");
        }
        dot.append(" ]                   \n");
        dot.append(" node [              \n");
        dot.append("  fontname=\"Helvetica\",         \n");
        dot.append("  fontsize=\"10\",              \n");
        dot.append("  fontcolor=\"black\",  \n");
        if (this.portDisplay == 0 || this.portDisplay == 1) {
            dot.append("  shape=\"record\",             \n");
        } else {
            dot.append("  shape=\"box\",                \n");
            dot.append("  height=\"0\",\n");
            dot.append("  width=\"0\",\n");
        }
        dot.append("  color=\"black\",               \n");
        dot.append("  fillcolor=\"lightgoldenrodyellow\",\n");
        dot.append("  style=\"filled\"  \n");
        dot.append(" ];\n\n");
        dot.append(" edge [                         \n");
        dot.append("  fontname=\"Helvetica\",         \n");
        dot.append("  fontsize=\"8\",              \n");
        dot.append("  fontcolor=\"black\",  \n");
        dot.append("  color=\"black\"                \n");
        dot.append(" ];\n\n");
        Processor[] processors = this.model.getProcessors();
        for (int i = 0; i < processors.length; ++i) {
            Processor p = processors[i];
            dot.append(" " + this.q(p.getName()) + " [ \n");
            dot.append("  fillcolor = \"" + ProcessorHelper.getPreferredColour(p) + "\",\n");
            dot.append("  label = \"");
            if (this.portDisplay == 0 || this.portDisplay == 1) {
                if (this.portDisplay == 0) {
                    if (p.getAlternatesList().isEmpty()) {
                        dot.append("{" + p.getName() + "}|{");
                    } else {
                        dot.append("{" + p.getName() + "\\n" + p.getAlternatesList().size() + " alternate");
                        if (p.getAlternatesList().size() != 1) {
                            dot.append("s");
                        }
                        dot.append("}|{");
                    }
                } else {
                    dot.append("{");
                }
                InputPort[] inputs = null;
                inputs = this.portDisplay == 0 ? p.getInputPorts() : p.getBoundInputPorts();
                dot.append("{");
                for (int j = 0; j < inputs.length; ++j) {
                    dot.append("<" + inputs[j].getName() + ">" + inputs[j].getName());
                    if (j >= inputs.length - 1) continue;
                    dot.append("|");
                }
                dot.append("}|");
                if (this.portDisplay == 1) {
                    if (p.getAlternatesList().isEmpty()) {
                        dot.append(p.getName() + "|");
                    } else {
                        dot.append(p.getName() + "\\n" + p.getAlternatesList().size() + " alternate");
                        if (p.getAlternatesList().size() != 1) {
                            dot.append("s");
                        }
                        dot.append("|");
                    }
                }
                OutputPort[] outputs = null;
                outputs = this.portDisplay == 0 ? p.getOutputPorts() : p.getBoundOutputPorts();
                dot.append("{");
                for (int j = 0; j < outputs.length; ++j) {
                    dot.append("<" + outputs[j].getName() + ">" + outputs[j].getName());
                    if (j >= outputs.length - 1) continue;
                    dot.append("|");
                }
                dot.append("}");
                dot.append("}");
            } else {
                dot.append(p.getName());
            }
            dot.append("\"\n");
            dot.append(" ];\n");
        }
        DataConstraint[] links = this.model.getDataConstraints();
        for (int i = 0; i < links.length; ++i) {
            DataConstraint dc = links[i];
            String sourcePortName = dc.getSource().getName();
            String sourceProcessorName = dc.getSource().getProcessor().getName();
            String sinkPortName = dc.getSink().getName();
            String sinkProcessorName = dc.getSink().getProcessor().getName();
            if (dc.getSource().getProcessor() != this.model.getWorkflowSourceProcessor() && dc.getSink().getProcessor() != this.model.getWorkflowSinkProcessor()) {
                if (this.portDisplay == 0 || this.portDisplay == 1) {
                    dot.append(" " + this.q(sourceProcessorName) + ":" + sourcePortName + "->" + this.q(sinkProcessorName) + ":" + sinkPortName + " [ \n");
                } else {
                    dot.append(" " + this.q(sourceProcessorName) + "->" + this.q(sinkProcessorName) + " [ \n");
                }
            } else if (dc.getSource().getProcessor() == this.model.getWorkflowSourceProcessor()) {
                dot.append(this.q("WORKFLOWINTERNALSOURCE_" + sourcePortName) + "->" + this.q(sinkProcessorName) + ":" + sinkPortName + " [ \n");
            } else if (dc.getSink().getProcessor() == this.model.getWorkflowSinkProcessor()) {
                dot.append(this.q(sourceProcessorName) + ":" + sourcePortName + "->" + this.q("WORKFLOWINTERNALSINK_" + sinkPortName) + " [ \n");
            }
            if (this.displayTypes) {
                dot.append("  label = \"" + dc.getSource().getSyntacticType() + "\\n" + dc.getSink().getSyntacticType() + "\"");
            }
            dot.append(" ];\n");
        }
        Port[] sources = this.model.getWorkflowSourceProcessor().getPorts();
        dot.append(" subgraph cluster_sources {\n");
        dot.append("  style=\"dotted\"\n");
        dot.append("  label=\"Workflow Inputs\"\n");
        dot.append("  fontname=\"Helvetica\"         \n");
        dot.append("  fontsize=\"10\"              \n");
        dot.append("  fontcolor=\"black\"  \n");
        dot.append("  rank=\"same\"\n");
        for (int i = 0; i < sources.length; ++i) {
            dot.append(this.q("WORKFLOWINTERNALSOURCE_" + sources[i].getName()) + " [\n");
            if (this.portDisplay != 2) {
                dot.append("   shape=\"invtriangle\",\n");
            } else {
                dot.append("   shape=\"box\",\n");
            }
            dot.append("   width=\"0\",\n");
            dot.append("   height=\"0\",\n");
            dot.append("   fillcolor=\"skyblue\",\n");
            dot.append("   label=\"" + sources[i].getName() + "\"\n");
            dot.append("  ]\n");
        }
        dot.append(" }\n");
        dot.append(" subgraph cluster_sinks {\n");
        dot.append("  style=\"dotted\"\n");
        dot.append("  label=\"Workflow Outputs\"\n");
        dot.append("  fontname=\"Helvetica\"\n");
        dot.append("  fontsize=\"10\"\n");
        dot.append("  fontcolor=\"black\"  \n");
        dot.append("  rank=\"same\"\n");
        Port[] sinks = this.model.getWorkflowSinkProcessor().getPorts();
        for (int i = 0; i < sinks.length; ++i) {
            dot.append(this.q("WORKFLOWINTERNALSINK_" + sinks[i].getName()) + " [\n");
            if (this.portDisplay != 2) {
                dot.append("   shape=\"triangle\",\n");
            } else {
                dot.append("   shape=\"box\",\n");
            }
            dot.append("   width=\"0\",\n");
            dot.append("   height=\"0\",\n");
            dot.append("   fillcolor=\"lightsteelblue2\",\n");
            dot.append("   label=\"" + sinks[i].getName() + "\"\n");
            dot.append("  ]\n");
        }
        dot.append(" }\n");
        ConcurrencyConstraint[] cc = this.model.getConcurrencyConstraints();
        for (int i = 0; i < cc.length; ++i) {
            ConcurrencyConstraint c = cc[i];
            if (this.portDisplay != 2 && this.displayTypes) {
                dot.append(" constraint" + c.getName() + " [\n");
                dot.append("  shape=\"rectangle\",\n");
                dot.append("  fillcolor=\"white\",\n");
                dot.append("  height=\"0\",\n");
                dot.append("  width=\"0\",\n");
                dot.append("  color=\"gray\",\n");
                dot.append("  label=\"coordination\"\n");
                dot.append(" ]\n");
                dot.append(" " + this.q(c.getControllingProcessor().getName()) + "->" + this.q("constraint" + c.getName()) + " [\n");
                dot.append("  arrowhead=\"none\",\n");
                dot.append("  arrowtail=\"dot\",\n");
                dot.append("  color=\"gray\",\n");
                dot.append("  fontcolor=\"brown\",\n");
                dot.append("  label=\"" + ConcurrencyConstraint.statusCodeToString(c.getControllerStateGuard()) + "\"\n");
                dot.append(" ]\n");
                dot.append(this.q("constraint" + c.getName()) + "->" + this.q(c.getTargetProcessor().getName()) + " [\n");
                dot.append("  arrowhead=\"odot\",\n");
                dot.append("  arrowtail=\"none\",\n");
                dot.append("  color=\"gray\",\n");
                dot.append("  fontcolor=\"darkgreen\",\n");
                String stateChangeLabel = "from:" + ConcurrencyConstraint.statusCodeToString(c.getTargetStateFrom()) + "\\nto:" + ConcurrencyConstraint.statusCodeToString(c.getTargetStateTo());
                dot.append("  label=\"" + stateChangeLabel + "\"\n");
                dot.append(" ];\n");
                continue;
            }
            dot.append(" " + this.q(c.getControllingProcessor().getName()) + "->" + this.q(c.getTargetProcessor().getName()) + " [\n");
            dot.append("  color=\"gray\",\n");
            dot.append("  arrowhead=\"odot\",\n");
            dot.append("  arrowtail=\"none\"\n");
            dot.append(" ];\n");
        }
        dot.append("}\n");
        this.cachedRepresentation = dot.toString();
    }

    public void receiveModelEvent(ScuflModelEvent event) {
        this.cacheValid = false;
    }
}

