/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.embl.ebi.escience.scufl.XScufl;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class Scufl2XScuflParser {
    public static InputStream parse(InputStream input) throws IOException {
        StringBuffer inputBuffer = new StringBuffer();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(input));
        String s = null;
        while ((s = dis.readLine()) != null) {
            inputBuffer.append(s);
            inputBuffer.append("\n");
        }
        Document document = Scufl2XScuflParser.parseScufl(inputBuffer.toString());
        XMLOutputter xo = new XMLOutputter();
        xo.setIndent("  ");
        xo.setNewlines(true);
        String outputString = xo.outputString(document);
        return new ByteArrayInputStream(outputString.getBytes());
    }

    public static String parse(String input) {
        Document document = Scufl2XScuflParser.parseScufl(input);
        XMLOutputter xo = new XMLOutputter();
        xo.setIndent("  ");
        xo.setNewlines(true);
        String outputString = xo.outputString(document);
        return outputString;
    }

    public static Document parseScufl(String scufl) {
        Element root = new Element("scufl", Scufl2XScuflParser.scuflNS());
        Document document = new Document(root);
        root.setAttribute("version", "0.1");
        String[] lines = scufl.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            Scufl2XScuflParser.doLine(lines[i], root);
        }
        return document;
    }

    private static void doLine(String line, Element root) {
        String[] tokens = line.split(" ");
        if (tokens.length == 0) {
            return;
        }
        if (tokens[0].equalsIgnoreCase("define")) {
            if (tokens.length != 6) {
                throw new RuntimeException("Incorrect number of tokens for processor definition.");
            }
            Scufl2XScuflParser.doProcessorDefinition(tokens[2], tokens[4], tokens[5], root);
            return;
        }
        if (tokens[0].equalsIgnoreCase("read")) {
            if (tokens.length != 4) {
                throw new RuntimeException("Incorrect number of tokens for link definition.");
            }
            Scufl2XScuflParser.doLinkDefinition(tokens[1], tokens[3], root);
            return;
        }
        if (tokens[0].equalsIgnoreCase("block")) {
            if (tokens.length != 10) {
                throw new RuntimeException("Incorrect number of tokens for constraint definition.");
            }
            Scufl2XScuflParser.doCoordinationDefinition(tokens[1], tokens[3], tokens[5], tokens[7], tokens[9], root);
            return;
        }
    }

    private static void doProcessorDefinition(String name, String protocol, String specifier, Element root) {
        Element processor = new Element("processor", Scufl2XScuflParser.scuflNS());
        processor.setAttribute("name", name);
        Element spec = new Element(protocol, Scufl2XScuflParser.scuflNS());
        spec.setText(specifier);
        processor.addContent((Content)spec);
        root.addContent((Content)processor);
    }

    private static void doLinkDefinition(String input, String output, Element root) {
        Element link = new Element("link", Scufl2XScuflParser.scuflNS());
        Element inputnode = new Element("input", Scufl2XScuflParser.scuflNS());
        inputnode.setText(input);
        Element outputnode = new Element("output", Scufl2XScuflParser.scuflNS());
        outputnode.setText(output);
        link.addContent((Content)inputnode);
        link.addContent((Content)outputnode);
        root.addContent((Content)link);
    }

    private static void doCoordinationDefinition(String name1, String state1, String state2, String name2, String state3, Element root) {
        Element coordination = new Element("coordination", Scufl2XScuflParser.scuflNS());
        Element action = new Element("action", Scufl2XScuflParser.scuflNS());
        Element condition = new Element("condition", Scufl2XScuflParser.scuflNS());
        coordination.addContent((Content)action);
        coordination.addContent((Content)condition);
        Element target = new Element("target", Scufl2XScuflParser.scuflNS());
        target.setText(name1);
        action.addContent((Content)target);
        Element statechange = new Element("statechange", Scufl2XScuflParser.scuflNS());
        Element fromstate = new Element("from", Scufl2XScuflParser.scuflNS());
        Element tostate = new Element("to", Scufl2XScuflParser.scuflNS());
        fromstate.setText(state1);
        tostate.setText(state2);
        statechange.addContent((Content)fromstate);
        statechange.addContent((Content)tostate);
        action.addContent((Content)statechange);
        Element target2 = new Element("target", Scufl2XScuflParser.scuflNS());
        target2.setText(name2);
        Element targetstate = new Element("state", Scufl2XScuflParser.scuflNS());
        targetstate.setText(state3);
        condition.addContent((Content)target2);
        condition.addContent((Content)targetstate);
        root.addContent((Content)coordination);
    }

    public static Namespace scuflNS() {
        return XScufl.XScuflNS;
    }
}

