/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.enactor.implementation;

import java.net.URL;
import java.util.Map;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.enactor.EnactorProxy;
import org.embl.ebi.escience.scufl.enactor.UserContext;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.WorkflowSubmissionException;
import org.embl.ebi.escience.scufl.enactor.implementation.WorkflowInstanceImpl;
import uk.ac.soton.itinnovation.freefluo.main.Engine;
import uk.ac.soton.itinnovation.freefluo.main.EngineImpl;
import uk.ac.soton.itinnovation.freefluo.main.EngineStub;

public class FreefluoEnactorProxy
implements EnactorProxy {
    private Engine engine = null;
    private static EnactorProxy staticInstance = null;

    public static EnactorProxy getInstance() {
        if (staticInstance == null) {
            staticInstance = new FreefluoEnactorProxy();
        }
        return staticInstance;
    }

    public FreefluoEnactorProxy() {
        String enactorEndpoint = System.getProperty("mygrid.enactor.soap.endpoint");
        if (enactorEndpoint != null) {
            try {
                this.engine = new EngineStub(new URL(enactorEndpoint));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.engine = new EngineImpl();
        }
    }

    public WorkflowInstance compileWorkflow(ScuflModel workflow, Map input, UserContext user) throws WorkflowSubmissionException {
        WorkflowInstance workflowInstance = this.compileWorkflow(workflow, user);
        workflowInstance.setInputs(input);
        return workflowInstance;
    }

    public WorkflowInstance compileWorkflow(ScuflModel workflow, UserContext user) throws WorkflowSubmissionException {
        try {
            String workflowInstanceId = this.engine.compile(workflow);
            this.engine.setUserContext(workflowInstanceId, user);
            WorkflowInstanceImpl workflowInstance = new WorkflowInstanceImpl(this.engine, workflowInstanceId);
            String definitionLSID = workflow.getDescription().getLSID();
            String instanceLSID = workflowInstance.getID();
            WorkflowInstanceImpl.instanceToDefinitionLSID.put(instanceLSID, definitionLSID);
            return workflowInstance;
        }
        catch (Exception e) {
            WorkflowSubmissionException wse = new WorkflowSubmissionException("Error during submission of workflow to in memory freefluo enactor");
            wse.initCause(e);
            throw wse;
        }
    }
}

