/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.enactor.event;

import java.util.Iterator;
import java.util.Map;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.enactor.UserContext;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowInstanceEvent;
import org.embl.ebi.escience.scufl.enactor.implementation.WorkflowInstanceImpl;
import org.embl.ebi.escience.scufl.view.XScuflView;

public class WorkflowCreationEvent
extends WorkflowInstanceEvent {
    private Map inputs;
    private String defn;
    private ScuflModel model;

    public WorkflowCreationEvent(WorkflowInstance workflow, Map inputs, String definitionLSID) {
        super(workflow);
        this.defn = definitionLSID;
        this.inputs = inputs;
        if (workflow instanceof WorkflowInstanceImpl) {
            this.model = ((WorkflowInstanceImpl)workflow).getWorkflowModel();
        }
    }

    public Map getInputs() {
        return this.inputs;
    }

    public String getDefinitionLSID() {
        return this.defn;
    }

    public ScuflModel getModel() {
        return this.model;
    }

    public String getModelXML() {
        if (this.model != null) {
            XScuflView xsv = new XScuflView(this.model);
            String xml = xsv.getXMLText();
            this.model.removeListener(xsv);
            return xml;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Workflow '" + this.workflowInstance.getID() + "' created with " + this.inputs.size() + " input" + (this.inputs.size() != 1 ? "s" : "") + "\n");
        Iterator i = this.inputs.keySet().iterator();
        while (i.hasNext()) {
            String inputName = (String)i.next();
            DataThing inputValue = (DataThing)this.inputs.get(inputName);
            String inputLSID = inputValue.getLSID(inputValue.getDataObject());
            sb.append("  '" + inputName + "'->" + inputLSID + "\n");
        }
        sb.append("Created from workflow definition " + this.model.getDescription().getLSID() + "\n");
        UserContext workflowContext = this.workflowInstance.getUserContext();
        if (workflowContext == null) {
            sb.append("No user context supplied\n");
        } else {
            sb.append("Workflow context :\n");
            sb.append("  'Person'->" + workflowContext.getPersonLSID() + "\n");
            sb.append("  'ExperimentDesign'->" + workflowContext.getExperimentDesignLSID() + "\n");
            sb.append("  'Organization'->" + workflowContext.getOrganizationLSID() + "\n");
        }
        return sb.toString();
    }
}

