/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.enactor.event;

import java.util.Iterator;
import java.util.Map;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowInstanceEvent;

public class ProcessCompletionEvent
extends WorkflowInstanceEvent {
    private boolean isIterating;
    private Map inputMap;
    private Map outputMap;
    private Processor processor;

    public ProcessCompletionEvent(boolean isIterating, Map inputs, Map outputs, Processor proc, WorkflowInstance workflow) {
        super(workflow);
        this.isIterating = isIterating;
        this.inputMap = inputs;
        this.outputMap = outputs;
        this.processor = proc;
    }

    public boolean isIterating() {
        return this.isIterating;
    }

    public Map getInputMap() {
        return this.inputMap;
    }

    public Map getOutputMap() {
        return this.outputMap;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public String toString() {
        String mainLSID;
        StringBuffer sb = new StringBuffer();
        sb.append("Process '" + this.processor.getName() + "' complete ");
        if (this.isIterating) {
            sb.append("(iterating)");
        } else {
            sb.append("(simple)");
        }
        sb.append("\n");
        String prefix = "in  ";
        Iterator i = this.inputMap.keySet().iterator();
        while (i.hasNext()) {
            String inputKey = (String)i.next();
            DataThing inputThing = (DataThing)this.inputMap.get(inputKey);
            mainLSID = inputThing.getLSID(inputThing.getDataObject());
            sb.append(prefix + "'" + inputKey + "'->" + mainLSID + "\n");
            prefix = "    ";
        }
        prefix = "out ";
        i = this.outputMap.keySet().iterator();
        while (i.hasNext()) {
            String outputKey = (String)i.next();
            DataThing outputThing = (DataThing)this.outputMap.get(outputKey);
            mainLSID = outputThing.getLSID(outputThing.getDataObject());
            sb.append(prefix + "" + mainLSID + "->'" + outputKey + "'\n");
            prefix = "    ";
        }
        return sb.toString();
    }
}

