/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.enactor.event;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowInstanceEvent;

public class IterationCompletionEvent
extends WorkflowInstanceEvent {
    private Processor processor;
    private Map structureMapping;
    private Map inputShredding;
    private Map inputMap;
    private Map outputMap;

    public IterationCompletionEvent(Map structureMapping, Map inputShredding, WorkflowInstance wf, Processor activeProcessor, Map inputs, Map outputs) {
        super(wf);
        this.structureMapping = structureMapping;
        this.inputShredding = inputShredding;
        this.processor = activeProcessor;
        this.inputMap = inputs;
        this.outputMap = outputs;
    }

    public Map getStructureMapping() {
        return this.structureMapping;
    }

    public Map getInputShredding() {
        return this.inputShredding;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public Map getOverallInputs() {
        return this.inputMap;
    }

    public Map getOverallOutputs() {
        return this.outputMap;
    }

    public String toString() {
        Iterator j;
        Set componentLSIDs;
        String keyLSID;
        StringBuffer sb = new StringBuffer();
        Iterator i = this.structureMapping.keySet().iterator();
        while (i.hasNext()) {
            keyLSID = (String)i.next();
            componentLSIDs = (Set)this.structureMapping.get(keyLSID);
            sb.append("'" + this.findNameFromLSID(keyLSID) + "'->" + keyLSID + " built from {\n");
            j = componentLSIDs.iterator();
            while (j.hasNext()) {
                sb.append("  " + (String)j.next() + "\n");
            }
            sb.append("}\n");
        }
        i = this.inputShredding.keySet().iterator();
        while (i.hasNext()) {
            keyLSID = (String)i.next();
            componentLSIDs = (Set)this.inputShredding.get(keyLSID);
            sb.append("\n'" + this.findNameFromLSID(keyLSID) + "'->" + keyLSID + " decomposed to {\n");
            j = componentLSIDs.iterator();
            while (j.hasNext()) {
                sb.append("  " + (String)j.next() + "\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    public String findNameFromLSID(String LSID) {
        DataThing thing;
        String name;
        Iterator i = this.inputMap.keySet().iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            thing = (DataThing)this.inputMap.get(name);
            if (!thing.getLSID(thing.getDataObject()).equals(LSID)) continue;
            return name;
        }
        i = this.outputMap.keySet().iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            thing = (DataThing)this.outputMap.get(name);
            if (!thing.getLSID(thing.getDataObject()).equals(LSID)) continue;
            return name;
        }
        return "";
    }
}

