/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.LSIDProvider;
import org.embl.ebi.escience.scufl.XScufl;
import org.jdom.Element;

public class WorkflowDescription {
    private String text = "";
    private String lsid = "";
    private String author = "";
    private String title = "";

    public WorkflowDescription() {
        LSIDProvider p = DataThing.SYSTEM_DEFAULT_LSID_PROVIDER;
        if (p != null) {
            this.lsid = p.getID(LSIDProvider.WFDEFINITION);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String theTitle) {
        this.title = theTitle;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        if (newText == null) {
            throw new RuntimeException("Cannot set new textual description to null");
        }
        this.text = newText;
    }

    public String getLSID() {
        return this.lsid;
    }

    public void setLSID(String newLSID) {
        if (newLSID == null) {
            throw new RuntimeException("Cannot set new LSID value to null");
        }
        this.lsid = newLSID;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String newAuthor) {
        this.author = newAuthor;
    }

    public static Element getElement(WorkflowDescription theDescription) {
        Element descriptionElement = new Element("workflowdescription", XScufl.XScuflNS);
        descriptionElement.setText(theDescription.getText());
        descriptionElement.setAttribute("lsid", theDescription.getLSID());
        descriptionElement.setAttribute("author", theDescription.getAuthor());
        descriptionElement.setAttribute("title", theDescription.getTitle());
        return descriptionElement;
    }

    public static WorkflowDescription build(Element theElement) {
        LSIDProvider p;
        try {
            Class.forName("org.embl.ebi.escience.baclava.DataThing");
        }
        catch (Exception e) {
            // empty catch block
        }
        WorkflowDescription description = new WorkflowDescription();
        description.setText(theElement.getTextTrim());
        description.setAuthor(theElement.getAttributeValue("author", ""));
        description.setLSID(theElement.getAttributeValue("lsid", ""));
        description.setTitle(theElement.getAttributeValue("title", ""));
        if (description.lsid.equals("") && (p = DataThing.SYSTEM_DEFAULT_LSID_PROVIDER) != null) {
            description.lsid = p.getID(LSIDProvider.WFDEFINITION);
        }
        return description;
    }
}

