/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.XScufl;
import org.jdom.Content;
import org.jdom.Element;

public class SemanticMarkup {
    private String description = "";
    private String semanticType = "";
    private List mimeTypeList = new ArrayList();
    private Object subject = null;

    public SemanticMarkup(Object subject) {
        this.subject = subject;
    }

    public SemanticMarkup(SemanticMarkup other) {
        this.description = other.description;
        this.semanticType = other.semanticType;
        this.mimeTypeList.addAll(other.mimeTypeList);
        this.subject = other.subject;
    }

    public List getMIMETypeList() {
        return this.mimeTypeList;
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
        this.fireModelEvent();
    }

    public String getDescription() {
        return this.description;
    }

    public Object getSubject() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMIMETypes() {
        List list = this.mimeTypeList;
        synchronized (list) {
            return this.mimeTypeList.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstMIMEType() {
        List list = this.mimeTypeList;
        synchronized (list) {
            if (this.mimeTypeList.isEmpty()) {
                return "";
            }
            return (String)this.mimeTypeList.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayTypeList() {
        StringBuffer sb = new StringBuffer();
        List list = this.mimeTypeList;
        synchronized (list) {
            Iterator i = this.mimeTypeList.iterator();
            while (i.hasNext()) {
                sb.append((String)i.next() + "\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMIMETypes() {
        List list = this.mimeTypeList;
        synchronized (list) {
            this.mimeTypeList.clear();
            this.fireModelEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMIMEType(String mimeType) {
        List list = this.mimeTypeList;
        synchronized (list) {
            if (mimeType != null && !mimeType.equals("")) {
                Iterator i = this.mimeTypeList.iterator();
                while (i.hasNext()) {
                    if (!((String)i.next()).equals(mimeType)) continue;
                    return;
                }
                this.mimeTypeList.add(mimeType);
                this.fireModelEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMIMETypes(List mimeTypes) {
        List list = this.mimeTypeList;
        synchronized (list) {
            this.mimeTypeList.clear();
            Iterator i = mimeTypes.iterator();
            while (i.hasNext()) {
                String mt = (String)i.next();
                if (this.mimeTypeList.contains(mt)) continue;
                this.mimeTypeList.add(mt);
            }
            this.fireModelEvent();
        }
    }

    public String getSemanticType() {
        return this.semanticType;
    }

    public void setSemanticType(String newSemanticType) {
        if (newSemanticType != null) {
            this.semanticType = newSemanticType;
        }
        this.fireModelEvent();
    }

    public void configureFromElement(Element theElement) {
        Element semanticTypeElement;
        Element descriptionElement;
        Element mimeTypeListElement = theElement.getChild("mimeTypes", XScufl.XScuflNS);
        if (mimeTypeListElement != null) {
            Iterator i = mimeTypeListElement.getChildren("mimeType", XScufl.XScuflNS).iterator();
            while (i.hasNext()) {
                Element typeElement = (Element)i.next();
                this.addMIMEType(typeElement.getTextTrim());
            }
        }
        if ((descriptionElement = theElement.getChild("description", XScufl.XScuflNS)) != null) {
            this.description = descriptionElement.getTextTrim();
        }
        if ((semanticTypeElement = theElement.getChild("semanticType", XScufl.XScuflNS)) != null) {
            this.semanticType = semanticTypeElement.getTextTrim();
        }
        this.fireModelEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getConfigurationElement() {
        Element topElement = new Element("metadata", XScufl.XScuflNS);
        Element mimeTypeList = new Element("mimeTypes", XScufl.XScuflNS);
        List list = this.mimeTypeList;
        synchronized (list) {
            boolean addedMIME = false;
            Iterator i = this.mimeTypeList.iterator();
            while (i.hasNext()) {
                Element typeElement = new Element("mimeType", XScufl.XScuflNS);
                String mimeType = (String)i.next();
                typeElement.setText(mimeType);
                mimeTypeList.addContent((Content)typeElement);
                if (mimeType.equalsIgnoreCase("text/plain") || mimeType.equalsIgnoreCase("application/octet-stream")) continue;
                addedMIME = true;
            }
            if (addedMIME) {
                topElement.addContent((Content)mimeTypeList);
            }
        }
        if (!this.description.equals("")) {
            Element descriptionElement = new Element("description", XScufl.XScuflNS);
            topElement.addContent((Content)descriptionElement);
            descriptionElement.setText(this.description);
        }
        if (!this.semanticType.equals("")) {
            Element semanticTypeElement = new Element("semanticType", XScufl.XScuflNS);
            topElement.addContent((Content)semanticTypeElement);
            semanticTypeElement.setText(this.semanticType);
        }
        return topElement;
    }

    void fireModelEvent() {
        if (this.subject instanceof Port) {
            ((Port)this.subject).fireModelEvent(new ScuflModelEvent(this, "Metadata change"));
        }
    }

    public String toString() {
        return super.toString() + " description=" + this.description + " semanticType=" + this.semanticType + " mimeTypes=" + this.mimeTypeList;
    }
}

