/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.embl.ebi.escience.scufl.ConcurrencyConstraint;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InternalSinkPortHolder;
import org.embl.ebi.escience.scufl.InternalSourcePortHolder;
import org.embl.ebi.escience.scufl.LogAwareComponent;
import org.embl.ebi.escience.scufl.MalformedNameException;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.SetOnlineException;
import org.embl.ebi.escience.scufl.UnknownPortException;
import org.embl.ebi.escience.scufl.UnknownProcessorException;
import org.embl.ebi.escience.scufl.WorkflowDescription;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import org.embl.ebi.escience.scufl.view.XScuflView;

public class ScuflModel
implements Serializable,
LogAwareComponent {
    boolean offline = false;
    int logLevel = 0;
    private WorkflowDescription description = new WorkflowDescription();
    public boolean isFiringEvents = true;
    List listeners = Collections.synchronizedList(new ArrayList());
    private InternalSourcePortHolder sources = null;
    private InternalSinkPortHolder sinks = null;
    private ArrayList processors = new ArrayList();
    private ArrayList constraints = new ArrayList();
    private ArrayList dataconstraints = new ArrayList();
    Thread eventThread = new NotifyThread(this);
    List pendingEventList = new ArrayList();

    public boolean isOffline() {
        return this.offline;
    }

    public synchronized void setOffline(boolean offlineValue) throws SetOnlineException {
        if (offlineValue != this.offline) {
            this.offline = offlineValue;
            if (!offlineValue) {
                XScuflView xsv = new XScuflView(this);
                String xscuflText = xsv.getXMLText();
                this.removeListener(xsv);
                this.clear();
                try {
                    XScuflParser.populate(xscuflText, this, null);
                }
                catch (Exception ex) {
                    this.clear();
                    this.setOffline(true);
                    try {
                        XScuflParser.populate(xscuflText, this, null);
                    }
                    catch (Exception e) {
                        System.out.println("--------------------------");
                        e.printStackTrace();
                        System.out.println("--------------------------");
                    }
                    SetOnlineException soe = new SetOnlineException("Unable to go online.");
                    soe.initCause(ex);
                    soe.printStackTrace();
                    throw soe;
                }
            }
            Processor[] allProcessors = this.getProcessors();
            for (int i = 0; i < allProcessors.length; ++i) {
                if (offlineValue) {
                    allProcessors[i].setOffline();
                    continue;
                }
                allProcessors[i].setOnline();
            }
            this.fireModelEvent(new ScuflModelEvent(this, "Offline status change"));
        }
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    public WorkflowDescription getDescription() {
        return this.description;
    }

    public void setDescription(WorkflowDescription description) {
        this.description = description;
    }

    public String getValidProcessorName(String originalName) {
        Processor testExists;
        int suffix = 0;
        StringBuffer sb = new StringBuffer();
        String[] split = originalName.split("\\W");
        for (int i = 0; i < split.length; ++i) {
            sb.append(split[i]);
            if (i >= split.length - 1) continue;
            sb.append("_");
        }
        String rootName = sb.toString();
        try {
            testExists = this.locateProcessor(rootName);
        }
        catch (UnknownProcessorException upe) {
            return rootName;
        }
        try {
            while (true) {
                testExists = this.locateProcessor(rootName + ++suffix);
            }
        }
        catch (UnknownProcessorException upe) {
            return rootName + suffix;
        }
    }

    public void setEventStatus(boolean reportEvents) {
        if (reportEvents == this.isFiringEvents) {
            return;
        }
        this.isFiringEvents = reportEvents;
        if (this.isFiringEvents) {
            this.fireModelEvent(new ScuflModelEvent(this, "Event reporting re-enabled, forcing update", ScuflModelEvent.LOAD));
        }
    }

    public ScuflModel() {
        try {
            this.sinks = new InternalSinkPortHolder(this);
            this.sources = new InternalSourcePortHolder(this);
        }
        catch (ProcessorCreationException pce) {
        }
        catch (DuplicateProcessorNameException duplicateProcessorNameException) {
            // empty catch block
        }
    }

    public void clear() {
        try {
            this.sinks = new InternalSinkPortHolder(this);
            this.sources = new InternalSourcePortHolder(this);
            this.dataconstraints = new ArrayList();
            this.constraints = new ArrayList();
            this.processors = new ArrayList();
            this.description = new WorkflowDescription();
            this.setLogLevel(0);
            this.fireModelEvent(new ScuflModelEvent(this, "Reset model to initial state."));
        }
        catch (ProcessorCreationException pce) {
        }
        catch (DuplicateProcessorNameException duplicateProcessorNameException) {
            // empty catch block
        }
    }

    public Port[] getWorkflowSourcePorts() {
        return this.sources.getPorts();
    }

    public Port[] getWorkflowSinkPorts() {
        return this.sinks.getPorts();
    }

    public Processor getWorkflowSourceProcessor() {
        return this.sources;
    }

    public Processor getWorkflowSinkProcessor() {
        return this.sinks;
    }

    public Processor[] getProcessors() {
        return this.processors.toArray(new Processor[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessor(Processor processor) {
        if (processor == null) {
            throw new NullPointerException("Processor must not be null");
        }
        ArrayList arrayList = this.processors;
        synchronized (arrayList) {
            this.processors.add(processor);
            processor.firingEvents = true;
            this.fireModelEvent(new ScuflModelEvent(processor, "Added processor '" + processor.getName() + "' to the model"));
        }
    }

    public void destroyProcessor(Processor the_processor) {
        this.processors.remove(the_processor);
        DataConstraint[] constraints = this.getDataConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            Processor source = constraints[i].getSource().getProcessor();
            Processor sink = constraints[i].getSink().getProcessor();
            if (source != the_processor && sink != the_processor) continue;
            this.destroyDataConstraint(constraints[i]);
        }
        ConcurrencyConstraint[] cc = this.getConcurrencyConstraints();
        for (int i = 0; i < cc.length; ++i) {
            if (the_processor != cc[i].getTargetProcessor() && the_processor != cc[i].getControllingProcessor()) continue;
            this.destroyConcurrencyConstraint(cc[i]);
        }
        this.fireModelEvent(new ScuflModelEvent(this, "Destroyed processor '" + the_processor.getName() + "'"));
    }

    public void addDataConstraint(DataConstraint the_constraint) {
        this.dataconstraints.add(the_constraint);
        this.fireModelEvent(new ScuflModelEvent(this, "Added data constraint '" + the_constraint.getName() + "' to the model"));
    }

    public void destroyDataConstraint(DataConstraint the_constraint) {
        this.dataconstraints.remove(the_constraint);
        this.fireModelEvent(new ScuflModelEvent(this, "Removed data constraint '" + the_constraint.getName() + "'"));
    }

    public void addConcurrencyConstraint(ConcurrencyConstraint the_constraint) {
        this.constraints.add(the_constraint);
        this.fireModelEvent(new ScuflModelEvent(this, "Added concurrency constraint '" + the_constraint.getName() + "' to the model"));
    }

    public void destroyConcurrencyConstraint(ConcurrencyConstraint the_constraint) {
        this.constraints.remove(the_constraint);
        this.fireModelEvent(new ScuflModelEvent(this, "Removed concurrency constraint '" + the_constraint.getName() + "' to the model"));
    }

    public ConcurrencyConstraint[] getConcurrencyConstraints() {
        return this.constraints.toArray(new ConcurrencyConstraint[0]);
    }

    public DataConstraint[] getDataConstraints() {
        return this.dataconstraints.toArray(new DataConstraint[0]);
    }

    public void addListener(ScuflModelEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ScuflModelEventListener listener) {
        this.listeners.remove(listener);
    }

    public ScuflModelEventListener[] getListeners() {
        return this.listeners.toArray(new ScuflModelEventListener[0]);
    }

    public Port locatePort(String port_specifier) throws UnknownProcessorException, UnknownPortException, MalformedNameException {
        String[] parts = port_specifier.split(":");
        if (parts.length < 1 || parts.length > 2) {
            throw new MalformedNameException("You must supply a name of the form [PROCESSOR]:[PORT] to the locate operation");
        }
        if (parts.length == 2) {
            String processor_name = parts[0];
            String port_name = parts[1];
            Processor processor = this.locateProcessor(processor_name);
            Port port = processor.locatePort(port_name);
            return port;
        }
        if (parts.length == 1) {
            Object port = null;
            String port_name = parts[0];
            try {
                return this.sources.locatePort(port_name);
            }
            catch (UnknownPortException upe) {
                return this.sinks.locatePort(port_name);
            }
        }
        throw new MalformedNameException("Couldn't resolve port name '" + port_specifier + "'.");
    }

    Port locatePortOrCreate(String port_specifier, boolean isInputPort) throws UnknownProcessorException, UnknownPortException, MalformedNameException {
        String[] parts = port_specifier.split(":");
        if (parts.length < 1 || parts.length > 2) {
            throw new MalformedNameException("You must supply a name of the form [PROCESSOR]:[PORT] to the locate operation");
        }
        if (parts.length == 2) {
            String processor_name = parts[0];
            String port_name = parts[1];
            Processor processor = this.locateProcessor(processor_name);
            Port port = processor.locatePortOrCreate(port_name, isInputPort);
            return port;
        }
        if (parts.length == 1) {
            Object port = null;
            String port_name = parts[0];
            if (isInputPort) {
                return this.sinks.locatePort(port_name);
            }
            return this.sources.locatePort(port_name);
        }
        throw new MalformedNameException("Couldn't resolve port name '" + port_specifier + "'.");
    }

    public Processor locateProcessor(String processor_name) throws UnknownProcessorException {
        Iterator i = this.processors.iterator();
        while (i.hasNext()) {
            Processor p = (Processor)i.next();
            if (!p.getName().equalsIgnoreCase(processor_name)) continue;
            return p;
        }
        throw new UnknownProcessorException("Unable to locate processor with name '" + processor_name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireModelEvent(ScuflModelEvent event) {
        if (this.isFiringEvents) {
            List list = this.pendingEventList;
            synchronized (list) {
                this.pendingEventList.add(event);
            }
            this.eventThread.interrupt();
        }
    }

    public void forceUpdate() {
        this.fireModelEvent(new ScuflModelEvent(this, "Forced update"));
    }

    class NotifyThread
    extends Thread {
        private ScuflModelEvent event;
        private List listeners;

        protected NotifyThread(ScuflModel model) {
            try {
                this.setDaemon(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.listeners = model.listeners;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block7: while (true) {
                if (ScuflModel.this.pendingEventList == null || ScuflModel.this.pendingEventList.isEmpty()) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {}
                    continue;
                }
                var2_4 = ScuflModel.this.pendingEventList;
                synchronized (var2_4) {
                    events = ScuflModel.this.pendingEventList.toArray(new ScuflModelEvent[0]);
                    ScuflModel.this.pendingEventList.clear();
                }
                i = 0;
                while (true) {
                    if (i < events.length) ** break;
                    continue block7;
                    System.out.println(events[i].toString());
                    j = this.listeners.iterator();
                    while (j.hasNext()) {
                        l = (ScuflModelEventListener)j.next();
                        try {
                            l.receiveModelEvent(events[i]);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

