/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.AnnotationTemplate;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.IterationStrategy;
import org.embl.ebi.escience.scufl.MinorScuflModelEvent;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.UnknownPortException;
import org.embl.ebi.escience.scufl.UnknownProcessorException;

public abstract class Processor
implements Serializable {
    private String name = "";
    private String description = "";
    protected ArrayList ports = new ArrayList();
    private ScuflModel model = null;
    protected int timeout = 0;
    protected int retries = 0;
    protected int retryDelay = 0;
    protected double backoff = 1.0;
    protected boolean critical = false;
    protected List alternates = new ArrayList();
    Processor parentProcessor = null;
    protected List templates = new ArrayList();
    protected IterationStrategy iterationStrategy = null;
    public boolean firingEvents = false;
    public static String ENACTOR = "Local to enactor";
    int logLevel = -1;

    protected void setOnline() {
    }

    protected void setOffline() {
    }

    private AlternateProcessor getAlternateDescription() {
        if (this.model == null && this.parentProcessor != null) {
            List alternateList = this.parentProcessor.getAlternatesList();
            Iterator i = alternateList.iterator();
            while (i.hasNext()) {
                AlternateProcessor ap = (AlternateProcessor)i.next();
                if (ap.getProcessor() != this) continue;
                return ap;
            }
            throw new RuntimeException("No alternates found within parent processor!");
        }
        throw new RuntimeException("Cannot fetch the alternate description for a primary processor " + this.getName());
    }

    public String getResourceHost() {
        return ENACTOR;
    }

    public int getMaximumWorkers() {
        return 1;
    }

    public void setName(String newName) {
        if (this.model == null) {
            return;
        }
        try {
            Processor testExists = this.model.locateProcessor(newName);
            return;
        }
        catch (UnknownProcessorException upe) {
            if (this.name.equals("")) {
                return;
            }
            if (!Pattern.matches("\\w++", this.name)) {
                return;
            }
            this.name = newName;
            this.fireModelEvent(new ScuflModelEvent(this, "Processor renamed to '" + this.name + "'"));
            return;
        }
    }

    public IterationStrategy getIterationStrategy() {
        return this.iterationStrategy;
    }

    public void setIterationStrategy(IterationStrategy i) {
        this.iterationStrategy = i;
    }

    public AnnotationTemplate[] getAnnotationTemplates() {
        return this.templates.toArray(new AnnotationTemplate[0]);
    }

    public void addAnnotationTemplate(AnnotationTemplate theTemplate) {
        if (!this.templates.contains(theTemplate)) {
            this.templates.add(theTemplate);
            this.fireModelEvent(new MinorScuflModelEvent(this, "Template added"));
        }
    }

    public void removeAnnotationTemplate(AnnotationTemplate theTemplate) {
        if (this.templates.contains(theTemplate)) {
            this.templates.remove(theTemplate);
            this.fireModelEvent(new MinorScuflModelEvent(this, "Template removed"));
        }
    }

    public AnnotationTemplate[] defaultAnnotationTemplates() {
        Port[] boundOutputs;
        Port[] boundInputs;
        ArrayList<AnnotationTemplate> dtemplates = new ArrayList<AnnotationTemplate>();
        if (this.model != null) {
            boundInputs = this.getBoundInputPorts();
            boundOutputs = this.getBoundOutputPorts();
        } else if (this.model == null && this.parentProcessor != null) {
            boundInputs = this.parentProcessor.getBoundInputPorts();
            boundOutputs = this.parentProcessor.getBoundOutputPorts();
        } else {
            boundInputs = new Port[]{};
            boundOutputs = new Port[]{};
        }
        for (int i = 0; i < boundInputs.length; ++i) {
            for (int j = 0; j < boundOutputs.length; ++j) {
                Port input = boundInputs[i];
                Port output = boundOutputs[j];
                dtemplates.add(AnnotationTemplate.standardTemplate(output, "tavp:createdFrom", input));
            }
        }
        return dtemplates.toArray(new AnnotationTemplate[0]);
    }

    public AlternateProcessor[] getAlternatesArray() {
        return this.alternates.toArray(new AlternateProcessor[0]);
    }

    public List getAlternatesList() {
        return this.alternates;
    }

    public void addAlternate(AlternateProcessor ap) {
        this.alternates.add(ap);
        ap.setOriginalProcessor(this);
        this.fireModelEvent(new ScuflModelEvent(this, "Alternate added"));
    }

    public void removeAlternate(AlternateProcessor ap) {
        this.alternates.remove(ap);
        this.fireModelEvent(new ScuflModelEvent(this, "Alternate removed"));
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout != this.timeout) {
            this.timeout = timeout;
            this.fireModelEvent(new MinorScuflModelEvent(this, "Timeout changed"));
        }
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        if (retries != this.retries) {
            this.retries = retries;
            this.fireModelEvent(new MinorScuflModelEvent(this, "Retry count changed"));
        }
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int delay) {
        if (delay != this.retryDelay) {
            this.retryDelay = delay;
            this.fireModelEvent(new MinorScuflModelEvent(this, "Retry delay changed"));
        }
    }

    public double getBackoff() {
        return this.backoff;
    }

    public void setBackoff(double backoff) {
        if (backoff != this.backoff) {
            this.backoff = backoff;
            this.fireModelEvent(new MinorScuflModelEvent(this, "Backoff changed"));
        }
    }

    public boolean getCritical() {
        return this.critical;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public int getLogLevel() {
        if (this.getModel() == null || this.logLevel > -1) {
            return this.logLevel;
        }
        return this.getModel().getLogLevel();
    }

    public int getRealLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int level) {
        this.logLevel = level;
        this.fireModelEvent(new ScuflModelEvent(this, "Log level changed"));
    }

    public abstract Properties getProperties();

    public Processor(ScuflModel model, String name) throws ProcessorCreationException, DuplicateProcessorNameException {
        if (name == null) {
            throw new ProcessorCreationException("Cannot create a processor with a null name");
        }
        if (name.equals("")) {
            throw new ProcessorCreationException("Refusing to create a processor with name ''");
        }
        if (!Pattern.matches("\\w++", name)) {
            throw new ProcessorCreationException("Name contains an invalid character,\nnames must match [a-zA-Z_0-9].");
        }
        if (model != null) {
            Processor[] existing_processors = model.getProcessors();
            for (int i = 0; i < existing_processors.length; ++i) {
                Processor processor = existing_processors[i];
                if (!processor.getName().equalsIgnoreCase(name)) continue;
                throw new DuplicateProcessorNameException("Cannot create a processor with name '" + name + "', because this name is already used in the model.");
            }
        }
        this.model = model;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String the_description) {
        if (!the_description.equalsIgnoreCase(this.description)) {
            // empty if block
        }
        this.description = the_description;
    }

    public Port[] getPorts() {
        return this.ports.toArray(new Port[0]);
    }

    public InputPort[] getBoundInputPorts() {
        if (this.model != null) {
            ArrayList<InputPort> temp = new ArrayList<InputPort>();
            HashSet<Port> boundPorts = new HashSet<Port>();
            DataConstraint[] dc = this.model.getDataConstraints();
            for (int i = 0; i < dc.length; ++i) {
                DataConstraint d = dc[i];
                boundPorts.add(d.getSink());
            }
            Iterator i = this.ports.iterator();
            while (i.hasNext()) {
                try {
                    InputPort ip = (InputPort)i.next();
                    if (!boundPorts.contains(ip)) continue;
                    temp.add(ip);
                }
                catch (ClassCastException cce) {}
            }
            return temp.toArray(new InputPort[0]);
        }
        if (this.parentProcessor == null) {
            return new InputPort[0];
        }
        AlternateProcessor ap = this.getAlternateDescription();
        Map inputMapping = ap.getInputMapping();
        Map outputMapping = ap.getOutputMapping();
        InputPort[] parentInputs = this.parentProcessor.getBoundInputPorts();
        ArrayList<Port> resultList = new ArrayList<Port>();
        for (int i = 0; i < parentInputs.length; ++i) {
            String parentPortName = parentInputs[i].getName();
            String childPortName = (String)inputMapping.get(parentPortName);
            if (childPortName == null) continue;
            try {
                resultList.add(this.locatePort(childPortName));
                continue;
            }
            catch (UnknownPortException ex) {
                // empty catch block
            }
        }
        return resultList.toArray(new InputPort[0]);
    }

    public OutputPort[] getBoundOutputPorts() {
        if (this.model != null) {
            ArrayList<OutputPort> temp = new ArrayList<OutputPort>();
            HashSet<Port> boundPorts = new HashSet<Port>();
            DataConstraint[] dc = this.model.getDataConstraints();
            for (int i = 0; i < dc.length; ++i) {
                DataConstraint d = dc[i];
                boundPorts.add(d.getSource());
            }
            Iterator i = this.ports.iterator();
            while (i.hasNext()) {
                try {
                    OutputPort op = (OutputPort)i.next();
                    if (!boundPorts.contains(op)) continue;
                    temp.add(op);
                }
                catch (ClassCastException cce) {}
            }
            return temp.toArray(new OutputPort[0]);
        }
        if (this.parentProcessor == null) {
            return new OutputPort[0];
        }
        AlternateProcessor ap = this.getAlternateDescription();
        Map inputMapping = ap.getInputMapping();
        Map outputMapping = ap.getOutputMapping();
        OutputPort[] parentOutputs = this.parentProcessor.getBoundOutputPorts();
        ArrayList<Port> resultList = new ArrayList<Port>();
        for (int i = 0; i < parentOutputs.length; ++i) {
            String parentPortName = parentOutputs[i].getName();
            String childPortName = (String)outputMapping.get(parentPortName);
            if (childPortName == null) continue;
            try {
                resultList.add(this.locatePort(childPortName));
                continue;
            }
            catch (UnknownPortException ex) {
                // empty catch block
            }
        }
        return resultList.toArray(new OutputPort[0]);
    }

    public Port locatePort(String port_name) throws UnknownPortException {
        Iterator i = this.ports.iterator();
        while (i.hasNext()) {
            Port p = (Port)i.next();
            if (!p.getName().equalsIgnoreCase(port_name)) continue;
            return p;
        }
        throw new UnknownPortException("Unable to find the port with name '" + port_name + "' in '" + this.getName() + "'");
    }

    synchronized Port locatePortOrCreate(String port_name, boolean isInputPort) throws UnknownPortException {
        try {
            return this.locatePort(port_name);
        }
        catch (UnknownPortException upe) {
            if (this.model != null && this.model.isOffline()) {
                try {
                    Port result = isInputPort ? new InputPort(this, port_name) : new OutputPort(this, port_name);
                    this.addPort(result);
                    return result;
                }
                catch (PortCreationException pce) {
                    pce.printStackTrace();
                    throw upe;
                }
                catch (DuplicatePortNameException dpne) {
                    dpne.printStackTrace();
                    throw upe;
                }
            }
            throw upe;
        }
    }

    public InputPort[] getInputPorts() {
        ArrayList<InputPort> temp = new ArrayList<InputPort>();
        Iterator i = this.ports.iterator();
        while (i.hasNext()) {
            try {
                InputPort ip = (InputPort)i.next();
                temp.add(ip);
            }
            catch (ClassCastException classCastException) {}
        }
        return temp.toArray(new InputPort[0]);
    }

    public OutputPort[] getOutputPorts() {
        ArrayList<OutputPort> temp = new ArrayList<OutputPort>();
        Iterator i = this.ports.iterator();
        while (i.hasNext()) {
            try {
                OutputPort op = (OutputPort)i.next();
                temp.add(op);
            }
            catch (ClassCastException classCastException) {}
        }
        return temp.toArray(new OutputPort[0]);
    }

    public void addPort(Port the_port) {
        if (this.ports.contains(the_port)) {
            return;
        }
        if (the_port.getProcessor() != this) {
            return;
        }
        this.ports.add(the_port);
    }

    public void removePort(Port the_port) {
        this.ports.remove(the_port);
        DataConstraint[] dc = this.model.getDataConstraints();
        for (int i = 0; i < dc.length; ++i) {
            if (dc[i].getSource() != the_port && dc[i].getSink() != the_port || this.model == null) continue;
            this.model.destroyDataConstraint(dc[i]);
        }
        this.fireModelEvent(new ScuflModelEvent(this, "Removed a port"));
    }

    public ScuflModel getModel() {
        return this.model;
    }

    public void fireModelEvent(ScuflModelEvent event) {
        if (this.firingEvents) {
            if (this.model != null) {
                this.model.fireModelEvent(event);
            } else if (this.parentProcessor != null) {
                event.source = this.parentProcessor;
                this.parentProcessor.fireModelEvent(event);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOffline() {
        if (this.model != null && this.model.isOffline()) {
            return true;
        }
        if (this.model == null && this.parentProcessor != null) {
            return this.parentProcessor.isOffline();
        }
        return false;
    }
}

