/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import java.io.Serializable;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.InternalSinkPortHolder;
import org.embl.ebi.escience.scufl.InternalSourcePortHolder;
import org.embl.ebi.escience.scufl.MinorScuflModelEvent;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.SemanticMarkup;

public abstract class Port
implements Serializable {
    private String name = "";
    private Processor processor = null;
    private String syntacticType = "";
    private SemanticMarkup metadata = new SemanticMarkup(this);

    public Port(Processor processor, String name) throws DuplicatePortNameException, PortCreationException {
        if (processor == null) {
            throw new PortCreationException("Invalid call to create a port, the processor was null!");
        }
        if (name == null) {
            throw new PortCreationException("Invalid call to create a port, the name was null!");
        }
        if (name.equals("")) {
            throw new PortCreationException("Refusing to create a port with name ''");
        }
        Port[] the_ports = processor.getPorts();
        for (int i = 0; i < the_ports.length; ++i) {
            String existing_port_name = the_ports[i].getName();
            if (!existing_port_name.equalsIgnoreCase(name)) continue;
            throw new DuplicatePortNameException("Cannot create duplicate port name, was attempting to create '" + name + "', but it already exists in processor '" + processor.getName() + "'.");
        }
        this.processor = processor;
        this.name = name;
        this.fireModelEvent(new ScuflModelEvent(this, "New port created '" + name + "' in processor '" + processor.getName() + "'"));
    }

    public SemanticMarkup getMetadata() {
        return this.metadata;
    }

    public void setName(String name) {
        if (this.processor.getModel() != null && (this.processor == this.processor.getModel().getWorkflowSinkProcessor() || this.processor == this.processor.getModel().getWorkflowSourceProcessor()) && !name.equals(this.name) && name.matches("\\w+")) {
            this.name = name;
            this.fireModelEvent(new MinorScuflModelEvent(this, "Port name changed to " + name));
        }
    }

    public void setSyntacticType(String new_type) {
        if (!new_type.equals(this.syntacticType)) {
            this.syntacticType = new_type;
            String[] split = new_type.split("'");
            String mime = split.length == 1 ? split[0] : split[1];
            this.metadata.addMIMEType(mime);
            this.fireModelEvent(new ScuflModelEvent(this, "Syntactic type changed to '" + new_type + "'"));
        }
    }

    public String getSyntacticType() {
        return this.syntacticType;
    }

    public boolean isSource() {
        return this.getProcessor() instanceof InternalSourcePortHolder;
    }

    public boolean isSink() {
        return this.getProcessor() instanceof InternalSinkPortHolder;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    void fireModelEvent(ScuflModelEvent event) {
        this.processor.fireModelEvent(event);
    }
}

