/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import java.io.Serializable;
import org.embl.ebi.escience.scufl.ConcurrencyConstraintCreationException;
import org.embl.ebi.escience.scufl.DuplicateConcurrencyConstraintNameException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;

public class ConcurrencyConstraint
implements Serializable {
    public static final int SCHEDULED = 0;
    public static final int RUNNING = 1;
    public static final int COMPLETED = 2;
    public static final int ABORTED = 3;
    private static final int MAXIMUM_STATUS_VALUE = 3;
    private Processor controller;
    private Processor target;
    private int targetStateFrom;
    private int targetStateTo;
    private int controllerStateGuard;
    private String name;
    private ScuflModel model;

    public String getName() {
        return this.name;
    }

    public ConcurrencyConstraint(ScuflModel model, String name, Processor controller, Processor target, int targetStateFrom, int targetStateTo, int controllerStateGuard) throws DuplicateConcurrencyConstraintNameException, ConcurrencyConstraintCreationException {
        this.controller = controller;
        this.target = target;
        this.targetStateFrom = targetStateFrom;
        this.targetStateTo = targetStateTo;
        this.controllerStateGuard = controllerStateGuard;
        this.name = name;
        this.model = model;
        if (this.model == null) {
            throw new ConcurrencyConstraintCreationException("Scufl model parameter cannot be null!");
        }
        if (this.target == null) {
            throw new ConcurrencyConstraintCreationException("Target processor cannot be null!");
        }
        if (this.controller == null) {
            throw new ConcurrencyConstraintCreationException("Controller processor cannot be null!");
        }
        if (this.targetStateFrom < 0 || this.targetStateFrom > 3) {
            throw new ConcurrencyConstraintCreationException("Invalid value for targetStateFrom in constructor!");
        }
        if (this.targetStateTo < 0 || this.targetStateTo > 3) {
            throw new ConcurrencyConstraintCreationException("Invalid value for targetStateTo in constructor!");
        }
        if (this.controllerStateGuard < 0 || this.controllerStateGuard > 3) {
            throw new ConcurrencyConstraintCreationException("Invalid value for controllerStateGuard in constructor!");
        }
        ConcurrencyConstraint[] existingConstraints = model.getConcurrencyConstraints();
        for (int i = 0; i < existingConstraints.length; ++i) {
            if (!existingConstraints[i].getName().equalsIgnoreCase(name)) continue;
            throw new DuplicateConcurrencyConstraintNameException("Cannot create a new concurrency constraint with name '" + name + "' as this name is already " + "bound within the model.");
        }
        model.fireModelEvent(new ScuflModelEvent(this, "Created new concurrency constraint"));
    }

    public Processor getTargetProcessor() {
        return this.target;
    }

    public Processor getControllingProcessor() {
        return this.controller;
    }

    public int getTargetStateFrom() {
        return this.targetStateFrom;
    }

    public int getTargetStateTo() {
        return this.targetStateTo;
    }

    public int getControllerStateGuard() {
        return this.controllerStateGuard;
    }

    public static String statusCodeToString(int status) {
        if (status == 0) {
            return "Scheduled";
        }
        if (status == 1) {
            return "Running";
        }
        if (status == 2) {
            return "Completed";
        }
        if (status == 3) {
            return "Aborted";
        }
        return "Unknown State!";
    }

    public static int statusStringToInt(String status) {
        if (status.equalsIgnoreCase("scheduled")) {
            return 0;
        }
        if (status.equalsIgnoreCase("running")) {
            return 1;
        }
        if (status.equalsIgnoreCase("completed")) {
            return 2;
        }
        if (status.equalsIgnoreCase("aborted")) {
            return 3;
        }
        return -1;
    }

    public String toString() {
        return this.getControllingProcessor().getName() + "::" + this.getTargetProcessor().getName();
    }
}

