/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.store;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.store.ObjectPool;

class JDBCConnectionPool
extends ObjectPool {
    String driver;
    String dsn;
    String usr;
    String pwd;
    static Logger log = Logger.getLogger((String)JDBCConnectionPool.class.getName());

    public Connection borrowConnection() {
        log.debug((Object)("Thread " + Thread.currentThread().toString() + " requested connection."));
        Connection con = (Connection)super.checkOut();
        log.debug((Object)("Thread " + Thread.currentThread().toString() + " acquired connection."));
        return con;
    }

    public void returnConnection(Connection c) {
        super.checkIn(c);
        log.debug((Object)("Thread " + Thread.currentThread().toString() + " returned connection."));
    }

    public JDBCConnectionPool(String driver, String dsn, String usr, String pwd, int maxConnections) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dsn = dsn;
        this.usr = usr;
        this.pwd = pwd;
        this.maxObjects = maxConnections;
    }

    Object create() {
        try {
            Connection con = DriverManager.getConnection(this.dsn, this.usr, this.pwd);
            con.setAutoCommit(false);
            return con;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    void expire(Object o) {
        try {
            ((Connection)o).close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    boolean validate(Object o) {
        try {
            return !((Connection)o).isClosed();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }
}

