/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.iteratorui;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.embl.ebi.escience.baclava.BaclavaIteratorNode;
import org.embl.ebi.escience.baclava.JoinIteratorNode;

public class IteratorTreeModel
extends DefaultTreeModel {
    public IteratorTreeModel() {
        super(new JoinIteratorNode());
        this.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                if (!(n instanceof BaclavaIteratorNode)) {
                    Enumeration<TreeNode> en = n.depthFirstEnumeration();
                    HashSet<DefaultMutableTreeNode> nodesToRescue = new HashSet<DefaultMutableTreeNode>();
                    while (en.hasMoreElements()) {
                        DefaultMutableTreeNode m = (DefaultMutableTreeNode)en.nextElement();
                        if (!(m instanceof BaclavaIteratorNode)) continue;
                        nodesToRescue.add(m);
                    }
                    Iterator i = nodesToRescue.iterator();
                    while (i.hasNext()) {
                        DefaultMutableTreeNode m = (DefaultMutableTreeNode)i.next();
                        IteratorTreeModel.this.removeNodeFromParent(m);
                        IteratorTreeModel.this.insertNodeInto(m, (MutableTreeNode)IteratorTreeModel.this.getRoot(), 0);
                    }
                }
            }

            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
    }

    public synchronized void normalize() {
        boolean finished = false;
        while (!finished) {
            finished = true;
            Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this.getRoot()).breadthFirstEnumeration();
            while (e.hasMoreElements() && finished) {
                MutableTreeNode child;
                MutableTreeNode n = (MutableTreeNode)e.nextElement();
                if (!n.isLeaf() && n.getParent() != null && n.getChildCount() == 0) {
                    this.removeNodeFromParent(n);
                    finished = false;
                    continue;
                }
                if (!n.isLeaf() && n.getParent() != null && n.getChildCount() == 1) {
                    child = (MutableTreeNode)n.getChildAt(0);
                    MutableTreeNode parent = (MutableTreeNode)n.getParent();
                    this.removeNodeFromParent(n);
                    this.insertNodeInto(child, parent, 0);
                    finished = false;
                    continue;
                }
                if (n.getParent() != null || n.getChildCount() != 1) continue;
                child = (MutableTreeNode)n.getChildAt(0);
                this.removeNodeFromParent(child);
                this.setRoot(child);
                finished = false;
            }
        }
    }
}

