/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.factory;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.embl.ebi.escience.baclava.Base64;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.NoMetadataFoundException;
import org.embl.ebi.escience.scufl.SemanticMarkup;
import org.embl.ebi.escience.scufl.XScufl;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class DataThingXMLFactory {
    public static Namespace namespace = Namespace.getNamespace((String)"b", (String)"http://org.embl.ebi.escience/baclava/0.1alpha");

    public static Document getDataDocument(Map dataThings) {
        Element rootElement = new Element("dataThingMap", namespace);
        Document theDocument = new Document(rootElement);
        Iterator i = dataThings.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            DataThing value = (DataThing)dataThings.get(key);
            Element dataThingElement = new Element("dataThing", namespace);
            dataThingElement.setAttribute("key", key);
            dataThingElement.addContent((Content)value.getElement());
            rootElement.addContent((Content)dataThingElement);
        }
        return theDocument;
    }

    public static Map parseDataDocument(Document dataDocument) {
        HashMap<String, DataThing> result = new HashMap<String, DataThing>();
        Element rootElement = dataDocument.getRootElement();
        Iterator i = rootElement.getChildren("dataThing", namespace).iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String key = e.getAttributeValue("key");
            DataThing d = new DataThing(e.getChild("myGridDataDocument", namespace));
            result.put(key, d);
        }
        return result;
    }

    public static Object configureDataThing(Element rootElement, DataThing theDataThing) {
        Element semanticMarkupElement = rootElement.getChild("metadata", XScufl.XScuflNS);
        String lsid = rootElement.getAttributeValue("lsid");
        if (lsid != null) {
            theDataThing.setLSID(theDataThing, lsid);
        }
        if (semanticMarkupElement != null) {
            theDataThing.getMetadata().configureFromElement(semanticMarkupElement);
        }
        return DataThingXMLFactory.objectForElement(rootElement, theDataThing, rootElement);
    }

    private static Object objectForElement(Element e, DataThing theDataThing, Element rootElement) {
        Element dataElement = e.getChild("dataElement", namespace);
        if (dataElement != null) {
            return DataThingXMLFactory.objectForDataElement(dataElement, theDataThing, rootElement);
        }
        Element posetElement = e.getChild("partialOrder", namespace);
        if (posetElement != null) {
            return DataThingXMLFactory.objectForCollectionElement(posetElement, theDataThing, rootElement);
        }
        return null;
    }

    private static Object objectForDataElement(Element e, DataThing theDataThing, Element rootElement) {
        String lsid;
        String documentSyntacticType;
        Element metadataElement = e.getChild("metadata", XScufl.XScuflNS);
        String mimeHint = "";
        if (metadataElement != null) {
            SemanticMarkup m = new SemanticMarkup(new Object());
            m.configureFromElement(metadataElement);
            mimeHint = m.getFirstMIMEType().toLowerCase();
        }
        if (mimeHint.equals("") && !(documentSyntacticType = rootElement.getAttributeValue("syntactictype")).equals("")) {
            mimeHint = documentSyntacticType.split("'")[1].toLowerCase();
        }
        if (mimeHint.equals("")) {
            mimeHint = "text/plain";
        }
        String mimeMajorType = mimeHint.split("/")[0];
        String encodedData = e.getChild("dataElementData", namespace).getTextTrim();
        byte[] decodedData = Base64.decode(encodedData);
        Object result = mimeMajorType.equals("text") ? (Object)new String(decodedData) : decodedData;
        if (metadataElement != null) {
            SemanticMarkup m = theDataThing.getMetadataForObject(result, true);
            m.configureFromElement(metadataElement);
        }
        if ((lsid = e.getAttributeValue("lsid")) != null) {
            theDataThing.setLSID(result, lsid);
        }
        return result;
    }

    private static Object objectForCollectionElement(Element e, DataThing theDataThing, Element rootElement) {
        String collectionType = e.getAttributeValue("type");
        Element relationListElement = e.getChild("relationList", namespace);
        Element itemListElement = e.getChild("itemList", namespace);
        AbstractCollection result = null;
        result = collectionType.equals("list") ? new ArrayList() : new HashSet();
        Iterator i = itemListElement.getChildren("dataElement", namespace).iterator();
        while (i.hasNext()) {
            result.add(DataThingXMLFactory.objectForDataElement((Element)i.next(), theDataThing, rootElement));
        }
        i = itemListElement.getChildren("partialOrder", namespace).iterator();
        while (i.hasNext()) {
            Element nextElement = (Element)i.next();
            result.add(DataThingXMLFactory.objectForCollectionElement(nextElement, theDataThing, rootElement));
        }
        String lsid = e.getAttributeValue("lsid");
        if (lsid != null) {
            theDataThing.setLSID(result, lsid);
        }
        return result;
    }

    public static Element getElement(DataThing theDataThing) {
        Element rootElement = new Element("myGridDataDocument", namespace);
        rootElement.setAttribute("lsid", theDataThing.getLSID(theDataThing));
        rootElement.setAttribute("syntactictype", theDataThing.getSyntacticType());
        rootElement.addContent((Content)theDataThing.getMetadata().getConfigurationElement());
        rootElement.addContent((Content)DataThingXMLFactory.elementForObject(theDataThing.getDataObject(), theDataThing));
        return rootElement;
    }

    private static Element elementForObject(Object o, DataThing theDataThing) {
        if (o instanceof Collection) {
            Element poElement = new Element("partialOrder", namespace);
            poElement.setAttribute("lsid", theDataThing.getLSID(o));
            Element relationListElement = new Element("relationList", namespace);
            Element listElement = new Element("itemList", namespace);
            int currentIndex = 0;
            poElement.addContent((Content)relationListElement);
            poElement.addContent((Content)listElement);
            if (o instanceof List) {
                poElement.setAttribute("type", "list");
                if (!((List)o).isEmpty()) {
                    Iterator i = ((List)o).iterator();
                    while (i.hasNext()) {
                        Element listItemElement = DataThingXMLFactory.elementForObject(i.next(), theDataThing);
                        listElement.addContent((Content)listItemElement);
                        listItemElement.setAttribute("index", "" + currentIndex);
                        if (currentIndex > 0) {
                            Element relationElement = new Element("relation", namespace);
                            relationElement.setAttribute("parent", "" + (currentIndex - 1));
                            relationElement.setAttribute("child", "" + currentIndex);
                            relationListElement.addContent((Content)relationElement);
                        }
                        ++currentIndex;
                    }
                }
            } else if (o instanceof Set) {
                poElement.setAttribute("type", "set");
            }
            return poElement;
        }
        Element dataElement = new Element("dataElement", namespace);
        dataElement.setAttribute("lsid", theDataThing.getLSID(o));
        try {
            SemanticMarkup sm = theDataThing.getMetadataForObject(o, false);
            dataElement.addContent((Content)sm.getConfigurationElement());
        }
        catch (NoMetadataFoundException nmfe) {
            // empty catch block
        }
        Element realDataElement = new Element("dataElementData", namespace);
        byte[] theBytes = new byte[]{};
        if (o instanceof String) {
            theBytes = ((String)o).getBytes();
        } else if (o instanceof byte[]) {
            theBytes = (byte[])o;
        }
        System.out.println("Size of binary data is " + theBytes.length + " bytes.");
        realDataElement.setText(Base64.encodeBytes(theBytes));
        dataElement.addContent((Content)realDataElement);
        return dataElement;
    }
}

