/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.factory;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.factory.DataThingTreeNode;
import org.embl.ebi.escience.baclava.factory.TransferableDataThing;

public class DataThingTreeTransferHandler
implements DragGestureListener,
DragSourceListener {
    private JTree tree;
    private DragSource dragSource;

    public DataThingTreeTransferHandler(JTree tree, int action) {
        this.tree = tree;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(tree, action, this);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    private void setCursor(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dragEnter(DragSourceDragEvent dsde) {
        this.setCursor(dsde);
    }

    public final void dragOver(DragSourceDragEvent dsde) {
        this.setCursor(dsde);
    }

    public final void dropActionChanged(DragSourceDragEvent dsde) {
        this.setCursor(dsde);
    }

    public final void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    public final void dragGestureRecognized(DragGestureEvent dge) {
        Object pathComponent;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (pathComponent = path.getLastPathComponent()) instanceof DataThingTreeNode) {
            DataThingTreeNode node = (DataThingTreeNode)pathComponent;
            DataThing dataThing = node.getNodeThing();
            this.dragSource.startDrag(dge, DragSource.DefaultMoveNoDrop, new TransferableDataThing(dataThing), this);
        }
    }
}

