/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.factory;

import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.factory.DataThingTreeNode;
import org.embl.ebi.escience.scuflui.ScuflIcons;

public class DataThingTreeNodeRenderer
extends DefaultTreeCellRenderer {
    static ImageIcon textIcon;
    static ImageIcon binaryIcon;
    static ImageIcon imageIcon;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DataThingTreeNode theNode = (DataThingTreeNode)value;
        Object userObject = theNode.getUserObject();
        DataThing theDataThing = theNode.getDataThing();
        String lsid = theDataThing.getLSID(userObject);
        if (!lsid.equals("")) {
            lsid = "<br><font color=\"blue\">" + lsid + "</font>";
        }
        if (theNode.isLeaf()) {
            if (userObject instanceof Collection) {
                if (userObject instanceof Set) {
                    this.setText("<html><font color=\"red\">Empty set</font>" + lsid + "</html>");
                } else {
                    this.setText("<html><font color=\"red\">Empty list</font>" + lsid + "</html>");
                }
                this.setIcon(this.closedIcon);
                return this;
            }
            String syntacticType = theDataThing.getSyntacticTypeForObject(userObject);
            String mimeTypes = syntacticType.split("'")[1].toLowerCase();
            this.setText("<html>" + mimeTypes + lsid + "</html>");
            if (mimeTypes.matches(".*text/.*")) {
                this.setIcon(textIcon);
                if (userObject instanceof String) {
                    String summaryText = (String)userObject;
                    if (summaryText.length() > 100) {
                        summaryText = "<em>Click to view...</em>";
                    }
                    this.setText("<html><font color=\"#666666\">" + mimeTypes + "</font><br>" + summaryText + lsid + "</html>");
                }
            } else if (mimeTypes.matches(".*image/.*")) {
                this.setIcon(imageIcon);
            } else if (mimeTypes.matches(".*application/.*")) {
                this.setIcon(binaryIcon);
            }
        } else {
            if (userObject instanceof List) {
                this.setText("<html>List" + lsid + "</html>");
            } else {
                this.setText("<html>Set" + lsid + "</html>");
            }
            if (expanded) {
                this.setIcon(ScuflIcons.folderOpenIcon);
            } else {
                this.setIcon(ScuflIcons.folderClosedIcon);
            }
        }
        return this;
    }

    static {
        try {
            textIcon = new ImageIcon(ClassLoader.getSystemResource("org/embl/ebi/escience/baclava/icons/text.png"));
            imageIcon = new ImageIcon(ClassLoader.getSystemResource("org/embl/ebi/escience/baclava/icons/image.png"));
            binaryIcon = new ImageIcon(ClassLoader.getSystemResource("org/embl/ebi/escience/baclava/icons/application.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

