/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.factory;

import org.embl.ebi.escience.baclava.BaclavaIterator;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.factory.DataThingFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DataThingFactoryTest {
    public static void main(String[] args) {
        try {
            String[] theStringArray = new String[]{"hello", "world", "string", "array"};
            String theString = "Hello I am a string";
            byte[] theByteArray = theString.getBytes();
            String theXMLString = "<foo>bar</foo>";
            System.out.println("String array : ");
            DataThingFactoryTest.print(DataThingFactory.bake(theStringArray));
            DataThingFactoryTest.print(new DataThing(DataThingFactory.bake(theStringArray).getElement()));
            System.out.println("String : ");
            DataThingFactoryTest.print(DataThingFactory.bake(theString));
            System.out.println("Byte array : ");
            DataThingFactoryTest.print(DataThingFactory.bake(theByteArray));
            System.out.println("String as xml : ");
            DataThing theDataThing = DataThingFactory.bake(theXMLString);
            theDataThing.getMetadataForObject(theXMLString, true).addMIMEType("text/xml");
            DataThingFactoryTest.print(theDataThing);
            System.out.println("Some LSID stuff... : ");
            theDataThing = DataThingFactory.bake(theStringArray);
            theDataThing.setLSID(theDataThing, "LSID:mainDataThingID");
            theDataThing.setLSID(theDataThing.getDataObject(), "LSID:theStringArrayThing");
            for (int i = 0; i < theStringArray.length; ++i) {
                theDataThing.setLSID(theStringArray[i], "LSID:anItem:" + i);
            }
            DataThingFactoryTest.print(theDataThing);
            System.out.println("Testing iteration over the above...");
            BaclavaIterator i = theDataThing.iterator("''");
            while (i.hasNext()) {
                DataThing innerThing = (DataThing)i.next();
                DataThingFactoryTest.print(innerThing);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void print(DataThing d) {
        System.out.println(d.getSyntacticType());
        DataThingFactoryTest.printDocument(d.getElement());
    }

    private static void printDocument(Element e) {
        try {
            Document doc = new Document(e);
            XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
            System.out.println(xo.outputString(doc));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

