/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.embl.ebi.escience.baclava.MimeTypeGuesser;

public class SyntacticType {
    public static final Collection SET = new Collection("Set", "s");
    public static final Collection LIST = new Collection("List", "l");
    public static final Collection PARTIAL_ORDER = new Collection("Partial Order", "p");
    public static final SyntacticType NULL = new SyntacticType("null"){

        public String toString() {
            return "'null'";
        }
    };
    private final SyntacticType elementType;
    private final Collection collectionType;
    private final List mimeTypeList;

    public static SyntacticType valueOf(String val) throws IllegalArgumentException {
        Stack<Collection> typeStack = new Stack<Collection>();
        SyntacticType type = null;
        block7: for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            switch (c) {
                case 's': {
                    typeStack.push(SET);
                    if (val.charAt(++i) == '(') continue block7;
                    throw new IllegalArgumentException("Unabel to parse " + val + " at index " + i);
                }
                case 'l': {
                    typeStack.push(LIST);
                    if (val.charAt(++i) == '(') continue block7;
                    throw new IllegalArgumentException("Unabel to parse " + val + " at index " + i);
                }
                case 'p': {
                    typeStack.push(PARTIAL_ORDER);
                    if (val.charAt(++i) == '(') continue block7;
                    throw new IllegalArgumentException("Unabel to parse " + val + " at index " + i);
                }
                case '\'': {
                    int start = ++i;
                    while (val.charAt(i) != '\'') {
                        ++i;
                    }
                    String name = val.substring(start, i);
                    if (i == start || "null".equals(name)) {
                        type = NULL;
                        continue block7;
                    }
                    String[] parts = name.split(",");
                    type = new SyntacticType(Arrays.asList(parts));
                    continue block7;
                }
                case ')': {
                    Collection coll = (Collection)typeStack.pop();
                    type = new SyntacticType(type, coll);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Unable to parse due to illegal character: '" + c + "' at " + i + " in " + val);
                }
            }
        }
        if (!typeStack.empty()) {
            throw new IllegalArgumentException("Unballanced brackets in " + val);
        }
        return type;
    }

    public static SyntacticType introspect(Object example) {
        if (example instanceof java.util.Collection) {
            Collection colType = example instanceof Set ? SET : (example instanceof List ? LIST : PARTIAL_ORDER);
            Iterator i = ((java.util.Collection)example).iterator();
            SyntacticType elType = !i.hasNext() ? NULL : SyntacticType.introspect(i.next());
            return new SyntacticType(elType, colType);
        }
        return new SyntacticType(MimeTypeGuesser.DEFAULT.guessMimeType(example));
    }

    public SyntacticType(SyntacticType elementType, Collection collectionType) {
        if (elementType == null) {
            throw new NullPointerException("Element type can't be null");
        }
        if (collectionType == null) {
            throw new NullPointerException("Collection type can't be null");
        }
        this.elementType = elementType;
        this.collectionType = collectionType;
        this.mimeTypeList = null;
    }

    public SyntacticType(List mimeTypes) {
        if (mimeTypes == null) {
            throw new NullPointerException("Mimetypes list must not be null");
        }
        this.elementType = null;
        this.collectionType = null;
        this.mimeTypeList = new ArrayList(mimeTypes);
    }

    public SyntacticType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("Mimetype must not be null");
        }
        this.elementType = null;
        this.collectionType = null;
        this.mimeTypeList = Arrays.asList(mimeType);
    }

    public boolean isCollection() {
        return this.collectionType != null;
    }

    public boolean isAtomic() {
        return this.mimeTypeList != null;
    }

    public SyntacticType getElementType() {
        return this.elementType;
    }

    public Collection getCollectionType() {
        return this.collectionType;
    }

    public List getMimeTypeList() {
        if (this.isAtomic()) {
            return this.mimeTypeList;
        }
        return this.getElementType().getMimeTypeList();
    }

    public static SyntacticType collectionOf(SyntacticType type, Collection collection) {
        return new SyntacticType(type, collection);
    }

    public String toString() {
        if (this.isCollection()) {
            return this.collectionType.getSymbol() + "(" + this.elementType.toString() + ")";
        }
        if (this.isAtomic()) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("'");
            Iterator i = this.mimeTypeList.iterator();
            while (i.hasNext()) {
                sbuf.append(i.next());
            }
            sbuf.append("'");
            return sbuf.toString();
        }
        throw new AssertionError((Object)"Must be a collection or atomic");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyntacticType)) {
            return false;
        }
        SyntacticType syntacticType = (SyntacticType)o;
        if (this.collectionType != null ? !this.collectionType.equals(syntacticType.collectionType) : syntacticType.collectionType != null) {
            return false;
        }
        if (this.elementType != null ? !this.elementType.equals(syntacticType.elementType) : syntacticType.elementType != null) {
            return false;
        }
        return !(this.mimeTypeList != null ? !((Object)this.mimeTypeList).equals(syntacticType.mimeTypeList) : syntacticType.mimeTypeList != null);
    }

    public int hashCode() {
        int result = this.elementType != null ? this.elementType.hashCode() : 0;
        result = 29 * result + (this.collectionType != null ? this.collectionType.hashCode() : 0);
        result = 29 * result + (this.mimeTypeList != null ? ((Object)this.mimeTypeList).hashCode() : 0);
        return result;
    }

    public static class Collection {
        private final String name;
        private final String symbol;

        public Collection(String name, String symbol) {
            this.name = name;
            this.symbol = symbol;
        }

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toString() {
            return this.name;
        }
    }
}

