/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.embl.ebi.escience.baclava.ResumableIterator;

public class LockStepIterator
implements ResumableIterator {
    private ResumableIterator[] iteratorsArray;
    private boolean isEmptyIterator = false;

    public LockStepIterator() {
        this.iteratorsArray = new ResumableIterator[0];
        this.isEmptyIterator = true;
    }

    public LockStepIterator(ResumableIterator[] i) {
        this.iteratorsArray = i;
        if (i.length == 0) {
            System.out.println("Empty iterator created.");
            this.isEmptyIterator = true;
        } else {
            int iteratorSize = i[0].size();
            for (int j = 0; j < i.length; ++j) {
                if (i[j].size() == iteratorSize) continue;
                System.out.println("Iterator sizes mismatch, creating an empty iterator.");
                this.isEmptyIterator = true;
            }
        }
    }

    ResumableIterator[] iterators() {
        return this.iteratorsArray;
    }

    boolean emptyIterator() {
        return this.isEmptyIterator;
    }

    public synchronized void reset() {
        for (int i = 0; i < this.iterators().length; ++i) {
            this.iterators()[i].reset();
        }
    }

    public int[] getCurrentLocation() {
        ResumableIterator[] iterators = this.iterators();
        int longestIteratorLength = -1;
        int longestIteratorIndex = 0;
        for (int i = 0; i < iterators.length; ++i) {
            if (iterators[i].getCurrentLocation().length <= longestIteratorLength) continue;
            longestIteratorLength = iterators[i].getCurrentLocation().length;
            longestIteratorIndex = i;
        }
        return iterators[longestIteratorIndex].getCurrentLocation();
    }

    private int[] concatArrays(List listOfArrays) {
        int totalSize = 0;
        Iterator i = listOfArrays.iterator();
        while (i.hasNext()) {
            totalSize += ((int[])i.next()).length;
        }
        int[] output = new int[totalSize];
        int currentIndex = 0;
        Iterator i2 = listOfArrays.iterator();
        while (i2.hasNext()) {
            int[] source = (int[])i2.next();
            for (int j = 0; j < source.length; ++j) {
                output[currentIndex++] = source[j];
            }
        }
        return output;
    }

    public synchronized boolean hasNext() {
        return this.emptyIterator() ? false : this.iterators()[0].hasNext();
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Remove operation not allowed in a JoinIterator.");
    }

    public synchronized Object next() throws NoSuchElementException {
        Object[] results = new Object[this.iterators().length];
        for (int i = 0; i < this.iterators().length; ++i) {
            results[i] = this.iterators()[i].next();
        }
        return results;
    }

    public int size() {
        return this.emptyIterator() ? 0 : this.iterators()[0].size();
    }
}

