/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava;

import com.ibm.lsid.LSIDException;
import com.ibm.lsid.client.LSIDAssigner;
import com.ibm.lsid.wsdl.LSIDStandardPort;
import com.ibm.lsid.wsdl.SOAPLocation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.LSIDProvider;

public class AssigningServiceClient
implements LSIDProvider {
    static int count = 0;
    static Logger log = Logger.getLogger((String)AssigningServiceClient.class.getName());
    String targetAuthority = null;
    String serviceEndpoint = null;
    LSIDAssigner assigner = null;
    private String wfdefinitionNS;
    private String wfinstanceNS;
    private String datathingLeafNS;
    private String datathingCollectionNS;
    private Map perNamespaceAssigners = new HashMap();

    public AssigningServiceClient() {
        this.serviceEndpoint = System.getProperty("taverna.lsid.asclient.endpoint");
        if (this.serviceEndpoint != null) {
            try {
                URL testValid = new URL(this.serviceEndpoint);
            }
            catch (MalformedURLException mue) {
                log.error((Object)"Unable to use the endpoint provided, not a valid URL", (Throwable)mue);
                this.serviceEndpoint = null;
            }
        }
        if (this.serviceEndpoint == null) {
            log.error((Object)"No endpoint specified, unable to create the assigner");
        } else {
            this.wfdefinitionNS = System.getProperty("taverna.lsid.asclient.ns.wfdefinition", "WorkflowDefinition");
            this.wfinstanceNS = System.getProperty("taverna.lsid.asclient.ns.wfinstance", "WorkflowInstance");
            this.datathingLeafNS = System.getProperty("taverna.lsid.asclient.ns.datathingleaf", "DataThing");
            this.datathingCollectionNS = System.getProperty("taverna.lsid.asclient.ns.datathingcollection", "DataThing");
            this.assigner = new LSIDAssigner((LSIDStandardPort)new SOAPLocation(this.serviceEndpoint));
            log.debug((Object)("Created new assigning service client with endpoint " + this.serviceEndpoint));
            try {
                String[][] authorities = this.assigner.getAuthoritiesAndNamespaces();
                for (int i = 0; i < authorities.length; ++i) {
                    String authority = authorities[i][0];
                    String namespace = authorities[i][1];
                    System.out.println("Found auth = " + authority + " for ns = " + namespace);
                    if (namespace.equals(this.wfdefinitionNS)) {
                        this.perNamespaceAssigners.put(LSIDProvider.WFDEFINITION, new LSIDInfo(namespace, authority, this.assigner));
                        log.debug((Object)("Assigning service can assign workflow definition LSIDs using namespace " + namespace + " in " + authority));
                        continue;
                    }
                    if (namespace.equals(this.wfinstanceNS)) {
                        this.perNamespaceAssigners.put(LSIDProvider.WFINSTANCE, new LSIDInfo(namespace, authority, this.assigner));
                        log.debug((Object)("Assigning service can assign workflow instance LSIDs using namespace " + namespace + " in " + authority));
                        continue;
                    }
                    if (namespace.equals(this.datathingLeafNS)) {
                        this.perNamespaceAssigners.put(LSIDProvider.DATATHINGLEAF, new LSIDInfo(namespace, authority, this.assigner));
                        log.debug((Object)("Assigning service can assign datathing leaf LSIDs using namespace " + namespace + " in " + authority));
                        continue;
                    }
                    if (!namespace.equals(this.datathingCollectionNS)) continue;
                    this.perNamespaceAssigners.put(LSIDProvider.DATATHINGCOLLECTION, new LSIDInfo(namespace, authority, this.assigner));
                    log.debug((Object)("Assigning service can assign datathing collection LSIDs using namespace " + namespace + " in " + authority));
                }
            }
            catch (LSIDException le) {
                log.error((Object)"Exception when trying to fetch available authorities", (Throwable)le);
                this.assigner = null;
            }
        }
    }

    public String getID(LSIDProvider.NamespaceEnumeration namespace) {
        LSIDInfo value = (LSIDInfo)this.perNamespaceAssigners.get(namespace);
        if (value == null) {
            log.error((Object)("No mapping found for namespace type " + namespace.toString()));
            return "";
        }
        return value.getNextLSID();
    }

    class LSIDInfo {
        private String baseLSID;
        private int currentCount = 0;

        public LSIDInfo(String namespace, String authority, LSIDAssigner l) {
            try {
                this.baseLSID = l.getLSIDPattern(authority, namespace, new Properties());
                if (!this.baseLSID.startsWith("urn:lsid")) {
                    this.baseLSID = "urn:lsid:" + authority + ":" + namespace + ":" + this.baseLSID;
                }
            }
            catch (LSIDException le) {
                log.error((Object)"Unable to fetch a base LSID", (Throwable)le);
                this.baseLSID = "";
            }
        }

        public synchronized String getNextLSID() {
            return this.baseLSID + this.currentCount++;
        }
    }
}

