/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.http;

import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.http.HTTPConstants;
import com.ibm.lsid.http.HTTPResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.misc.BASE64Encoder;

public class HTTPUtils
implements HTTPConstants {
    public static HTTPResponse doGet(String url, Map headers, Map parameters, LSIDCredentials credentials) throws LSIDException {
        HttpURLConnection conn = null;
        InputStream in = null;
        InputStream error = null;
        try {
            Set entries;
            String password;
            URL lsidURL = new URL(HTTPUtils.addParamsToURL(url, parameters));
            conn = (HttpURLConnection)lsidURL.openConnection();
            if (credentials != null && (password = (String)credentials.getProperty("basicUsername")) != null) {
                password = password + ":" + credentials.getProperty("basicPassword");
                BASE64Encoder enc = new BASE64Encoder();
                String encodedPassword = enc.encode(password.getBytes("UTF-8"));
                conn.setRequestProperty("Authorization", "Basic " + encodedPassword);
            }
            if (headers != null && (entries = headers.entrySet()) != null) {
                Iterator e = entries.iterator();
                while (e.hasNext()) {
                    Map.Entry entry = e.next();
                    conn.setRequestProperty(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            in = conn.getInputStream();
            if (conn.getResponseCode() != 200) {
                StringBuffer buf = new StringBuffer();
                try {
                    try {
                        byte[] bytes = new byte[1024];
                        int numbytes = in.read(bytes);
                        while (numbytes != -1) {
                            buf.append(new String(bytes, 0, numbytes));
                            numbytes = in.read(bytes);
                        }
                        if (conn.getResponseCode() == 401) {
                            throw new LSIDException(700, buf.toString());
                        }
                        if (conn.getResponseCode() == 400) {
                            throw new LSIDException(710, buf.toString());
                        }
                        String errorCode = conn.getHeaderField("LSID-Error-Code");
                        if (errorCode != null) {
                            throw new LSIDException(Integer.parseInt(errorCode), buf.toString());
                        }
                        throw new LSIDException(500, buf.toString());
                    }
                    catch (IOException f) {
                        if (buf != null) {
                            throw new LSIDException(500, "IO Error reading http error, partial error message: " + buf);
                        }
                        throw new LSIDException(500, "IO Error reading http error");
                    }
                }
                catch (Throwable throwable) {
                    Object var13_22 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    throw throwable;
                }
            }
            String expHeader = conn.getHeaderField("Expires");
            Date expires = null;
            if (expHeader != null) {
                try {
                    expires = HTTPConstants.HTTP_DATE_FORMAT.parse(expHeader);
                }
                catch (ParseException e) {
                    throw new LSIDException(e, "Error parsing expiration date: " + expHeader);
                }
            }
            return new HTTPResponse(in, conn.getContentType(), expires);
        }
        catch (IOException e) {
            if (conn == null) {
                throw new LSIDException(e, "Error making HTTP GET call");
            }
            StringBuffer buf = new StringBuffer();
            try {
                try {
                    error = conn.getErrorStream();
                    if (error == null) {
                        throw new LSIDException(e, "Error making HTTP GET call");
                    }
                    byte[] bytes = new byte[1024];
                    int numbytes = error.read(bytes);
                    while (numbytes != -1) {
                        buf.append(new String(bytes, 0, numbytes));
                        numbytes = error.read(bytes);
                    }
                    if (conn.getResponseCode() == 401) {
                        throw new LSIDException(700, buf.toString());
                    }
                    if (conn.getResponseCode() == 400) {
                        throw new LSIDException(710, buf.toString());
                    }
                    String errorCode = conn.getHeaderField("LSID-Error-Code");
                    if (errorCode != null) {
                        throw new LSIDException(Integer.parseInt(errorCode), buf.toString());
                    }
                    throw new LSIDException(500, "error code: " + conn.getResponseCode() + ": " + buf.toString());
                }
                catch (IOException f) {
                    throw new LSIDException(500, "IO Error reading http error, partial error message: " + buf);
                }
            }
            catch (Throwable throwable) {
                block36: {
                    IOException ex2;
                    Object var16_25 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                    if (error == null) break block36;
                    try {
                        error.close();
                    }
                    catch (IOException ex2) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    private static String addParamsToURL(String url, Map params) {
        if (params == null) {
            return url;
        }
        StringBuffer paramStr = new StringBuffer();
        Set entries = params.entrySet();
        if (entries != null) {
            Map.Entry entry;
            Iterator e = entries.iterator();
            if (e.hasNext()) {
                entry = e.next();
                paramStr.append(entry.getKey().toString()).append("=").append(entry.getValue().toString());
            }
            while (e.hasNext()) {
                entry = e.next();
                paramStr.append("&").append(entry.getKey().toString()).append("=").append(entry.getValue().toString());
            }
        }
        for (int i = 0; i < paramStr.length(); ++i) {
            if (paramStr.charAt(i) != '+') continue;
            paramStr.replace(i, i + 1, "%2B");
        }
        if (paramStr.length() > 0) {
            if (url.indexOf(63) == -1) {
                return url + "?" + paramStr;
            }
            return url + "&" + paramStr;
        }
        return url;
    }
}

