/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.cache;

import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.cache.LSIDCache;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class CacheProfiler {
    public static final String OVERALL_HIT_RATE = "r";
    LSIDCache cache = null;

    public CacheProfiler(LSIDCache cache) {
        this.cache = cache;
    }

    public double computeHitRate() throws IOException {
        File cacheDir = new File(LSIDCache.getLocation());
        File log = new File(cacheDir, this.cache.getLogFileName());
        BufferedReader reader = new BufferedReader(new FileReader(log));
        String line = reader.readLine();
        int numhits = 0;
        int nummisses = 0;
        while (line != null) {
            if (line.indexOf("Read") != -1) {
                ++numhits;
            } else if (line.indexOf("Wrote") != -1) {
                ++nummisses;
            }
            line = reader.readLine();
        }
        return (double)numhits / ((double)numhits + (double)nummisses);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java com.ibm.lsid.client.cache.CacheProfile <op>");
            System.err.println("<op> = r");
            System.err.println("r - compute the overall hit rate for the cache");
            return;
        }
        if (!args[0].equals(OVERALL_HIT_RATE)) {
            System.err.println("Usage: java com.ibm.lsid.client.cache.CacheProfile <op>");
            System.err.println("<op> = r");
            System.err.println("r - compute the overall hit rate for the cache");
            return;
        }
        CacheProfiler cp = new CacheProfiler(LSIDResolver.getCache());
        System.err.println("Cache hit rate: " + cp.computeHitRate());
    }
}

