/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.async;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.async.ResolutionListener;
import com.ibm.lsid.client.async.utils.WorkPool;
import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import java.io.InputStream;

public class AsyncLSIDResolver {
    private static final int MAX_THREADS = 10;
    private WorkPool pool = new WorkPool(10);
    private ResolutionListener listener;
    private LSIDResolver resolver;
    private static int nextRequestID = 1;

    private static Integer getNextRequestID() {
        return new Integer(nextRequestID++);
    }

    public AsyncLSIDResolver(ResolutionListener listener) {
        this.listener = listener;
    }

    public AsyncLSIDResolver(ResolutionListener listener, LSID lsid) throws LSIDException {
        this.listener = listener;
        this.resolver = new LSIDResolver(lsid);
    }

    public AsyncLSIDResolver(ResolutionListener listener, LSIDAuthority authority, LSID lsid) throws LSIDException {
        this.listener = listener;
        this.resolver = new LSIDResolver(authority, lsid);
    }

    public AsyncLSIDResolver(ResolutionListener listener, LSID lsid, LSIDCredentials credentials) throws LSIDException {
        this.listener = listener;
        this.resolver = new LSIDResolver(lsid, credentials);
    }

    public AsyncLSIDResolver(ResolutionListener listener, LSIDAuthority authority, LSID lsid, LSIDCredentials credentials) throws LSIDException {
        this.listener = listener;
        this.resolver = new LSIDResolver(authority, lsid, credentials);
    }

    public AsyncLSIDResolver(ResolutionListener listener, LSIDResolver resolver) throws LSIDException {
        this.listener = listener;
        this.resolver = resolver;
    }

    public void destroy() {
        this.pool.destroy();
    }

    public LSIDResolver getLSIDResolver() {
        return this.resolver;
    }

    public Integer resolveAuthority(LSIDAuthority authority) {
        final LSIDAuthority auth = authority;
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    if (auth.isResolved()) {
                        AsyncLSIDResolver.this.listener.resolveAuthorityComplete(reqID, auth);
                    } else {
                        LSIDAuthority result = LSIDResolver.resolveAuthority(auth);
                        AsyncLSIDResolver.this.listener.resolveAuthorityComplete(reqID, result);
                    }
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getWSDLWrapper() {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDWSDLWrapper result = AsyncLSIDResolver.this.resolver.getWSDLWrapper();
                    AsyncLSIDResolver.this.listener.getWSDLWrapperComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getData() {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    InputStream result = AsyncLSIDResolver.this.resolver.getData();
                    AsyncLSIDResolver.this.listener.getDataComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getData(int start, int length) {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        final int s = start;
        final int l = length;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    InputStream result = AsyncLSIDResolver.this.resolver.getData(s, l);
                    AsyncLSIDResolver.this.listener.getDataComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getData(LSIDDataPort port) {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        final LSIDDataPort dataport = port;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    InputStream result = AsyncLSIDResolver.this.resolver.getData(dataport);
                    AsyncLSIDResolver.this.listener.getDataComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getData(LSIDDataPort port, int start, int length) {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        final int s = start;
        final int l = length;
        final LSIDDataPort dataport = port;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    InputStream result = AsyncLSIDResolver.this.resolver.getData(dataport, s, l);
                    AsyncLSIDResolver.this.listener.getDataComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getMetadata() throws LSIDException {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    MetadataResponse result = AsyncLSIDResolver.this.resolver.getMetadata();
                    AsyncLSIDResolver.this.listener.getMetadataComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getMetadata(String[] acceptedFormats) throws LSIDException {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        final String[] a = acceptedFormats;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    MetadataResponse result = AsyncLSIDResolver.this.resolver.getMetadata(a);
                    AsyncLSIDResolver.this.listener.getMetadataComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getMetadata(LSIDMetadataPort port) throws LSIDException {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        final LSIDMetadataPort metadataport = port;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    MetadataResponse result = AsyncLSIDResolver.this.resolver.getMetadata(metadataport);
                    AsyncLSIDResolver.this.listener.getMetadataComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getMetadata(LSIDMetadataPort port, String[] acceptedFormats) throws LSIDException {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        final LSIDMetadataPort metadataport = port;
        final String[] a = acceptedFormats;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    MetadataResponse result = AsyncLSIDResolver.this.resolver.getMetadata(metadataport, a);
                    AsyncLSIDResolver.this.listener.getMetadataComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getMetadataStore() throws LSIDException {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDMetadata result = AsyncLSIDResolver.this.resolver.getMetadataStore();
                    AsyncLSIDResolver.this.listener.getMetadataStoreComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getMetadataStore(String[] acceptedFormats) throws LSIDException {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        final String[] a = acceptedFormats;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDMetadata result = AsyncLSIDResolver.this.resolver.getMetadataStore(a);
                    AsyncLSIDResolver.this.listener.getMetadataStoreComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getMetadataStore(LSIDMetadataPort port) throws LSIDException {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        final LSIDMetadataPort metadataport = port;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDMetadata result = AsyncLSIDResolver.this.resolver.getMetadataStore(metadataport);
                    AsyncLSIDResolver.this.listener.getMetadataStoreComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }

    public Integer getMetadataStore(LSIDMetadataPort port, String[] acceptedFormats) throws LSIDException {
        final Integer reqID = AsyncLSIDResolver.getNextRequestID();
        final LSIDMetadataPort metadataport = port;
        final String[] a = acceptedFormats;
        this.pool.addJob(new Runnable(){

            public void run() {
                try {
                    LSIDMetadata result = AsyncLSIDResolver.this.resolver.getMetadataStore(metadataport, a);
                    AsyncLSIDResolver.this.listener.getMetadataStoreComplete(reqID, result);
                }
                catch (LSIDException e) {
                    AsyncLSIDResolver.this.listener.requestFailed(reqID, e);
                }
            }
        });
        return reqID;
    }
}

