/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.rdfagent.verifier;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.biomoby.registry.rdfagent.util.CentralAdmin;
import org.biomoby.registry.rdfagent.util.Constants;
import org.biomoby.registry.rdfagent.util.Log;
import org.biomoby.registry.rdfagent.util.Mailer;
import org.biomoby.registry.rdfagent.util.ServiceProvider;
import org.biomoby.registry.rdfagent.util.SignatureURLConnection;
import org.biomoby.registry.rdfagent.verifier.MobyServiceComparator;
import org.biomoby.shared.Central;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.NoSuccessException;
import org.biomoby.shared.PendingCurationException;
import org.biomoby.shared.Utils;
import org.biomoby.shared.extended.ServiceInstanceParser;

public class Processor {
    private String newline = System.getProperty("line.separator");
    private boolean ignoreNulls = Constants.REGISTRY_IGNORE_NULL;
    private boolean sendMail = Constants.REGISTRY_EMAIL;
    private boolean enableDeregistration = Constants.REGISTRY_ENABLE_DEREGISTER;
    private boolean enableDeregistrationFromURL = Constants.REGISTRY_ENABLE_DEREGISTER_FROM_URL;
    private boolean enableServiceUpdates = Constants.REGISTRY_ENABLE_SERVICE_UPDATES;
    private boolean useSMTP = Constants.SMTP_ENABLE;
    private int errorLimit = Constants.REGISTRY_DEREGISTER_COUNT;
    private Map invalidSignatureURLs = new HashMap();
    private Vector processedURLs = new Vector();
    private Vector processedServices = new Vector();
    private Map mailbag = new HashMap();

    public void processRegistryServices(Map serviceMap, Central central) {
        this.invalidSignatureURLs = new HashMap();
        this.processedServices = new Vector();
        this.processedURLs = new Vector();
        this.mailbag = new HashMap();
        int count = serviceMap.size();
        for (String key : serviceMap.keySet()) {
            Log.info("processing " + key);
            String signature = "";
            MobyService registryService = null;
            if (this.processedServices.contains(key)) {
                Log.info("\t" + key + " has been already processed.");
                continue;
            }
            this.processedServices.add(key);
            registryService = (MobyService)serviceMap.get(key);
            signature = registryService.getSignatureURL().trim();
            if (signature.equals("")) {
                this.processNullSignatureURLs(registryService, "", central);
                continue;
            }
            if (this.invalidSignatureURLs.containsKey(signature)) {
                Log.info("This service has been abandoned. The signatureURL no longer exists.");
                boolean success = this.removeServiceFromAbandonedURL(registryService, central, "This service is refered to by a signatureURL that no longer exists.", (Integer)this.invalidSignatureURLs.get(signature));
                this.updateMailbag(registryService.getEmailContact(), "The service, '" + registryService.getUniqueName() + "', was found to be described by a signatureURL that isn't accessible." + this.newline + "The signatureURL is: " + signature + "." + this.newline + "The service has " + (success ? "" : "not ") + "been removed (Attempts to read url " + (Integer)this.invalidSignatureURLs.get(signature) + ". Removal after " + this.errorLimit + " attempts).");
                continue;
            }
            SignatureURLConnection connection = new SignatureURLConnection();
            MobyService[] rdfServices = null;
            if (this.processedURLs.contains(signature)) continue;
            this.processedURLs.add(signature);
            rdfServices = connection.extractServicesFromURL(signature);
            if (rdfServices == null) {
                Log.info("The signature url was missing or the rdf document was invalid (RDF syntax was invalid or RDF was unparsable) at " + this.newline + signature);
                this.invalidSignatureURLs.put(signature, connection.getBadUrlMap().get(signature));
                boolean success = this.removeInvalidSignatureURLService(registryService, central, "The signature url was missing, or the rdf document was invalid (RDF syntax was invalid or RDF was unparsable) at " + signature + "." + this.newline + "The service that is said to be described by this url is " + registryService.getUniqueName() + ".", connection);
                continue;
            }
            if (rdfServices.length == 0) {
                this.invalidSignatureURLs.put(signature, connection.getBadUrlMap().get(signature));
                boolean success = this.removeInvalidSignatureURLService(registryService, central, "The signature url was missing, or the rdf document was invalid (RDF syntax was invalid or RDF was unparsable) at " + signature + "." + this.newline + "The service that is said to be described by this url is " + registryService.getUniqueName() + ".", connection);
                continue;
            }
            for (int i = 0; i < rdfServices.length; ++i) {
                MobyService rdfService = rdfServices[i];
                rdfService.setLSID("");
                String rdfKey = rdfService.getAuthority() + "," + rdfService.getName();
                MobyServiceComparator comparator = new MobyServiceComparator();
                Log.info("processing " + rdfKey + " that was found in the RDF at " + this.newline + signature);
                if (key.equals(rdfKey)) {
                    this.compareServices(central, registryService, rdfService, comparator);
                    continue;
                }
                if (this.processedServices.contains(rdfKey)) {
                    Log.info(rdfKey + " has already been processed.");
                    continue;
                }
                this.processedServices.add(rdfKey);
                if (serviceMap.containsKey(rdfKey)) {
                    MobyService existingRegistryService = (MobyService)serviceMap.get(rdfKey);
                    this.compareServices(central, existingRegistryService, rdfService, comparator);
                    continue;
                }
                Log.info("New service found. Service: " + rdfKey);
                boolean success = this.addNewServiceToRegistry(rdfService, central);
                if (!success) continue;
                this.updateMailbag(rdfService.getEmailContact(), "The agent found a new service: " + rdfService.getUniqueName() + " and attempted to register it for you." + this.newline + "The agent was successful.");
            }
            if (connection.getInvalidServicesFoundInRDF().size() <= 0) continue;
            Iterator iter = connection.getInvalidServicesFoundInRDF().iterator();
            while (iter.hasNext()) {
                this.removeInvalidServiceFromRegistry((MobyService)iter.next(), central);
            }
        }
        Log.info("Processed " + this.processedServices.size() + " out of " + count + " services.");
        this.sendMail();
    }

    private void compareServices(Central central, MobyService registryService, MobyService rdfService, MobyServiceComparator comparator) {
        boolean isRDFInvalid = false;
        if (!comparator.areInputsOutputsForServiceValid(rdfService)) {
            isRDFInvalid = true;
        }
        if (!comparator.areInputsOutputsForServiceValid(registryService)) {
            if (!isRDFInvalid) {
                int code = this.removeInvalidChangedServiceFromRegistry(registryService, central, "The service in the registry was found to be invalid, v.v the BioMoby API." + this.newline + "By invalid, there were inputs/outputs that were un-named." + this.newline + "Below are some hints as to why the service is invalid:" + this.newline + Utils.format((Object)(comparator.getServiceErrors(registryService) + this.newline), (int)2) + "A valid version of this service was found in the RDF document.");
                if (code == 200) {
                    Log.info("Attempting to register the 'good' service found in the RDF ... ");
                    boolean success = this.addServiceToRegistry(rdfService, central);
                    if (success) {
                        this.updateMailbag(rdfService.getEmailContact(), "The agent attempted to replace the invalid service " + registryService.getUniqueName() + " found in the registry" + this.newline + "with a valid one found in the RDF document at " + registryService.getSignatureURL() + "." + this.newline + "An invalid service is one that does not conform to the BioMOBY API (i.e. un-named simples or collections, missing fields, etc)." + this.newline + "The agent was successful.");
                    }
                    Log.info("Service has " + (success ? "" : "not ") + "been added to the registry.");
                }
                return;
            }
            int code = this.removeInvalidChangedServiceFromRegistry(registryService, central, "The service in the registry was found to be invalid, v.v the BioMoby API." + this.newline + "By invalid, there were inputs/outputs that were un-named.");
            this.updateMailbag(registryService.getEmailContact(), "The agent noticed that the service " + registryService.getUniqueName() + " found in the registry is invalid." + this.newline + "A similar one found in the RDF document at " + registryService.getSignatureURL() + " is also invalid." + this.newline + "An invalid service is one that does not conform to the BioMOBY API (i.e. un-named simples or collections, missing fields, etc)." + this.newline + "Below are some possible reasones as to why the service is invalid:" + this.newline + Utils.format((Object)(comparator.getServiceErrors(registryService) + this.newline), (int)2) + this.newline + "The agent was " + (code == 200 ? "" : "not ") + "successful in removing the invalid service from the registry.");
            return;
        }
        if (!isRDFInvalid && comparator.areServicesDifferent(registryService, rdfService)) {
            String differences = comparator.getDifferences();
            differences = differences.replaceAll("Service1", "The registry service");
            differences = differences.replaceAll("service1", "the registry service");
            differences = differences.replaceAll("service2", "the service found in the RDF");
            differences = differences.replaceAll("Service2", "The service found in the RDF");
            this.processModifiedServices(central, rdfService, registryService, differences);
            return;
        }
        Log.info("Finished processing: " + registryService.getUniqueName());
    }

    private void updateMailbag(String email, String message) {
        Log.info("Saving the message for " + email + " that says" + this.newline + message);
        if (this.mailbag.containsKey(email)) {
            ServiceProvider sp = (ServiceProvider)this.mailbag.get(email);
            sp.addComment(message);
            this.mailbag.remove(email);
            this.mailbag.put(email, sp);
        } else {
            ServiceProvider sp = new ServiceProvider();
            sp.setEmail(email);
            sp.addComment(message);
            this.mailbag.put(email, sp);
        }
    }

    public int processServicesFromURL(String url, Central central) {
        this.processedServices = new Vector();
        this.mailbag = new HashMap();
        int registryCount = 0;
        SignatureURLConnection connection = new SignatureURLConnection();
        MobyService[] rdfServices = null;
        HashMap<String, MobyService> foundServices = new HashMap<String, MobyService>();
        rdfServices = connection.extractServicesFromURL(url);
        try {
            MobyService[] registryServices = new MobyService[]{new MobyService()};
            registryServices[0].setCategory("");
            registryServices[0].setSignatureURL(url);
            registryServices = central.findService(registryServices[0]);
            if (registryServices == null) {
                throw new MobyException("Findservice call failed.");
            }
            registryCount = registryServices.length;
            for (int i = 0; i < registryServices.length; ++i) {
                foundServices.put(registryServices[i].getUniqueName(), registryServices[i]);
            }
        }
        catch (MobyException e) {
            Log.exception(this.getClass().getName(), "processServicesFromURL(String, Central)", e);
            Log.severe("There was a problem comunicating with the registry. The url: " + url + " was not processed.");
            return 10;
        }
        if (rdfServices == null) {
            Log.warning("Unable to retrieve the services from " + url + ".");
            for (String uniqueName : foundServices.keySet()) {
                MobyService service = (MobyService)foundServices.get(uniqueName);
                this.removeMissingServiceFromRegistry(service, central, "The RDF document located at: " + url + " was unreachable. Removing those services that " + "were said to be located there.");
            }
            if (foundServices.keySet().size() == 0) {
                return 13;
            }
            return 14;
        }
        if (rdfServices.length == 0) {
            Log.warning("Unable to retrieve the services from " + url + "." + this.newline + "All services described by that location will be removed.");
            for (String uniqueName : foundServices.keySet()) {
                MobyService service = (MobyService)foundServices.get(uniqueName);
                this.removeMissingServiceFromRegistry(service, central, "The RDF document located at: " + url + " was unreachable.");
            }
            if (foundServices.keySet().size() == 0) {
                return 13;
            }
            return 14;
        }
        Log.info("Processing the " + rdfServices.length + " found in the RDF.");
        for (int i = 0; i < rdfServices.length; ++i) {
            MobyServiceComparator comparator = new MobyServiceComparator();
            boolean isRDFValid = true;
            MobyService rdfService = rdfServices[i];
            rdfService.setLSID("");
            rdfService.setSignatureURL(url);
            MobyService registryService = null;
            if (!foundServices.containsKey(rdfService.getUniqueName())) {
                Log.info("Unable to find a service in the registry that matches (" + rdfService.getUniqueName() + ").");
                MobyService[] ms = new MobyService[]{new MobyService(rdfService.getName())};
                ms[0].setCategory("");
                ms[0].setAuthority(rdfService.getAuthority());
                try {
                    ms = central.findService(ms[0]);
                }
                catch (MobyException e) {
                    Log.exception(this.getClass().getName(), "processServicesFromURL(String, Central)", e);
                    Log.severe("There was a problem comunicating with the registry while checking for service existance.");
                    ms = null;
                }
                if (ms == null || ms.length == 0) {
                    boolean success = this.addNewServiceToRegistry(rdfService, central);
                    if (!success) continue;
                    this.updateMailbag(rdfService.getEmailContact(), "The service, " + rdfService.getUniqueName() + "," + this.newline + "was found in the RDF and was unknown to the registry, so " + this.newline + "the agent registered it for you!");
                    continue;
                }
                this.processModifiedServices(central, rdfService, ms[0], "The signatureURL has changed. There may be other changes.");
                continue;
            }
            Log.info("Found a service (" + rdfService.getUniqueName() + ") in the registry that matches the one in the RDF ..." + this.newline + "Comparing them ...");
            registryService = (MobyService)foundServices.remove(rdfService.getUniqueName());
            this.compareServices(central, registryService, rdfService, comparator);
        }
        for (String uniqueName : foundServices.keySet()) {
            MobyService service = (MobyService)foundServices.get(uniqueName);
            this.removeMissingServiceFromRegistry(service, central, "Service was not found in the RDF document located at: " + url);
        }
        Log.info("Finished processing the " + (rdfServices == null ? 0 : rdfServices.length) + " services found in the RDF." + this.newline + "\t" + "The registry contained " + registryCount + " services with the url: " + url);
        this.sendMail();
        return 0;
    }

    private void removeMissingServiceFromRegistry(MobyService service, Central central, String reason) {
        if (this.enableDeregistrationFromURL) {
            CentralAdmin centralAdmin = new CentralAdmin(Constants.REGISTRY_REMOVAL_ENDPOINT, Constants.REGISTRY_REMOVAL_URI, Constants.REGISTRY_REMOVAL_USERNAME, Constants.REGISTRY_REMOVAL_PASSWORD, Constants.REGISTRY_KEYPHRASE);
            int code = centralAdmin.deleteService(service.getName(), service.getAuthority());
            Log.info("Service " + service.getName() + ", " + service.getAuthority() + " has " + (code == 200 ? "" : "not ") + "been removed." + this.newline + "\tThe agent wanted to remove the service because " + reason);
            this.updateMailbag(service.getEmailContact(), "Service " + service.getName() + ", " + service.getAuthority() + " has " + (code == 200 ? "" : "not ") + "been removed." + this.newline + "\tThe agent wanted to remove the service because " + reason);
            this.processCentralAdminCode(code);
        } else {
            Log.info("No services removed because Agent isn't configured to remove services");
            this.updateMailbag(service.getEmailContact(), "Service " + service.getUniqueName() + " was a cannidate for removal from the registry because:" + this.newline + reason + this.newline + "But the agent is not configured to remove services.");
        }
    }

    private void processModifiedServices(Central central, MobyService rdfService, MobyService registryService, String differences) {
        Log.info("The service " + rdfService.getUniqueName() + " has changed." + this.newline + "Changes are: " + this.newline + differences);
        if (this.enableServiceUpdates) {
            Log.info("Attempting to update the service");
            boolean a = rdfService.getSignatureURL().trim().equals("");
            boolean b = registryService.getSignatureURL().trim().equals("");
            if (!(rdfService.getSignatureURL().trim().equals(registryService.getSignatureURL().trim()) || a && b || !a && b)) {
                Log.warning("Service was not updated because it is described by too many signature URLs.");
                this.updateMailbag(registryService.getEmailContact(), "The service, " + registryService.getUniqueName() + ", " + this.newline + "was found to be described by more than one signatureURL and was not updated (as a security measure). If " + this.newline + "you would like to update the signatureURL, please call the Agent on the old SignatureURL" + this.newline + "once you have removed the RDF document. Then move the updated document to the new location." + this.newline + "Then call the agent on the new signatureURL and the services will be updated." + this.newline + "The registry/rdf urls were:" + this.newline + "\t'" + registryService.getSignatureURL() + "'," + this.newline + "\t'" + rdfService.getSignatureURL() + "'");
                return;
            }
            int code = this.removeChangedServiceFromRegistry(registryService, central, differences, rdfService.getEmailContact());
            if (code == 200) {
                if (this.addServiceToRegistry(rdfService, central)) {
                    this.updateMailbag(rdfService.getEmailContact(), "The service " + rdfService.getUniqueName() + " has changed." + this.newline + "Changes are: " + this.newline + differences + this.newline + "The service was updated successfully and the changes found in the RDF were written to the registry.");
                    Log.info("Service has been updated successfully.");
                } else {
                    Log.info("Service has not been updated successfully, so attempting to roll back changes.");
                    if (!this.addServiceToRegistry(registryService, central)) {
                        Log.warning("The service, " + registryService.getUniqueName() + ", was" + this.newline + "found to be modified. The agent removed removed the service" + this.newline + "from the registry, but could not replace it with the modified version of the service." + this.newline + "As a fallback, the agent attempted to place the old service back and failed." + this.newline + "Therefore the service has been permanently removed.");
                        this.updateMailbag(registryService.getEmailContact(), "The service " + rdfService.getUniqueName() + " has changed." + this.newline + "Changes are: " + this.newline + differences + this.newline + "The agent attempted to update the service was not successful and any attempts " + this.newline + "to rollback agent changes also failed. The service is no longer in the" + this.newline + "registry. Please re-register it. Sorry...");
                    } else {
                        this.updateMailbag(registryService.getEmailContact(), "The service " + rdfService.getUniqueName() + " has changed." + this.newline + "Changes are: " + this.newline + differences + this.newline + "The service update was unsuccessful and no changes to the registry occurred.");
                        Log.info("The service " + registryService.getUniqueName() + " has been reverted back to its previous state and the changes found" + this.newline + "in the RDF were not written to the registry..");
                    }
                }
            }
        } else {
            this.updateMailbag(rdfService.getEmailContact(), "The service " + rdfService.getUniqueName() + " has changed." + this.newline + "Changes are: " + this.newline + differences + this.newline + "The service was not updated because service updates has been turned off.");
            Log.info("The service " + rdfService.getUniqueName() + " was found to be modified." + this.newline + "Since you have disabled service updates, the registry was not updated.");
        }
    }

    private void processNullSignatureURLs(MobyService service, String comment, Central central) {
        Log.info("Null signatureURL for " + service.getUniqueName() + " was found.");
        if (!this.ignoreNulls) {
            this.removeNullSignatureURLServiceFromRegistry(service);
        }
    }

    private void sendMail() {
        if (!this.sendMail) {
            Log.info("Emailing has been switched off, so no mail has been sent to any service provider.");
            return;
        }
        this.mailbag.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        for (String email : this.mailbag.keySet()) {
            if (email.trim().equals("")) {
                Log.warning("Empty email address found with the following message:" + this.newline + ((ServiceProvider)this.mailbag.get(email)).toString());
                continue;
            }
            String message = ((ServiceProvider)this.mailbag.get(email)).toString();
            message = "Date: " + new GregorianCalendar().getTime().toString() + this.newline + this.newline + "" + "This report was generated by the registry located at " + Constants.REGISTRY_URL + " (" + Constants.REGISTRY_URI + ")." + this.newline + "Please do not respond to this address as it may not exist. At the end of the message" + this.newline + "is an address that you may use to contact the registry's administrator." + this.newline + this.newline + "This message outlines the things that the agent found when examining your services:" + this.newline + message + this.newline + this.newline + this.newline + this.newline + "If you are having problems deciphering this text please mail the Moby " + this.newline + "list or contact me directly at " + Constants.ADMIN_EMAIL + this.newline + this.newline + "Thanks," + this.newline + this.newline + Constants.ADMIN_NAME + this.newline + Constants.ADMIN_EMAIL;
            Mailer mailer = new Mailer();
            if (this.useSMTP) {
                mailer.sendSMTPMail(Constants.SMTP_SERVER, Constants.SMTP_LOGIN, Constants.SMTP_PSWD, email, "RDF agent report for " + new Date(), message, Constants.ADMIN_EMAIL);
                continue;
            }
            mailer.sendMail(email, "RDF agent report for " + new Date(), message);
        }
    }

    private boolean addServiceToRegistry(MobyService service, Central central) {
        Log.info("Agent will attempt to add the Service " + service.getName() + ", " + service.getAuthority() + " ) " + this.newline + "to the registry.");
        return this.registerService(service, central);
    }

    private boolean addNewServiceToRegistry(MobyService service, Central central) {
        Log.info("A new service was found in an RDF document." + this.newline + "\tThe service is called: " + service.getName() + " under the authority: " + service.getAuthority() + "." + this.newline + "Attempting to register the service with mobycentral.");
        return this.registerService(service, central);
    }

    private boolean registerService(MobyService service, Central central) {
        try {
            central.registerService(service);
        }
        catch (MobyException e) {
            Log.exception(this.getClass().getName(), "addNewServiceToRegistry(MobyService)", e);
            Log.severe("Communication with the registry failed." + this.newline + e.getLocalizedMessage());
            Log.info("service " + service.getName() + ", " + service.getAuthority() + " has not been added to the registry.");
            this.updateMailbag(service.getEmailContact(), "The agent attempted to register the service, " + service.getUniqueName() + "," + this.newline + "and failed. The message was:" + this.newline + Utils.format((Object)("'" + e.getLocalizedMessage() + "'"), (int)3));
            return false;
        }
        catch (NoSuccessException e) {
            Log.exception(this.getClass().getName(), "addNewServiceToRegistry(MobyService)", e);
            Log.severe("There was no success with registration." + this.newline + e.getLocalizedMessage());
            Log.info("service " + service.getName() + ", " + service.getAuthority() + " has not been added to the registry.");
            this.updateMailbag(service.getEmailContact(), "The agent attempted to register the service, " + service.getUniqueName() + "," + this.newline + "and failed. The message was:" + this.newline + Utils.format((Object)("'" + e.getLocalizedMessage() + "'"), (int)3));
            return false;
        }
        catch (PendingCurationException e) {
            Log.exception(this.getClass().getName(), "addNewServiceToRegistry(MobyService)", e);
            Log.severe("The service may be registered later pending curation." + this.newline + e.getLocalizedMessage());
            Log.info("service " + service.getName() + ", " + service.getAuthority() + " has not *yet* been added to the registry.");
            this.updateMailbag(service.getEmailContact(), "The agent attempted to register the service, " + service.getUniqueName() + "," + this.newline + "and failed. The message from the registry was:" + this.newline + Utils.format((Object)("'" + e.getLocalizedMessage() + "'"), (int)3));
            return false;
        }
        Log.info("service " + service.getName() + ", " + service.getAuthority() + " has been added to the registry.");
        return true;
    }

    private int removeChangedServiceFromRegistry(MobyService service, Central central, String changes, String email) {
        Log.info("Service, (" + service.getName() + ", " + service.getAuthority() + "), was modified and will be updated.");
        CentralAdmin centralAdmin = new CentralAdmin(Constants.REGISTRY_REMOVAL_ENDPOINT, Constants.REGISTRY_REMOVAL_URI, Constants.REGISTRY_REMOVAL_USERNAME, Constants.REGISTRY_REMOVAL_PASSWORD, Constants.REGISTRY_KEYPHRASE);
        int code = centralAdmin.deleteService(service.getName(), service.getAuthority());
        this.processCentralAdminCode(code);
        return code;
    }

    private void removeInvalidServiceFromRegistry(MobyService service, Central central) {
        if (this.enableDeregistration) {
            Log.info("Attempting to remove service, (" + service.getName() + ", " + service.getAuthority() + ").");
            CentralAdmin centralAdmin = new CentralAdmin(Constants.REGISTRY_REMOVAL_ENDPOINT, Constants.REGISTRY_REMOVAL_URI, Constants.REGISTRY_REMOVAL_USERNAME, Constants.REGISTRY_REMOVAL_PASSWORD, Constants.REGISTRY_KEYPHRASE);
            int code = centralAdmin.deleteService(service.getName(), service.getAuthority());
            this.processCentralAdminCode(code);
            if (service.getEmailContact().trim().equals("")) {
                try {
                    MobyService __template__ = new MobyService(service.getName());
                    __template__.setCategory("");
                    MobyService[] services = central.findService(__template__);
                    if (services == null || services.length < 1) {
                        MobyService temp = new MobyService();
                        temp.setCategory("");
                        temp.setAuthority(service.getAuthority());
                        services = central.findService(temp);
                        if (services != null && services.length >= 1) {
                            service.setEmailContact(services[0].getEmailContact());
                        }
                    } else {
                        service.setEmailContact(services[0].getEmailContact());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String msg = "";
            if (code == 404) {
                msg = "The service wasn't removed from the registry, because it wasn't found!";
            }
            this.updateMailbag(service.getEmailContact(), "The agent noticed that the service " + service.getUniqueName() + " found in the RDF is invalid." + this.newline + "An invalid service is one that has un-named inputs/outputs, missing fields like " + this.newline + "a contact email address or that do not conform to the BioMOBY API." + this.newline + "Some possible reasons that the service is invalid are listed below:" + this.newline + Utils.format((Object)new MobyServiceComparator().getServiceErrors(service), (int)3) + this.newline + "The agent was " + (code == 200 ? "" : "not ") + "successful in removing the invalid service from the registry." + this.newline + msg);
        } else {
            if (service.getEmailContact().trim().equals("")) {
                try {
                    MobyService __template__ = new MobyService(service.getName());
                    __template__.setCategory("");
                    MobyService[] services = central.findService(__template__);
                    if (services == null || services.length < 1) {
                        MobyService temp = new MobyService();
                        temp.setCategory("");
                        temp.setAuthority(service.getAuthority());
                        services = central.findService(temp);
                        if (services != null && services.length >= 1) {
                            service.setEmailContact(services[0].getEmailContact());
                        }
                    } else {
                        service.setEmailContact(services[0].getEmailContact());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.updateMailbag(service.getEmailContact(), "The agent noticed that the service " + service.getUniqueName() + " found in the RDF is invalid." + this.newline + "An invalid service is one that has un-named inputs/outputs, missing fields like " + this.newline + "a contact email address or that do not conform to the BioMOBY API." + this.newline + "Some possible reasons that the service is invalid are listed below:" + this.newline + Utils.format((Object)new MobyServiceComparator().getServiceErrors(service), (int)3) + this.newline + "The agent was not allowed to remove the service because service removal is turned off.");
        }
    }

    private void removeNullSignatureURLServiceFromRegistry(MobyService service) {
        if (this.enableDeregistration) {
            Log.info("Attempting to remove service, (" + service.getName() + ", " + service.getAuthority() + ").");
            CentralAdmin centralAdmin = new CentralAdmin(Constants.REGISTRY_REMOVAL_ENDPOINT, Constants.REGISTRY_REMOVAL_URI, Constants.REGISTRY_REMOVAL_USERNAME, Constants.REGISTRY_REMOVAL_PASSWORD, Constants.REGISTRY_KEYPHRASE);
            int code = centralAdmin.deleteService(service.getName(), service.getAuthority());
            this.processCentralAdminCode(code);
            this.updateMailbag(service.getEmailContact(), "The agent noticed that the service " + service.getUniqueName() + " found in the RDF had a NULL signatureURL." + this.newline + "The agent was " + (code == 200 ? "" : "not ") + "successful in removing this service from the registry.");
        } else {
            this.updateMailbag(service.getEmailContact(), "The agent noticed that the service " + service.getUniqueName() + " found in the RDF contained a NULL signatureURL." + this.newline + "The agent was not allowed to remove this service because service removal is turned off.");
        }
    }

    private int removeInvalidChangedServiceFromRegistry(MobyService service, Central central, String changes) {
        Log.info("Attempting to remove service, (" + service.getName() + ", " + service.getAuthority() + ").");
        CentralAdmin centralAdmin = new CentralAdmin(Constants.REGISTRY_REMOVAL_ENDPOINT, Constants.REGISTRY_REMOVAL_URI, Constants.REGISTRY_REMOVAL_USERNAME, Constants.REGISTRY_REMOVAL_PASSWORD, Constants.REGISTRY_KEYPHRASE);
        int code = centralAdmin.deleteService(service.getName(), service.getAuthority());
        boolean success = this.processCentralAdminCode(code);
        Log.info("Service has " + (success ? "" : "not ") + "been removed.");
        return code;
    }

    private boolean removeInvalidSignatureURLService(MobyService service, Central central, String reason, SignatureURLConnection connection) {
        int count = 0;
        if (!service.getSignatureURL().equals("") && connection.getBadUrlMap().containsKey(service.getSignatureURL())) {
            count = (Integer)connection.getBadUrlMap().get(service.getSignatureURL());
        }
        if (this.enableDeregistration) {
            if (count >= this.errorLimit) {
                Log.info("Attempting to remove the service " + service.getName() + ", " + service.getAuthority() + "." + this.newline + "\tRemoved because '" + reason + "'");
                CentralAdmin centralAdmin = new CentralAdmin(Constants.REGISTRY_REMOVAL_ENDPOINT, Constants.REGISTRY_REMOVAL_URI, Constants.REGISTRY_REMOVAL_USERNAME, Constants.REGISTRY_REMOVAL_PASSWORD, Constants.REGISTRY_KEYPHRASE);
                int code = centralAdmin.deleteService(service.getName(), service.getAuthority());
                this.updateMailbag(service.getEmailContact(), "Service, " + service.getName() + ", was " + (code == 200 ? "" : "not ") + "removed. If it was removed, it is because its signatureURL, " + this.newline + service.getSignatureURL() + " has been unreachable for " + count + " consecutive attempts.");
                return this.processCentralAdminCode(code);
            }
            Log.info("Service, " + service.getName() + ", was not removed because its" + this.newline + "error count did not exceed the threshold required for service removal." + this.newline + "Threshold is " + this.errorLimit + " and your count is " + count + ". Your count is the total number of consecutive failures.");
            this.updateMailbag(service.getEmailContact(), "Service, " + service.getName() + ", was not removed because its" + this.newline + "error count did not exceed the threshold required for service removal." + this.newline + "The reason the service was a canidate for removal is that" + this.newline + "'" + service.getSignatureURL() + "'" + " is not accessible or does not describe BioMOBY servicess." + this.newline + "Threshold is " + this.errorLimit + " and your count is " + count + ". Your count is the total number of consecutive failures.");
        }
        return false;
    }

    private boolean removeServiceFromAbandonedURL(MobyService service, Central central, String reason, int count) {
        if (this.enableDeregistration && count >= this.errorLimit) {
            Log.info("Service " + service.getName() + ", " + service.getAuthority() + " has been removed." + this.newline + "\tRemoved because:" + this.newline + "\t" + reason + this.newline + "The agent has made " + count + " attempts to resolve and correctly parse the" + " service description url.");
            CentralAdmin centralAdmin = new CentralAdmin(Constants.REGISTRY_REMOVAL_ENDPOINT, Constants.REGISTRY_REMOVAL_URI, Constants.REGISTRY_REMOVAL_USERNAME, Constants.REGISTRY_REMOVAL_PASSWORD, Constants.REGISTRY_KEYPHRASE);
            int code = centralAdmin.deleteService(service.getName(), service.getAuthority());
            return this.processCentralAdminCode(code);
        }
        return false;
    }

    private boolean removeOrphanedService(MobyService service, Central central, String reason) {
        if (this.enableDeregistrationFromURL) {
            Log.info("Service " + service.getName() + ", " + service.getAuthority() + " has been removed." + this.newline + "\tRemoved because " + reason + this.newline);
            CentralAdmin centralAdmin = new CentralAdmin(Constants.REGISTRY_REMOVAL_ENDPOINT, Constants.REGISTRY_REMOVAL_URI, Constants.REGISTRY_REMOVAL_USERNAME, Constants.REGISTRY_REMOVAL_PASSWORD, Constants.REGISTRY_KEYPHRASE);
            int code = centralAdmin.deleteService(service.getName(), service.getAuthority());
            return this.processCentralAdminCode(code);
        }
        Log.info("No services removed because Agent isnt configured to remove services");
        return false;
    }

    private boolean processCentralAdminCode(int code) {
        boolean bool = false;
        switch (code) {
            case 101: {
                Log.warning("Central admin didnt receive an service provider authority");
                bool = false;
                break;
            }
            case 102: {
                Log.warning("Central Admin didnt receive a service name to remove");
                bool = false;
                break;
            }
            case 103: {
                Log.warning("Central Admin didnt receive a phrase.");
                bool = false;
                break;
            }
            case 200: {
                Log.info("Service was successfully removed.");
                bool = true;
                break;
            }
            case 404: {
                Log.severe("Oddly enough, the service wasnt found in the registry!?!");
                bool = false;
                break;
            }
            case 501: {
                Log.severe("The keyphrase specified in the config file didn't match the one in the registry's DB config file.");
                bool = false;
                break;
            }
            case 505: {
                Log.severe("Something weird happened with the registry. Please check your registry's error logs.");
                bool = false;
                break;
            }
            case 506: {
                Log.severe("Central Admin may not have understood our request.");
                bool = false;
                break;
            }
            case 507: {
                Log.severe("There was an AxisFault. Are you online? Are the username and password correct?");
                bool = false;
                break;
            }
            case 508: {
                Log.severe("The url and/or uri for the Central Admin service were invalid.");
                bool = false;
                break;
            }
            default: {
                Log.severe("Central Admin returned an unknown code: " + code);
                bool = false;
            }
        }
        return bool;
    }

    public String processServicesFromUrlTEST(String url) {
        MobyService[] rdfServices = null;
        StringBuffer sb = new StringBuffer();
        ServiceInstanceParser p = null;
        try {
            p = new ServiceInstanceParser(url);
            rdfServices = p.getMobyServicesFromRDF();
        }
        catch (MobyException e) {
            sb.append("Exception from processServicesFromUrlTEST(String, Central)" + e.getLocalizedMessage() + this.newline);
            Log.exception(this.getClass().getName(), "processServicesFromUrlTEST(String, Central)", e);
            return sb.toString();
        }
        catch (Exception ex) {
            sb.append("Exception from processServicesFromUrlTEST(String, Central)" + ex.getLocalizedMessage() + this.newline);
            Log.exception(this.getClass().getName(), "processServicesFromUrlTEST(String, Central)", ex);
            return sb.toString();
        }
        if (p != null) {
            if (rdfServices == null) {
                Log.warning("Unable to retrieve the services from " + url + ".");
                sb.append("There was a problem extracting the services. Perhaps the rdf is invalid." + this.newline);
                return sb.toString();
            }
            if (rdfServices.length == 0) {
                if (p.isRDFValid()) {
                    Log.info("Unable to retrieve any services from " + url + "." + this.newline + "Most likely cause is that there were none.");
                    sb.append("Unable to retrieve any services from " + url + "." + this.newline + "Most likely cause is that there were none.");
                } else {
                    Log.info("Unable to retrieve any services from " + url + "." + this.newline + "Some of the problems are: " + Utils.format((Object)p.getErrors(), (int)2));
                    sb.append("Unable to retrieve any services from " + url + "." + this.newline + "Some of the problems are: " + Utils.format((Object)p.getErrors(), (int)2));
                }
                return sb.toString();
            }
            Log.info("Found the following services in the RDF located at " + url);
            sb.append("Found the following services in the RDF located at " + url + this.newline);
            for (int i = 0; i < rdfServices.length; ++i) {
                MobyServiceComparator comparator = new MobyServiceComparator();
                MobyService serv = rdfServices[i];
                if (!comparator.areInputsOutputsForServiceValid(serv)) {
                    Log.info(Utils.format((Object)("Invalid service found: " + serv.getUniqueName()), (int)2));
                    sb.append(Utils.format((Object)("Invalid service found: " + serv.getUniqueName()), (int)2) + this.newline);
                    continue;
                }
                Log.info(Utils.format((Object)serv, (int)2));
                sb.append(Utils.format((Object)serv, (int)2) + this.newline);
            }
            if (!p.isRDFValid()) {
                Log.info("In addition, I found the following invalid services in the RDF located at " + url + this.newline + Utils.format((Object)p.getErrors(), (int)2));
                sb.append("In addition, I found the following invalid services in the RDF located at " + url + this.newline + Utils.format((Object)p.getErrors(), (int)2));
            }
        }
        return sb.toString();
    }
}

