/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.rdfagent.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.biomoby.registry.rdfagent.util.Log;

public class Mailer {
    private String newline = System.getProperty("line.separator");
    private boolean standAlone = false;
    private final String _shellScriptHeader = "#!/bin/sh" + System.getProperty("line.separator");

    public Mailer() {
        if (!Log.isLoggable()) {
            this.standAlone = true;
            Log.start(System.getProperty("user.dir"), Log.ALL, true, "Logger started by " + this.getClass().getName());
        }
    }

    public boolean sendSMTPMail(String server, String login, String pass, String recipient, String subject, String body, String from) {
        Properties prop = new Properties();
        prop.put("mail.smtp.host", server);
        Session session = Session.getDefaultInstance((Properties)prop, null);
        MimeMessage msg = new MimeMessage(session);
        try {
            msg.setFrom((Address)new InternetAddress(from));
        }
        catch (AddressException e) {
            Log.exception(this.getClass().getName(), "sendSMTPMail", e);
            Log.severe("The mailers from address was invalid. Please ensure that it is correct.");
            return false;
        }
        catch (MessagingException e) {
            Log.exception(this.getClass().getName(), "sendSMTPMail", e);
            Log.severe(e.getLocalizedMessage());
            return false;
        }
        try {
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        }
        catch (AddressException e) {
            Log.exception(this.getClass().getName(), "sendSMTPMail", e);
            Log.severe("The mailers to address was invalid. Please ensure that it is correct");
            return false;
        }
        catch (MessagingException e) {
            Log.exception(this.getClass().getName(), "sendSMTPMail", e);
            Log.severe(e.getLocalizedMessage());
            return false;
        }
        try {
            msg.setSubject(subject);
        }
        catch (MessagingException e) {
            Log.exception(this.getClass().getName(), "sendSMTPMail", e);
            Log.severe("Couldn't set the subject of the mail message.");
            return false;
        }
        try {
            msg.setSentDate(new Date());
        }
        catch (MessagingException e) {
            Log.exception(this.getClass().getName(), "sendSMTPMail", e);
            Log.severe(e.getLocalizedMessage());
            return false;
        }
        try {
            msg.setText(body);
        }
        catch (MessagingException e) {
            Log.exception(this.getClass().getName(), "sendSMTPMail", e);
            Log.severe("");
            return false;
        }
        if (pass != null) {
            Transport transport;
            try {
                transport = session.getTransport("smtp");
            }
            catch (NoSuchProviderException e) {
                Log.exception(this.getClass().getName(), "sendSMTPMail", e);
                Log.severe("");
                return false;
            }
            try {
                transport.connect(server, login, pass);
            }
            catch (MessagingException e) {
                Log.exception(this.getClass().getName(), "sendSMTPMail", e);
                Log.severe(e.getLocalizedMessage());
                return false;
            }
        }
        try {
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            Log.exception(this.getClass().getName(), "sendSMTPMail", e);
            Log.severe(e.getLocalizedMessage());
            return false;
        }
        Log.info("Message sent via SMTP to " + recipient);
        return true;
    }

    public boolean sendMail(String recipient, String subject, String body) {
        Process p;
        String cmd = "echo \"" + body + "\" | mail" + " -s '" + subject + "' '" + recipient + "'";
        File file = null;
        try {
            file = File.createTempFile("__script__", ".sh");
        }
        catch (IOException e) {
            Log.exception(this.getClass().getName(), "sendMail", e);
            Log.severe("Couldn't create the temp file needed to be used with 'mail'. No message was sent.");
            return false;
        }
        FileWriter fw = null;
        Log.info(file.getAbsolutePath());
        try {
            fw = new FileWriter(file);
        }
        catch (IOException e) {
            Log.exception(this.getClass().getName(), "sendMail", e);
            Log.severe("Couldn't create the file writer needed to be used with 'mail'. No message was sent.");
            Log.info(file.getAbsolutePath() + " has " + (file.delete() ? "" : "not ") + "been deleted");
            return false;
        }
        try {
            fw.write(this._shellScriptHeader + cmd);
        }
        catch (IOException e) {
            Log.exception(this.getClass().getName(), "sendMail", e);
            Log.severe("Couldn't write to the file needed to be used with 'mail'. No message was sent.");
            Log.info(file.getAbsolutePath() + " has " + (file.delete() ? "" : "not ") + "been deleted");
            return false;
        }
        try {
            fw.close();
        }
        catch (IOException e) {
            Log.exception(this.getClass().getName(), "sendMail", e);
            Log.severe("Couldn't close the file (after writing to it) needed for use with 'mail'. No message was sent.");
            Log.info(file.getAbsolutePath() + " has " + (file.delete() ? "" : "not ") + "been deleted");
            return false;
        }
        try {
            p = Runtime.getRuntime().exec("chmod +x " + file.getAbsolutePath());
        }
        catch (IOException e) {
            Log.exception(this.getClass().getName(), "sendMail", e);
            Log.severe("Couldn't chmod the script that sends mail. No message was sent.");
            Log.info(file.getAbsolutePath() + " has " + (file.delete() ? "" : "not ") + "been deleted");
            return false;
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Log.exception(this.getClass().getName(), "sendMail", e);
            Log.severe("Process that was performing a chmod was interrupted. No message was sent.");
            Log.info(file.getAbsolutePath() + " has " + (file.delete() ? "" : "not ") + "been deleted");
            return false;
        }
        try {
            p = Runtime.getRuntime().exec(file.getAbsolutePath());
        }
        catch (IOException e) {
            Log.exception(this.getClass().getName(), "sendMail", e);
            Log.severe("Couldn't execute the script that sends mail. No message was sent.");
            Log.info(file.getAbsolutePath() + " has " + (file.delete() ? "" : "not ") + "been deleted");
            return false;
        }
        InputStream stderr = p.getErrorStream();
        InputStreamReader isr = new InputStreamReader(stderr);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
            }
        }
        catch (IOException e) {
            Log.exception(this.getClass().getName(), "sendMail", e);
            Log.severe("I/O exception while sending mail. Not sure if the message was sent.");
            Log.info(file.getAbsolutePath() + " has " + (file.delete() ? "" : "not ") + "been deleted");
            return false;
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Log.exception(this.getClass().getName(), "sendMail", e);
            Log.severe("Process that was sending mail was interrupted. Not sure if the message was sent.");
            Log.info("_script_.sh has " + (file.delete() ? "" : "not ") + "been deleted");
            return false;
        }
        if (!file.delete()) {
            Log.info(file.getAbsolutePath() + " has not been deleted" + this.newline + "The exit value of the spawned process was : " + p.exitValue() + this.newline + "Message has been sent to " + recipient);
        }
        return true;
    }

    protected void finalize() throws Throwable {
        if (this.standAlone) {
            Log.stop("Logger stopped by " + this.getClass().getName());
        }
        super.finalize();
    }
}

