/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.rdfagent.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Config {
    private Hashtable configs;

    public Config(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        this.readConfig(br);
    }

    private void readConfig(BufferedReader br) throws IOException {
        String line;
        this.configs = new Hashtable();
        Properties current = new Properties();
        this.configs.put("", current);
        while ((line = br.readLine()) != null) {
            int eqindex;
            int index = line.indexOf(35);
            if (index >= 0) {
                line = line.substring(0, index);
            }
            if (line.equals("")) continue;
            if (line.startsWith("[")) {
                int endindex = line.indexOf(93);
                if (endindex < 0) continue;
                String newSection = line.substring(1, endindex);
                current = this.configs.get(newSection) != null ? (Properties)this.configs.get(newSection) : new Properties();
                this.configs.put(newSection, current);
                continue;
            }
            boolean escaped = false;
            int start = 0;
            do {
                escaped = false;
                eqindex = line.indexOf(61, start);
                if (eqindex <= 0 || line.charAt(eqindex - 1) != '\\') continue;
                escaped = true;
                start = eqindex;
                line = line.substring(0, eqindex - 1) + line.substring(eqindex);
            } while (escaped);
            String key = "";
            String value = "";
            if (eqindex >= 0) {
                key = line.substring(0, eqindex);
                value = line.substring(eqindex + 1);
            } else {
                key = line;
            }
            current.put(key, value);
        }
        br.close();
    }

    public Enumeration getSections() {
        return this.configs.keys();
    }

    public Properties getProperties(String sectionName) {
        return (Properties)this.configs.get(sectionName);
    }

    public String getProperty(String section, String key, String defaultstring) {
        Properties p = this.getProperties(section);
        if (p != null) {
            return p.getProperty(key, defaultstring);
        }
        return defaultstring;
    }
}

