/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestIndividual
extends OntTestBase {
    public static TestSuite suite() {
        return new TestIndividual("TestIndividual");
    }

    public TestIndividual(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("Individual.sameAs", true, false, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntClass A = m.createClass("http://jena.hpl.hp.com/testing/ontology#A");
                Individual x = m.createIndividual((Resource)A);
                Individual y = m.createIndividual((Resource)A);
                Individual z = m.createIndividual((Resource)A);
                x.addSameAs((Resource)y);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.SAME_AS()));
                1.assertEquals((String)"x should be the same as y", (Object)y, (Object)x.getSameAs());
                1.assertTrue((String)"x should be the same as y", (boolean)x.isSameAs((Resource)y));
                x.addSameAs((Resource)z);
                1.assertEquals((String)"Cardinality should be 2", (int)2, (int)x.getCardinality(prof.SAME_AS()));
                this.iteratorTest((Iterator)x.listSameAs(), new Object[]{z, y});
                x.setSameAs((Resource)z);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.SAME_AS()));
                1.assertEquals((String)"x should be same indiv. as z", (Object)z, (Object)x.getSameAs());
                x.removeSameAs((Resource)y);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.SAME_AS()));
                x.removeSameAs((Resource)z);
                1.assertEquals((String)"Cardinality should be 0", (int)0, (int)x.getCardinality(prof.SAME_AS()));
            }
        }};
    }
}

