/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf.converters;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.IURIGenerator;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.converters.TextParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class VCardParser
extends TextParser {
    static String[] s_Nfields = new String[]{"familyName", "givenName", "middleName"};

    public void parse(Resource res, InputStream is, IRDFContainer target, IURIGenerator uirg) throws RDFException, IOException {
        String str;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((str = br.readLine()) != null) {
            String label;
            int colon = str.indexOf(58);
            if (colon == -1 || (label = str.substring(0, colon)).equals("BEGIN") || label.equals("END") || label.equals("VERSION")) continue;
            String value = str.substring(colon + 1);
            int semicolon = label.indexOf(59);
            String qualifier = null;
            if (semicolon != -1) {
                qualifier = label.substring(semicolon + 1);
                label = label.substring(0, semicolon);
            }
            target.add(new Statement(res, Constants.s_rdf_type, Constants.s_haystack_Person));
            if (label.equals("N")) {
                int i = 0;
                StringTokenizer st = new StringTokenizer(label, ";");
                while (st.hasMoreTokens() && i < s_Nfields.length) {
                    String token = st.nextToken();
                    target.add(new Statement(res, new Resource("http://haystack.lcs.mit.edu/schemata/vcard#" + s_Nfields[i]), new Literal(token)));
                    ++i;
                }
                continue;
            }
            if (!label.equals("FN")) continue;
            target.add(new Statement(res, Constants.s_dc_title, new Literal(value)));
        }
    }
}

