/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf.converters;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.IURIGenerator;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.converters.TextParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PDBParser
extends TextParser {
    public static final String s_pdb_namespace = "http://haystack.lcs.mit.edu/schemata/pdb#";
    public static final Resource s_pdb_classification = new Resource("http://haystack.lcs.mit.edu/schemata/pdb#classification");
    public static final Resource s_pdb_Protein = new Resource("http://haystack.lcs.mit.edu/schemata/pdb#Protein");
    public static final Resource s_pdb_depDate = new Resource("http://haystack.lcs.mit.edu/schemata/pdb#depDate");
    public static final Resource s_pdb_idCode = new Resource("http://haystack.lcs.mit.edu/schemata/pdb#idCode");

    protected void addPart(String data, int start, int stop, Resource res, IRDFContainer target, Resource predicate) throws RDFException {
        if (stop > data.length()) {
            stop = data.length();
        }
        target.add(new Statement(res, predicate, new Literal(data.substring(start, stop).trim())));
    }

    public void parse(Resource res, InputStream is, IRDFContainer target, IURIGenerator uirg) throws RDFException, IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer title = new StringBuffer();
        while ((line = br.readLine()) != null) {
            if (line.length() < 10) continue;
            String type = line.substring(0, 7).trim();
            String data = line.substring(10).trim();
            if (type.equals("HEADER")) {
                this.addPart(line, 10, 50, res, target, s_pdb_classification);
                this.addPart(line, 50, 59, res, target, s_pdb_depDate);
                this.addPart(line, 62, 66, res, target, s_pdb_idCode);
                continue;
            }
            if (!type.equals("TITLE")) continue;
            title.append(data);
        }
        target.add(new Statement(res, Constants.s_dc_title, new Literal(title.toString())));
        target.add(new Statement(res, Constants.s_rdf_type, s_pdb_Protein));
    }
}

