/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf.converters;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.ozone.parts.calendar.CalendarConstants;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.rdf.converters.TextParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.jical.iCalendar;
import org.jical.iCalendarParser;
import org.jical.iCalendarVEvent;

public class ICalendarParser
extends TextParser {
    protected Resource internalParse(Reader reader, IRDFContainer target) throws RDFException, IOException {
        int c;
        File file = File.createTempFile("haystack", "ics");
        FileWriter fw = new FileWriter(file);
        char[] buffer = new char[65536];
        while ((c = reader.read(buffer)) > 0) {
            fw.write(buffer, 0, c);
        }
        fw.close();
        iCalendarParser parser = new iCalendarParser();
        iCalendar ical = parser.iCalendarParser(file);
        Resource resCollection = Utilities.generateUniqueResource();
        target.add(new Statement(resCollection, Constants.s_rdf_type, Constants.s_haystack_Collection));
        target.add(new Statement(resCollection, Constants.s_dc_title, new Literal("Calendar")));
        Iterator i = ical.icalEventCollection.iterator();
        while (i.hasNext()) {
            iCalendarVEvent event = (iCalendarVEvent)i.next();
            Resource res = new Resource("urn:ical:" + event.getUid());
            target.add(new Statement(res, Constants.s_rdf_type, CalendarConstants.Appointment));
            if (event.getSummary() != null) {
                target.add(new Statement(res, Constants.s_dc_title, new Literal(event.getSummary())));
            }
            target.add(new Statement(res, CalendarConstants.startTime, Utilities.generateDateTime(event.getDateStart())));
            long l = event.getDateEnd().getTime() - event.getDateStart().getTime();
            target.add(new Statement(res, CalendarConstants.duration, new Literal(Long.toString(l))));
            target.add(new Statement(resCollection, Constants.s_haystack_member, res));
        }
        return resCollection;
    }
}

