/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf.converters;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.rdf.converters.BibtexParserConstants;
import edu.mit.lcs.haystack.rdf.converters.BibtexParserTokenManager;
import edu.mit.lcs.haystack.rdf.converters.ParseException;
import edu.mit.lcs.haystack.rdf.converters.SimpleCharStream;
import edu.mit.lcs.haystack.rdf.converters.Token;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public final class BibtexParser
implements BibtexParserConstants {
    private static String CLASS = Constants.s_rdf_type.getContent();
    private static String ID = "id";
    private String preamble = "";
    private Map strings = new HashMap();
    private Map records = new HashMap();
    public BibtexParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private final int[] jj_la1_0 = new int[0];
    private final JJCalls[] jj_2_rtns = new JJCalls[69];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    Map getRecords() {
        return this.records;
    }

    private void resolveCrossrefs() {
        Iterator i = this.records.values().iterator();
        while (i.hasNext()) {
            Map record = (Map)i.next();
            if (!record.containsKey("crossref")) continue;
            String crosskey = (String)record.get("crossref");
            if (crosskey.startsWith("{")) {
                crosskey = crosskey.substring(1, crosskey.length() - 1);
            }
            if (!this.records.containsKey(crosskey)) continue;
            Map crossref = (Map)this.records.get(crosskey);
            Iterator j = crossref.keySet().iterator();
            while (j.hasNext()) {
                Object key = j.next();
                if (record.containsKey(key)) continue;
                record.put(key, crossref.get(key));
            }
            record.remove("crossref");
        }
    }

    public static void main(String[] args) throws ParseException {
        try {
            BibtexParser p = new BibtexParser(new BufferedReader(new FileReader(args[0])));
            p.parse();
            p.printout();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    void printout() {
        if (!"".equals(this.preamble)) {
            System.out.println("DEBUG: Found Preamble: \n" + this.preamble);
        }
        System.out.println("DEBUG: Found " + this.strings.size() + " Strings:");
        Iterator<Object> iter = this.strings.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            System.out.println("\t" + key + "\t" + this.strings.get(key));
        }
        System.out.println("DEBUG: Found " + this.records.size() + " Records:");
        iter = this.records.values().iterator();
        while (iter.hasNext()) {
            System.out.println("\n ----------------------------------- ");
            Map record = (Map)iter.next();
            System.out.println("TYPE:\t" + record.get(CLASS));
            System.out.println("ID:\t" + record.get(ID));
            Iterator jiter = record.keySet().iterator();
            while (jiter.hasNext()) {
                String key = (String)jiter.next();
                if (key == CLASS || key == ID) continue;
                System.out.println("\tFIELD:\t" + key + "\t" + record.get(key));
            }
        }
    }

    public final void parse() throws ParseException {
        while (this.jj_2_1(3)) {
            if (this.jj_2_2(3)) {
                this.strdef();
                continue;
            }
            if (this.jj_2_3(3)) {
                this.recdef();
                continue;
            }
            if (this.jj_2_4(3)) {
                this.predef();
                continue;
            }
            if (this.jj_2_5(3)) {
                this.jj_consume_token(15);
                continue;
            }
            if (this.jj_2_6(3)) {
                this.jj_consume_token(7);
                continue;
            }
            if (this.jj_2_7(3)) {
                this.jj_consume_token(2);
                continue;
            }
            if (this.jj_2_8(3)) {
                this.jj_consume_token(0);
                return;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.resolveCrossrefs();
    }

    /*
     * WARNING - void declaration
     */
    public final void predef() throws ParseException {
        void var1_1;
        String val;
        this.jj_consume_token(1);
        this.jj_consume_token(4);
        if (this.jj_2_9(3)) {
            this.jj_consume_token(2);
        }
        if (this.jj_2_14(3)) {
            this.jj_consume_token(11);
            if (this.jj_2_10(3)) {
                this.jj_consume_token(2);
            }
            val = this.val();
            if (this.jj_2_11(3)) {
                this.jj_consume_token(2);
            }
            this.jj_consume_token(12);
        } else if (this.jj_2_15(3)) {
            this.jj_consume_token(8);
            if (this.jj_2_12(3)) {
                this.jj_consume_token(2);
            }
            val = this.val();
            if (this.jj_2_13(3)) {
                this.jj_consume_token(2);
            }
            this.jj_consume_token(9);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.preamble = String.valueOf(this.preamble) + (String)var1_1;
    }

    public final void strdef() throws ParseException {
        this.jj_consume_token(1);
        this.jj_consume_token(3);
        if (this.jj_2_16(3)) {
            this.jj_consume_token(2);
        }
        if (this.jj_2_19(3)) {
            this.jj_consume_token(11);
            this.pair(this.strings);
            if (this.jj_2_17(3)) {
                this.jj_consume_token(2);
            }
            this.jj_consume_token(12);
        } else if (this.jj_2_20(3)) {
            this.jj_consume_token(8);
            this.pair(this.strings);
            if (this.jj_2_18(3)) {
                this.jj_consume_token(2);
            }
            this.jj_consume_token(9);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void recdef() throws ParseException {
        Token t2 = null;
        HashMap<String, String> record = new HashMap<String, String>();
        this.jj_consume_token(1);
        Token t1 = this.jj_consume_token(15);
        if (this.jj_2_21(3)) {
            this.jj_consume_token(2);
        }
        if (this.jj_2_30(3)) {
            this.jj_consume_token(11);
            if (this.jj_2_22(3)) {
                this.jj_consume_token(2);
            }
            t2 = this.jj_consume_token(15);
            while (this.jj_2_23(3)) {
                this.jj_consume_token(7);
                this.pair(record);
            }
            if (this.jj_2_24(3)) {
                this.jj_consume_token(7);
            }
            if (this.jj_2_25(3)) {
                this.jj_consume_token(2);
            }
            this.jj_consume_token(12);
        } else if (this.jj_2_31(3)) {
            this.jj_consume_token(8);
            if (this.jj_2_26(3)) {
                this.jj_consume_token(2);
            }
            t2 = this.jj_consume_token(15);
            while (this.jj_2_27(3)) {
                this.jj_consume_token(7);
                this.pair(record);
            }
            if (this.jj_2_28(3)) {
                this.jj_consume_token(7);
            }
            if (this.jj_2_29(3)) {
                this.jj_consume_token(2);
            }
            this.jj_consume_token(9);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        String type = t1.toString().toLowerCase();
        String id = t2.toString();
        record.put(CLASS, type.equals("conference") ? "inproceedings" : type);
        record.put(ID, id);
        this.records.put(id, record);
    }

    public final void pair(Map map) throws ParseException {
        if (this.jj_2_32(3)) {
            this.jj_consume_token(2);
        }
        Token id = this.jj_consume_token(15);
        if (this.jj_2_33(3)) {
            this.jj_consume_token(2);
        }
        this.jj_consume_token(5);
        if (this.jj_2_34(3)) {
            this.jj_consume_token(2);
        }
        String val = this.vals();
        map.put(id.toString().toLowerCase(), val);
    }

    public final String vals() throws ParseException {
        StringBuffer sb = new StringBuffer();
        String val = this.val();
        sb.append(val);
        while (this.jj_2_35(3)) {
            if (this.jj_2_36(3)) {
                this.jj_consume_token(2);
            }
            this.jj_consume_token(6);
            if (this.jj_2_37(3)) {
                this.jj_consume_token(2);
            }
            val = this.val();
            if (sb.charAt(0) == '{') {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (val.startsWith("{")) {
                val = val.substring(1, val.length() - 1);
            }
            sb.append(" " + val + "}");
        }
        return sb.toString();
    }

    public final String val() throws ParseException {
        if (this.jj_2_38(3)) {
            this.jj_consume_token(11);
            String val = this.wordsq();
            this.jj_consume_token(12);
            return "{" + val + "}";
        }
        if (this.jj_2_39(3)) {
            this.jj_consume_token(10);
            String val = this.words();
            this.jj_consume_token(10);
            return "{" + val + "}";
        }
        if (this.jj_2_40(3)) {
            Token token = this.jj_consume_token(15);
            String key = token.toString().toLowerCase();
            if (this.strings.containsKey(key)) {
                return (String)this.strings.get(key);
            }
            return key;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String wordsq() throws ParseException {
        StringBuffer sb = new StringBuffer();
        while (this.jj_2_41(3)) {
            String s;
            if (this.jj_2_42(3)) {
                s = this.wordq();
                sb.append(s);
                continue;
            }
            if (this.jj_2_43(3)) {
                this.jj_consume_token(11);
                s = this.wordsq();
                this.jj_consume_token(12);
                sb.append("{" + s + "}");
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return sb.toString();
    }

    public final String words() throws ParseException {
        StringBuffer sb = new StringBuffer();
        while (this.jj_2_44(3)) {
            String s;
            if (this.jj_2_45(3)) {
                s = this.word();
                sb.append(s);
                continue;
            }
            if (this.jj_2_46(3)) {
                this.jj_consume_token(11);
                s = this.wordsq();
                this.jj_consume_token(12);
                sb.append("{" + s + "}");
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return sb.toString();
    }

    public final String wordq() throws ParseException {
        Token t;
        if (this.jj_2_47(3)) {
            t = this.jj_consume_token(2);
        } else if (this.jj_2_48(3)) {
            t = this.jj_consume_token(15);
        } else if (this.jj_2_49(3)) {
            t = this.jj_consume_token(5);
        } else if (this.jj_2_50(3)) {
            t = this.jj_consume_token(8);
        } else if (this.jj_2_51(3)) {
            t = this.jj_consume_token(9);
        } else if (this.jj_2_52(3)) {
            t = this.jj_consume_token(1);
        } else if (this.jj_2_53(3)) {
            t = this.jj_consume_token(14);
        } else if (this.jj_2_54(3)) {
            t = this.jj_consume_token(3);
        } else if (this.jj_2_55(3)) {
            t = this.jj_consume_token(7);
        } else if (this.jj_2_56(3)) {
            t = this.jj_consume_token(6);
        } else if (this.jj_2_57(3)) {
            t = this.jj_consume_token(4);
        } else if (this.jj_2_58(3)) {
            t = this.jj_consume_token(10);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return t.toString();
    }

    public final String word() throws ParseException {
        Token t;
        if (this.jj_2_59(3)) {
            t = this.jj_consume_token(2);
        } else if (this.jj_2_60(3)) {
            t = this.jj_consume_token(15);
        } else if (this.jj_2_61(3)) {
            t = this.jj_consume_token(5);
        } else if (this.jj_2_62(3)) {
            t = this.jj_consume_token(8);
        } else if (this.jj_2_63(3)) {
            t = this.jj_consume_token(9);
        } else if (this.jj_2_64(3)) {
            t = this.jj_consume_token(1);
        } else if (this.jj_2_65(3)) {
            t = this.jj_consume_token(14);
        } else if (this.jj_2_66(3)) {
            t = this.jj_consume_token(3);
        } else if (this.jj_2_67(3)) {
            t = this.jj_consume_token(7);
        } else if (this.jj_2_68(3)) {
            t = this.jj_consume_token(6);
        } else if (this.jj_2_69(3)) {
            t = this.jj_consume_token(4);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return t.toString();
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_5();
        this.jj_save(4, xla);
        return retval;
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_6();
        this.jj_save(5, xla);
        return retval;
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_7();
        this.jj_save(6, xla);
        return retval;
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_8();
        this.jj_save(7, xla);
        return retval;
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_9();
        this.jj_save(8, xla);
        return retval;
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_10();
        this.jj_save(9, xla);
        return retval;
    }

    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_11();
        this.jj_save(10, xla);
        return retval;
    }

    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_12();
        this.jj_save(11, xla);
        return retval;
    }

    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_13();
        this.jj_save(12, xla);
        return retval;
    }

    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_14();
        this.jj_save(13, xla);
        return retval;
    }

    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_15();
        this.jj_save(14, xla);
        return retval;
    }

    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_16();
        this.jj_save(15, xla);
        return retval;
    }

    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_17();
        this.jj_save(16, xla);
        return retval;
    }

    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_18();
        this.jj_save(17, xla);
        return retval;
    }

    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_19();
        this.jj_save(18, xla);
        return retval;
    }

    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_20();
        this.jj_save(19, xla);
        return retval;
    }

    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_21();
        this.jj_save(20, xla);
        return retval;
    }

    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_22();
        this.jj_save(21, xla);
        return retval;
    }

    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_23();
        this.jj_save(22, xla);
        return retval;
    }

    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_24();
        this.jj_save(23, xla);
        return retval;
    }

    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_25();
        this.jj_save(24, xla);
        return retval;
    }

    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_26();
        this.jj_save(25, xla);
        return retval;
    }

    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_27();
        this.jj_save(26, xla);
        return retval;
    }

    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_28();
        this.jj_save(27, xla);
        return retval;
    }

    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_29();
        this.jj_save(28, xla);
        return retval;
    }

    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_30();
        this.jj_save(29, xla);
        return retval;
    }

    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_31();
        this.jj_save(30, xla);
        return retval;
    }

    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_32();
        this.jj_save(31, xla);
        return retval;
    }

    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_33();
        this.jj_save(32, xla);
        return retval;
    }

    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_34();
        this.jj_save(33, xla);
        return retval;
    }

    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_35();
        this.jj_save(34, xla);
        return retval;
    }

    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_36();
        this.jj_save(35, xla);
        return retval;
    }

    private final boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_37();
        this.jj_save(36, xla);
        return retval;
    }

    private final boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_38();
        this.jj_save(37, xla);
        return retval;
    }

    private final boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_39();
        this.jj_save(38, xla);
        return retval;
    }

    private final boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_40();
        this.jj_save(39, xla);
        return retval;
    }

    private final boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_41();
        this.jj_save(40, xla);
        return retval;
    }

    private final boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_42();
        this.jj_save(41, xla);
        return retval;
    }

    private final boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_43();
        this.jj_save(42, xla);
        return retval;
    }

    private final boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_44();
        this.jj_save(43, xla);
        return retval;
    }

    private final boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_45();
        this.jj_save(44, xla);
        return retval;
    }

    private final boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_46();
        this.jj_save(45, xla);
        return retval;
    }

    private final boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_47();
        this.jj_save(46, xla);
        return retval;
    }

    private final boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_48();
        this.jj_save(47, xla);
        return retval;
    }

    private final boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_49();
        this.jj_save(48, xla);
        return retval;
    }

    private final boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_50();
        this.jj_save(49, xla);
        return retval;
    }

    private final boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_51();
        this.jj_save(50, xla);
        return retval;
    }

    private final boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_52();
        this.jj_save(51, xla);
        return retval;
    }

    private final boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_53();
        this.jj_save(52, xla);
        return retval;
    }

    private final boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_54();
        this.jj_save(53, xla);
        return retval;
    }

    private final boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_55();
        this.jj_save(54, xla);
        return retval;
    }

    private final boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_56();
        this.jj_save(55, xla);
        return retval;
    }

    private final boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_57();
        this.jj_save(56, xla);
        return retval;
    }

    private final boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_58();
        this.jj_save(57, xla);
        return retval;
    }

    private final boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_59();
        this.jj_save(58, xla);
        return retval;
    }

    private final boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_60();
        this.jj_save(59, xla);
        return retval;
    }

    private final boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_61();
        this.jj_save(60, xla);
        return retval;
    }

    private final boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_62();
        this.jj_save(61, xla);
        return retval;
    }

    private final boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_63();
        this.jj_save(62, xla);
        return retval;
    }

    private final boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_64();
        this.jj_save(63, xla);
        return retval;
    }

    private final boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_65();
        this.jj_save(64, xla);
        return retval;
    }

    private final boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_66();
        this.jj_save(65, xla);
        return retval;
    }

    private final boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_67();
        this.jj_save(66, xla);
        return retval;
    }

    private final boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_68();
        this.jj_save(67, xla);
        return retval;
    }

    private final boolean jj_2_69(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_69();
        this.jj_save(68, xla);
        return retval;
    }

    private final boolean jj_3_32() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_32()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_33()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_21() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_34() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_27() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_11()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_18() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_57() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(0)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_31() {
        Token xsp;
        block16: {
            if (this.jj_scan_token(8)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            xsp = this.jj_scanpos;
            if (this.jj_3_26()) {
                this.jj_scanpos = xsp;
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(15)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_27()) break block16;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_13() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_17() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_68() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_30() {
        Token xsp;
        block16: {
            if (this.jj_scan_token(11)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            xsp = this.jj_scanpos;
            if (this.jj_3_22()) {
                this.jj_scanpos = xsp;
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(15)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_23()) break block16;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_23() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_11()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_11() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_56() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_16() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_8() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_31()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_67() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_20() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_11()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_55() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_12() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_66() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_19() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_11()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_7() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_20()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_54() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_15() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_65() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_9() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_15()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_14() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_53() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_64() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_7()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_4()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_5()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_6()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_7()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_8()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_52() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_63() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_51() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_62() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_50() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_61() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_49() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_60() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_48() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_59() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_60()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_61()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_62()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_63()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_64()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_65()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_66()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_67()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_68()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_69()) {
                                                    return true;
                                                }
                                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_47() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_48()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_49()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_50()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_51()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_52()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_53()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_54()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_55()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_56()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_57()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3_58()) {
                                                        return true;
                                                    }
                                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_45()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_46()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_45() {
        if (this.jj_3R_15()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_13() {
        Token xsp;
        block1: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_44()) break block1;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_46() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_43()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_42() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_12() {
        Token xsp;
        block1: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_41()) break block1;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_43() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_29() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_37() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_40() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_39() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_39()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_40()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_38() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_28() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_25() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_36() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_36()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_37()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_24() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_58() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_26() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_69() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_33() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_22() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public BibtexParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new BibtexParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public BibtexParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new BibtexParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public BibtexParser(BibtexParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(BibtexParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[17];
        int i = 0;
        while (i < 17) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 0) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 17) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, BibtexParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 69) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                        break;
                    }
                    case 13: {
                        this.jj_3_14();
                        break;
                    }
                    case 14: {
                        this.jj_3_15();
                        break;
                    }
                    case 15: {
                        this.jj_3_16();
                        break;
                    }
                    case 16: {
                        this.jj_3_17();
                        break;
                    }
                    case 17: {
                        this.jj_3_18();
                        break;
                    }
                    case 18: {
                        this.jj_3_19();
                        break;
                    }
                    case 19: {
                        this.jj_3_20();
                        break;
                    }
                    case 20: {
                        this.jj_3_21();
                        break;
                    }
                    case 21: {
                        this.jj_3_22();
                        break;
                    }
                    case 22: {
                        this.jj_3_23();
                        break;
                    }
                    case 23: {
                        this.jj_3_24();
                        break;
                    }
                    case 24: {
                        this.jj_3_25();
                        break;
                    }
                    case 25: {
                        this.jj_3_26();
                        break;
                    }
                    case 26: {
                        this.jj_3_27();
                        break;
                    }
                    case 27: {
                        this.jj_3_28();
                        break;
                    }
                    case 28: {
                        this.jj_3_29();
                        break;
                    }
                    case 29: {
                        this.jj_3_30();
                        break;
                    }
                    case 30: {
                        this.jj_3_31();
                        break;
                    }
                    case 31: {
                        this.jj_3_32();
                        break;
                    }
                    case 32: {
                        this.jj_3_33();
                        break;
                    }
                    case 33: {
                        this.jj_3_34();
                        break;
                    }
                    case 34: {
                        this.jj_3_35();
                        break;
                    }
                    case 35: {
                        this.jj_3_36();
                        break;
                    }
                    case 36: {
                        this.jj_3_37();
                        break;
                    }
                    case 37: {
                        this.jj_3_38();
                        break;
                    }
                    case 38: {
                        this.jj_3_39();
                        break;
                    }
                    case 39: {
                        this.jj_3_40();
                        break;
                    }
                    case 40: {
                        this.jj_3_41();
                        break;
                    }
                    case 41: {
                        this.jj_3_42();
                        break;
                    }
                    case 42: {
                        this.jj_3_43();
                        break;
                    }
                    case 43: {
                        this.jj_3_44();
                        break;
                    }
                    case 44: {
                        this.jj_3_45();
                        break;
                    }
                    case 45: {
                        this.jj_3_46();
                        break;
                    }
                    case 46: {
                        this.jj_3_47();
                        break;
                    }
                    case 47: {
                        this.jj_3_48();
                        break;
                    }
                    case 48: {
                        this.jj_3_49();
                        break;
                    }
                    case 49: {
                        this.jj_3_50();
                        break;
                    }
                    case 50: {
                        this.jj_3_51();
                        break;
                    }
                    case 51: {
                        this.jj_3_52();
                        break;
                    }
                    case 52: {
                        this.jj_3_53();
                        break;
                    }
                    case 53: {
                        this.jj_3_54();
                        break;
                    }
                    case 54: {
                        this.jj_3_55();
                        break;
                    }
                    case 55: {
                        this.jj_3_56();
                        break;
                    }
                    case 56: {
                        this.jj_3_57();
                        break;
                    }
                    case 57: {
                        this.jj_3_58();
                        break;
                    }
                    case 58: {
                        this.jj_3_59();
                        break;
                    }
                    case 59: {
                        this.jj_3_60();
                        break;
                    }
                    case 60: {
                        this.jj_3_61();
                        break;
                    }
                    case 61: {
                        this.jj_3_62();
                        break;
                    }
                    case 62: {
                        this.jj_3_63();
                        break;
                    }
                    case 63: {
                        this.jj_3_64();
                        break;
                    }
                    case 64: {
                        this.jj_3_65();
                        break;
                    }
                    case 65: {
                        this.jj_3_66();
                        break;
                    }
                    case 66: {
                        this.jj_3_67();
                        break;
                    }
                    case 67: {
                        this.jj_3_68();
                        break;
                    }
                    case 68: {
                        this.jj_3_69();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

