/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf.converters;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.rdf.DAMLListIterator;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.rdf.converters.BibtexParser;
import edu.mit.lcs.haystack.rdf.converters.ParseException;
import edu.mit.lcs.haystack.rdf.converters.TextParser;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class Bibtex
extends TextParser {
    private static final String PUB = "http://haystack.lcs.mit.edu/schemata/publication#";
    private static final String OZONE = "http://haystack.lcs.mit.edu/schemata/ozone#";
    public static final Resource PUBLICATION = new Resource("http://haystack.lcs.mit.edu/schemata/publication#", "Publication");
    private static final Resource CLASS = Constants.s_rdf_type;
    private static final Resource ID = new Resource("http://haystack.lcs.mit.edu/schemata/publication#id");
    private static final Resource FIRST = new Resource("http://haystack.lcs.mit.edu/schemata/vcard#", "givenName");
    private static final Resource LAST = new Resource("http://haystack.lcs.mit.edu/schemata/vcard#", "familyName");
    private static final Resource SUFFIX = new Resource("http://haystack.lcs.mit.edu/schemata/vcard#", "suffix");
    private String uriPrefix;
    private IRDFContainer rdf;
    private static Pattern andPattern = Pattern.compile("\\s+and\\s+");
    private static Pattern commaPattern = Pattern.compile(",");
    private static Pattern wsPattern = Pattern.compile("\\s");
    private Map IDMap = new HashMap();
    private static final Statement[] statements2 = new Statement[1];

    public static void main(String[] args) throws Exception {
        TextParser.parseFile(args, new Bibtex());
    }

    public static Resource importRDF(Reader in, IRDFContainer rdf) throws RDFException, IOException {
        Bibtex bibtex = new Bibtex();
        return bibtex.parse(in, rdf);
    }

    public Resource internalParse(Reader in, IRDFContainer rdfcontainer) {
        try {
            this.rdf = rdfcontainer;
            this.uriPrefix = this.parseURL == null ? Utilities.generateUnknownResource().toString() : this.parseURL.toString();
            Resource collection = Resource.createUnique(this.rdf, Constants.s_haystack_Collection);
            this.rdf.add(new Statement(collection, Constants.s_haystack_view, Resource.createUnique(this.rdf, new Resource(OZONE, "CollectionView"))));
            BibtexParser parser = new BibtexParser(in);
            parser.parse();
            Iterator records = parser.getRecords().values().iterator();
            while (records.hasNext()) {
                Map r = (Map)records.next();
                Object id = r.get("id");
                Resource record = this.newPublication(id);
                this.rdf.add(new Statement(collection, Constants.s_haystack_member, record));
                Iterator predicates = r.keySet().iterator();
                while (predicates.hasNext()) {
                    RDFNode value;
                    Resource predicate;
                    String p = (String)predicates.next();
                    String v = (String)r.get(p);
                    if (p.equals(CLASS.getContent())) {
                        predicate = CLASS;
                        value = new Resource(PUB + v.substring(0, 1).toUpperCase() + v.substring(1));
                    } else if (p.equals("author")) {
                        predicate = new Resource(PUB + p);
                        List names = this.parseNames(v, id);
                        value = ListUtilities.createDAMLList(names.iterator(), this.rdf);
                        Iterator i = names.iterator();
                        while (i.hasNext()) {
                            this.rdf.add(new Statement(record, Constants.s_dc_creator, (Resource)i.next()));
                        }
                    } else if (p.equals("title")) {
                        predicate = Constants.s_dc_title;
                        value = new Literal(r.get(p).toString());
                    } else {
                        predicate = new Resource(PUB + p);
                        value = new Literal(r.get(p).toString());
                    }
                    this.rdf.add(new Statement(record, predicate, value));
                }
            }
            return collection;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        catch (RDFException e) {
            return null;
        }
    }

    public static void exportRDF(IRDFContainer rdf, Resource pub, Writer out) {
        try {
            String type = rdf.extract(pub, CLASS, null).getContent();
            String id = rdf.extract(pub, ID, null).getContent();
            out.write("@" + Utilities.guessName(type).toLowerCase() + "(" + id + ",\n");
            Iterator props = Bibtex.getProperties(pub, rdf).iterator();
            while (props.hasNext()) {
                RDFNode[] pair = (RDFNode[])props.next();
                String prop = pair[0].getContent();
                String val = pair[1].getContent();
                if (!PUB.equals(Utilities.guessNamespace(prop)) || (prop = Utilities.guessName(prop)).equals("id")) continue;
                if (prop.equals("author")) {
                    val = Bibtex.exportNames((Resource)pair[1], rdf);
                }
                out.write("\t" + prop + " = " + val);
                out.write(props.hasNext() ? ",\n" : "\n");
            }
            out.write(")\n\n");
        }
        catch (IOException e) {
            System.out.println("Bummer!");
        }
        catch (RDFException e) {
            System.out.println("Bummer!");
        }
    }

    private static String exportNames(Resource nameslist, IRDFContainer rdf) {
        DAMLListIterator iter = ListUtilities.accessDAMLList(nameslist, rdf);
        StringBuffer sb = new StringBuffer("{");
        while (iter.hasNext()) {
            Resource person = (Resource)iter.next();
            sb.append("{");
            sb.append(Utilities.getLiteralProperty(person, LAST, rdf));
            sb.append(", ");
            sb.append(Utilities.getLiteralProperty(person, FIRST, rdf));
            sb.append(iter.hasNext() ? "} and " : "}");
        }
        sb.append("}");
        return sb.toString();
    }

    private List parseNames(String namestr, Object id) throws RDFException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        namestr = Bibtex.clean(namestr);
        namestr = namestr.substring(1, namestr.length() - 1);
        this.IDMap.clear();
        Iterator authors = Bibtex.split(namestr, andPattern, " and ").iterator();
        while (authors.hasNext()) {
            String first = null;
            String last = null;
            String suffix = null;
            String title = "";
            List names = Bibtex.split((String)authors.next(), commaPattern, ",");
            if (names.size() == 3) {
                first = ((String)names.get(2)).trim();
                last = ((String)names.get(0)).trim();
                suffix = ((String)names.get(1)).trim();
            } else if (names.size() == 2) {
                last = ((String)names.get(0)).trim();
                first = ((String)names.get(1)).trim();
            } else {
                List tokens = Bibtex.split((String)names.get(0), wsPattern, " ");
                int i = tokens.size() - 2;
                first = "";
                last = (String)tokens.get(i + 1);
                boolean done = false;
                while (i >= 0) {
                    String s = (String)tokens.get(i--);
                    if (!done && Character.isLowerCase(s.charAt(0))) {
                        last = String.valueOf(s) + ' ' + last;
                        continue;
                    }
                    first = String.valueOf(s) + ' ' + first;
                    done = true;
                }
                last = last.trim();
                first = first.equals("") ? null : first.trim();
            }
            Resource person = null;
            if (last == null) {
                person = this.newAuthor(id, Utilities.generateUniqueIdentifier());
            } else if (!this.IDMap.containsKey(last)) {
                person = this.newAuthor(id, last);
                this.IDMap.put(last, last);
            } else {
                int index = 0;
                Object val = this.IDMap.get(last);
                if (!val.equals(last)) {
                    index = (Integer)val;
                }
                person = this.newAuthor(id, String.valueOf(last) + ++index);
                this.IDMap.put(last, new Integer(index));
            }
            if (first != null) {
                this.rdf.add(new Statement(person, FIRST, new Literal(first)));
                title = String.valueOf(title) + first;
            }
            if (last != null) {
                this.rdf.add(new Statement(person, LAST, new Literal(last)));
                title = String.valueOf(title) + " " + last;
            }
            if (suffix != null) {
                this.rdf.add(new Statement(person, SUFFIX, new Literal(suffix)));
                title = String.valueOf(title) + " " + suffix;
            }
            this.rdf.add(new Statement(person, Constants.s_dc_title, new Literal(title)));
            result.add(person);
        }
        return result;
    }

    public static String clean(String value) {
        value = value.trim();
        boolean state = false;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            boolean ws = Character.isWhitespace(c);
            if (!ws) {
                sb.append(c);
                state = false;
            } else if (!state) {
                sb.append(' ');
                state = true;
            }
            ++i;
        }
        return sb.toString();
    }

    private static List split(String value, Pattern pattern, String replace) {
        String[] splits = pattern.split(value);
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < splits.length) {
            String candidate = splits[i];
            while (!Bibtex.balanced(candidate) && i < splits.length - 1) {
                candidate = String.valueOf(candidate) + replace + splits[++i];
            }
            results.add(candidate);
            ++i;
        }
        return results;
    }

    private static boolean balanced(String value) {
        int depth = 0;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '{') {
                ++depth;
            } else if (c == '}') {
                --depth;
            }
            if (depth < 0) {
                return false;
            }
            ++i;
        }
        return depth == 0;
    }

    private Resource newPublication(Object id) throws RDFException {
        Resource res = new Resource(String.valueOf(this.uriPrefix) + '#' + Utilities.toURI(id.toString()));
        this.rdf.add(new Statement(res, Constants.s_rdf_type, PUBLICATION));
        return res;
    }

    private Resource newAuthor(Object pub, Object id) throws RDFException {
        Resource res = new Resource(String.valueOf(this.uriPrefix) + '#' + Utilities.toURI(String.valueOf(pub.toString()) + ',' + id.toString()));
        this.rdf.add(new Statement(res, Constants.s_rdf_type, Constants.s_haystack_Person));
        return res;
    }

    private static List getProperties(Resource subj, IRDFContainer rdf) throws RDFException {
        Resource[] xyvals = Utilities.xyvals;
        Bibtex.statements2[0] = new Statement(subj, Utilities.x, Utilities.y);
        Iterator qresults = rdf.query(statements2, xyvals, xyvals).iterator();
        ArrayList results = new ArrayList();
        while (qresults.hasNext()) {
            results.add(qresults.next());
        }
        return results;
    }
}

