/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.StatementHandlerImpl;
import edu.mit.lcs.haystack.rdf.n3.IN3Engine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class Utilities {
    static Logger s_logger;
    private static Random r;
    private static final Resource[] wildcards;
    public static final Resource[] xvals;
    public static final Resource[] xyvals;
    public static final Resource x;
    public static final Resource y;
    static final SimpleDateFormat s_standardDateTimeFormatter;
    static final SimpleDateFormat s_standardDateFormatter;
    static final SimpleDateFormat s_standardTimeFormatter;
    public static final TimeZone s_timeZone;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.rdf.Utilities;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
        r = new Random();
        wildcards = new Resource[100];
        int i = 0;
        while (i < 100) {
            Utilities.wildcards[i] = new Resource("urn:haystack:wildcard:" + i);
            ++i;
        }
        xvals = Utilities.generateWildcardResourceArray(1);
        xyvals = Utilities.generateWildcardResourceArray(2);
        x = xyvals[0];
        y = xyvals[1];
        s_standardDateTimeFormatter = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
        s_standardDateFormatter = new SimpleDateFormat("EEE MMM d yyyy");
        s_standardTimeFormatter = new SimpleDateFormat("HH:mm:ss");
        s_standardDateTimeFormatter.setLenient(true);
        s_standardDateFormatter.setLenient(true);
        s_standardTimeFormatter.setLenient(true);
        s_timeZone = TimeZone.getDefault();
    }

    public static String generateUniqueIdentifier() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 15) {
            int n = r.nextInt();
            n = n < 0 ? -n : n;
            sb.append("1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(n % 62));
            ++i;
        }
        return sb.toString();
    }

    public static Resource generateUniqueResource() {
        return new Resource("urn:" + Utilities.generateUniqueIdentifier());
    }

    public static Resource generateUnknownResource() {
        return new Resource("urn:unknown:" + Utilities.generateUniqueIdentifier());
    }

    public static Resource generateWildcardResource(int i) {
        return wildcards[i];
    }

    public static Resource[] generateWildcardResourceArray(int c) {
        Resource[] a = new Resource[c];
        System.arraycopy(wildcards, 1, a, 0, c);
        return a;
    }

    public static Literal encodeResourceList(List l) {
        Iterator i = l.iterator();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            sb.append(res.getURI());
            sb.append("\n");
        }
        return new Literal(sb.toString());
    }

    public static List decodeResourceList(String s) {
        BufferedReader br = new BufferedReader(new StringReader(s));
        ArrayList<Resource> l = new ArrayList<Resource>();
        try {
            String s0;
            while ((s0 = br.readLine()) != null) {
                if ((s0 = s0.trim()).length() <= 0) continue;
                l.add(new Resource(s0));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    public static void shred(Resource a, IRDFContainer rdf) throws RDFException {
        rdf.remove(new Statement(a, x, y), xyvals);
        rdf.remove(new Statement(x, a, y), xyvals);
        rdf.remove(new Statement(x, y, a), xyvals);
    }

    public static void removeStatements(IRDFContainer target, IRDFContainer statements) throws RDFException {
        Iterator i = statements.iterator();
        while (i.hasNext()) {
            Statement s = (Statement)i.next();
            target.remove(s, new Resource[0]);
        }
    }

    public static Resource[] combineResourceArrays(Resource[] r1, Resource[] r2) {
        HashSet<Resource> s = new HashSet<Resource>();
        int i = 0;
        while (i < r1.length) {
            s.add(r1[i]);
            ++i;
        }
        i = 0;
        while (i < r2.length) {
            s.add(r2[i]);
            ++i;
        }
        Resource[] r3 = new Resource[s.size()];
        s.toArray(r3);
        return r3;
    }

    public static boolean containsResource(Resource[] pool, RDFNode rdfn) {
        if (!(rdfn instanceof Resource)) {
            return false;
        }
        Resource res = (Resource)rdfn;
        int i = 0;
        while (i < pool.length) {
            Resource r2 = pool[i];
            if (r2 == null ? res == null : r2.equals(res)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsRDFNode(RDFNode[] pool, RDFNode rdfn) {
        int i = 0;
        while (i < pool.length) {
            RDFNode r2 = pool[i];
            if (r2 == null ? rdfn == null : r2.equals(rdfn)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int indexOfResource(Resource[] pool, RDFNode rdfn) {
        if (!(rdfn instanceof Resource)) {
            return -1;
        }
        Resource res = (Resource)rdfn;
        int i = 0;
        while (i < pool.length) {
            Resource r2 = pool[i];
            if (r2 == null ? res == null : r2.equals(res)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String xmlEncode(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\'': {
                    str.append("&apos;");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public static String xmlDecode(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch != '&') {
                str.append(ch);
            } else {
                int j;
                int lenLeft = len - i;
                if (lenLeft > 10) {
                    lenLeft = 10;
                }
                String str2 = s.substring(i + 1, i + lenLeft);
                int toSkip = 0;
                if (str2.startsWith("lt;")) {
                    toSkip = 3;
                    str.append('<');
                } else if (str2.startsWith("gt;")) {
                    toSkip = 3;
                    str.append('>');
                } else if (str2.startsWith("amp;")) {
                    toSkip = 4;
                    str.append('&');
                } else if (str2.startsWith("quot;")) {
                    toSkip = 5;
                    str.append('\"');
                } else if (str2.startsWith("apos;")) {
                    toSkip = 5;
                    str.append('\'');
                } else if (str2.startsWith("#") && (j = str2.indexOf(59)) != -1) {
                    try {
                        char ch2 = (char)Integer.parseInt(str2.substring(1, j));
                        str.append(ch2);
                        toSkip = j + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (toSkip > 0) {
                    i += toSkip;
                } else {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public static void uninstallPackage(Resource res, IRDFContainer source) throws RDFException {
        Resource[] a = Utilities.getResourceProperties(res, Constants.s_haystack_packageStatement, source);
        int i = 0;
        while (i < a.length) {
            Statement s = source.getStatement(a[i]);
            if (s != null) {
                source.remove(s, new Resource[0]);
                source.remove(new Statement(res, Constants.s_haystack_packageStatement, a[i]), new Resource[0]);
            }
            ++i;
        }
        source.remove(new Statement(res, Constants.s_rdf_type, Constants.s_haystack_Package), new Resource[0]);
    }

    public static Class loadClass(Resource res, IRDFContainer source) throws Exception {
        if (res == null) {
            System.err.println("loadClass called with null");
            return null;
        }
        Resource resClass = Utilities.getResourceProperty(res, Constants.s_haystack_javaImplementation, source);
        if (resClass == null) {
            System.err.println("loadClass found no javaImplementation for " + res);
            return null;
        }
        String className = Utilities.getLiteralProperty(resClass, Constants.s_haystack_className, source);
        return Class.forName(className);
    }

    public static String generateRDF(IRDFContainer cont) throws RDFException {
        try {
            StringWriter sw = new StringWriter();
            Utilities.generateRDF(cont, sw);
            return sw.getBuffer().toString();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static void generateRDF(IRDFContainer cont, Writer out) throws IOException, RDFException {
        try {
            OutputFormat of = new OutputFormat();
            of.setPreserveSpace(true);
            XMLSerializer xmls = new XMLSerializer(out, of);
            xmls.startDocument();
            xmls.startPrefixMapping("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            AttributesImpl ai = new AttributesImpl();
            xmls.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", "", (Attributes)ai);
            Iterator i = cont.iterator();
            while (i.hasNext()) {
                Statement s = (Statement)i.next();
                s.generateRDF(xmls);
            }
            xmls.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", "");
            xmls.endDocument();
        }
        catch (SAXException e) {
            throw new RDFException("Unknown XML format exception", e);
        }
    }

    public static boolean generateRDF(IRDFContainer cont, File outfile) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            Utilities.generateRDF(cont, out);
            ((Writer)out).flush();
            ((Writer)out).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String generateN3(IRDFContainer cont) throws RDFException {
        StringBuffer sb = new StringBuffer();
        Iterator i = cont.iterator();
        while (i.hasNext()) {
            Statement s = (Statement)i.next();
            sb.append(s.generateN3());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void generateN3(IRDFContainer cont, Writer w) throws RDFException, IOException {
        Iterator i = cont.iterator();
        while (i.hasNext()) {
            Statement s = (Statement)i.next();
            w.write(s.generateN3());
            w.write("\n");
        }
    }

    public static void generateAdenine(IRDFContainer cont, Writer w) throws RDFException, IOException {
        Iterator i = cont.iterator();
        w.write("add {\n");
        while (i.hasNext()) {
            Statement s = (Statement)i.next();
            w.write(s.generateAdenine());
            w.write("\n");
        }
        w.write("}\n");
    }

    public static void parseRDF(URL url, IRDFContainer sink) throws RDFException {
        try {
            ARP arp = new ARP();
            arp.setStatementHandler((StatementHandler)new StatementHandlerImpl(sink));
            InputStream is = url.openStream();
            arp.load(is, url.toExternalForm());
            is.close();
        }
        catch (IOException ioe) {
            throw new RDFException("I/O error.", ioe);
        }
        catch (SAXException saxe) {
            throw new RDFException("Malformed RDF.", saxe);
        }
    }

    public static void parseRDF(InputStream is, IRDFContainer sink) throws RDFException {
        try {
            ARP arp = new ARP();
            arp.setStatementHandler((StatementHandler)new StatementHandlerImpl(sink));
            arp.load(is);
            is.close();
        }
        catch (IOException ioe) {
            throw new RDFException("I/O error.", ioe);
        }
        catch (SAXException saxe) {
            throw new RDFException("Malformed RDF.", saxe);
        }
    }

    public static void parseRDF(String rdf, IRDFContainer sink) throws RDFException {
        try {
            ARP arp = new ARP();
            arp.setStatementHandler((StatementHandler)new StatementHandlerImpl(sink));
            arp.load((Reader)new StringReader(rdf));
        }
        catch (IOException ioe) {
            throw new RDFException("I/O error.", ioe);
        }
        catch (SAXException saxe) {
            throw new RDFException("Malformed RDF.", saxe);
        }
    }

    public static void parseN3(String n3, IRDFContainer sink) throws RDFException {
        try {
            IN3Engine n3e = (IN3Engine)Class.forName("edu.mit.lcs.haystack.jython.notation3$N3Engine").newInstance();
            ARP arp = new ARP();
            arp.setStatementHandler((StatementHandler)new StatementHandlerImpl(sink));
            String str = n3e.N3ToRDF(n3, "urn:" + Utilities.generateUniqueIdentifier());
            arp.load((Reader)new StringReader(str));
        }
        catch (IOException ioe) {
            throw new RDFException("I/O error.", ioe);
        }
        catch (SAXException saxe) {
            throw new RDFException("Malformed RDF.", saxe);
        }
        catch (Exception e) {
            throw new RDFException("Unknown error.", e);
        }
    }

    public static void parseN3(InputStream is, IRDFContainer sink) throws RDFException {
        try {
            String str;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuffer sb = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                sb.append(String.valueOf(str) + "\n");
            }
            Utilities.parseN3(sb.toString(), sink);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static RDFNode getIndirectProperty(Resource subject, Resource predicate, Resource predicate2, IRDFContainer container) {
        try {
            RDFNode[] rdfn = container.queryExtract(new Statement[]{new Statement(subject, predicate, Utilities.generateWildcardResource(1)), new Statement(Utilities.generateWildcardResource(1), predicate2, Utilities.generateWildcardResource(2))}, new Resource[]{Utilities.generateWildcardResource(2)}, new Resource[]{Utilities.generateWildcardResource(1)});
            if (rdfn != null) {
                return rdfn[0];
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static RDFNode getIndirectProperty(Resource subject, Resource predicate, Resource predicate2, Resource predicate3, IRDFContainer container) {
        try {
            RDFNode[] rdfn = container.queryExtract(new Statement[]{new Statement(subject, predicate, Utilities.generateWildcardResource(3)), new Statement(Utilities.generateWildcardResource(3), predicate2, Utilities.generateWildcardResource(2)), new Statement(Utilities.generateWildcardResource(2), predicate3, Utilities.generateWildcardResource(1))}, Utilities.generateWildcardResourceArray(1), Utilities.generateWildcardResourceArray(3));
            if (rdfn != null) {
                return rdfn[0];
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static Set getIndirectProperties(Resource subject, Resource predicate, Resource predicate2, IRDFContainer container) {
        try {
            Set s = container.query(new Statement[]{new Statement(subject, predicate, Utilities.generateWildcardResource(1)), new Statement(Utilities.generateWildcardResource(1), predicate2, Utilities.generateWildcardResource(2))}, new Resource[]{Utilities.generateWildcardResource(2)}, new Resource[]{Utilities.generateWildcardResource(1)});
            return Utilities.extractFirstItems(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Resource getResourcePropertyOfType(Resource subject, Resource predicate, Resource type, IRDFContainer container) {
        try {
            RDFNode[] rdfn = container.queryExtract(new Statement[]{new Statement(subject, predicate, Utilities.generateWildcardResource(1)), new Statement(Utilities.generateWildcardResource(1), Constants.s_rdf_type, type)}, new Resource[]{Utilities.generateWildcardResource(1)}, new Resource[]{Utilities.generateWildcardResource(1)});
            if (rdfn != null) {
                return (Resource)rdfn[0];
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String getLiteralProperty(Resource subject, Resource predicate, IRDFContainer container) {
        try {
            return ((Literal)container.extract(subject, predicate, null)).getContent();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean checkBooleanProperty(Resource subject, Resource predicate, IRDFContainer container) {
        return Utilities.checkBooleanProperty(subject, predicate, container, false);
    }

    public static boolean checkBooleanProperty(Resource subject, Resource predicate, IRDFContainer container, boolean defaultValue) {
        try {
            return "true".equals(((Literal)container.extract(subject, predicate, null)).getContent());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getLabel(Resource res, IRDFContainer container) {
        String str = Utilities.getLiteralProperty(res, Constants.s_rdfs_label, container);
        if (str != null) {
            return str;
        }
        str = Utilities.getLiteralProperty(res, Constants.s_dc_title, container);
        if (str != null) {
            return str;
        }
        return res.getURI();
    }

    public static RDFNode getProperty(Resource subject, Resource predicate, IRDFContainer container) {
        try {
            return container.extract(subject, predicate, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Resource getResourceProperty(Resource subject, Resource predicate, IRDFContainer container) {
        try {
            return (Resource)container.extract(subject, predicate, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Resource getResourceSubject(Resource predicate, Resource object, IRDFContainer container) {
        try {
            return (Resource)container.extract(null, predicate, object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Resource[] getResourceProperties(Resource subject, Resource predicate, IRDFContainer container) {
        try {
            Set results = container.query(new Statement[]{new Statement(subject, predicate, Utilities.generateWildcardResource(1))}, new Resource[]{Utilities.generateWildcardResource(1)}, new Resource[0]);
            Resource[] a = new Resource[results.size()];
            Iterator i = results.iterator();
            int j = 0;
            while (i.hasNext()) {
                try {
                    a[j++] = (Resource)((RDFNode[])i.next())[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return a;
        }
        catch (Exception e) {
            return new Resource[0];
        }
    }

    public static RDFNode[] getProperties(Resource subject, Resource predicate, IRDFContainer container) {
        try {
            Set results = container.query(new Statement[]{new Statement(subject, predicate, Utilities.generateWildcardResource(1))}, new Resource[]{Utilities.generateWildcardResource(1)}, new Resource[0]);
            RDFNode[] a = new RDFNode[results.size()];
            Iterator i = results.iterator();
            int j = 0;
            while (i.hasNext()) {
                a[j++] = ((RDFNode[])i.next())[0];
            }
            return a;
        }
        catch (Exception e) {
            return new RDFNode[0];
        }
    }

    public static Resource[] getResourceSubjects(Resource predicate, RDFNode object, IRDFContainer container) {
        try {
            Set results = container.query(new Statement[]{new Statement(Utilities.generateWildcardResource(1), predicate, object)}, new Resource[]{Utilities.generateWildcardResource(1)}, new Resource[0]);
            Resource[] a = new Resource[results.size()];
            Iterator i = results.iterator();
            int j = 0;
            while (i.hasNext()) {
                try {
                    a[j++] = (Resource)((RDFNode[])i.next())[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return a;
        }
        catch (Exception e) {
            return new Resource[0];
        }
    }

    public static boolean isType(Resource subject, Resource type, IRDFContainer container) {
        try {
            boolean b = container.contains(new Statement(subject, Constants.s_rdf_type, type));
            return b;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSubType(Resource subject, Resource type, IRDFContainer container) {
        try {
            boolean b = container.queryExtract(new Statement[]{new Statement(subject, Constants.s_rdf_type, Utilities.generateWildcardResource(1)), new Statement(Utilities.generateWildcardResource(1), Constants.s_rdfs_subClassOf, type)}, Utilities.generateWildcardResourceArray(1), Utilities.generateWildcardResourceArray(1)) != null;
            return b;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Set getObjects(IRDFContainer store, Resource type) throws RDFException {
        Statement s = new Statement(x, Constants.s_rdf_type, type);
        Iterator qresults = store.query(s, xvals).iterator();
        HashSet<Resource> results = new HashSet<Resource>();
        while (qresults.hasNext()) {
            results.add((Resource)((RDFNode[])qresults.next())[0]);
        }
        return results;
    }

    public static Set getProperties(Resource resource, IRDFContainer store) {
        try {
            Statement s = new Statement(resource, x, y);
            return store.query(s, xyvals);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Set getMembers(IRDFContainer store, Resource collection) throws RDFException {
        Statement[] s = new Statement[]{new Statement(collection, Constants.s_haystack_member, x)};
        Iterator qresults = store.query(s, xvals, xvals).iterator();
        HashSet<Resource> results = new HashSet<Resource>();
        while (qresults.hasNext()) {
            results.add((Resource)((RDFNode[])qresults.next())[0]);
        }
        return results;
    }

    public static Set getMembers(IRDFContainer store, Resource collection, Resource type) throws RDFException {
        Statement[] s = new Statement[]{new Statement(collection, Constants.s_haystack_member, x), new Statement(x, Constants.s_rdf_type, type)};
        Iterator qresults = store.query(s, xvals, xvals).iterator();
        HashSet<Resource> results = new HashSet<Resource>();
        while (qresults.hasNext()) {
            results.add((Resource)((RDFNode[])qresults.next())[0]);
        }
        return results;
    }

    public static String guessNamespace(String uri) {
        int l = Utilities.getNamespaceEnd(uri);
        return l > 1 ? uri.substring(0, l) : "";
    }

    public static String guessName(String uri) {
        return uri.substring(Utilities.getNamespaceEnd(uri));
    }

    static int getNamespaceEnd(String uri) {
        char c;
        int l = uri.length() - 1;
        while ((c = uri.charAt(l)) != '#' && c != ':' && c != '/' && --l >= 0) {
        }
        return ++l;
    }

    public static int getSize(IRDFContainer source) {
        Resource[] vars = new Resource[]{wildcards[0], wildcards[1], wildcards[2]};
        Statement query = new Statement(wildcards[0], wildcards[1], wildcards[2]);
        try {
            return source.query(new Statement[]{query}, vars, vars).size();
        }
        catch (RDFException e) {
            return -1;
        }
    }

    public static void printStatements(IRDFContainer source) {
        Resource[] vars = new Resource[]{wildcards[0], wildcards[1], wildcards[2]};
        Statement query = new Statement(wildcards[0], wildcards[1], wildcards[2]);
        try {
            Set results = source.query(new Statement[]{query}, vars, vars);
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                RDFNode[] vals = (RDFNode[])iter.next();
                System.out.println(new Statement((Resource)vals[0], (Resource)vals[1], vals[2]));
            }
        }
        catch (RDFException e) {
            System.out.println(e);
        }
    }

    public static void printData(Resource r, IRDFContainer source) {
        if (r == null) {
            System.err.println("Resource is null");
        } else {
            try {
                System.err.println("Resource " + r);
                Set set = source.query(new Statement(r, Utilities.generateWildcardResource(1), Utilities.generateWildcardResource(2)), Utilities.generateWildcardResourceArray(2));
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    RDFNode[] nodes = (RDFNode[])i.next();
                    System.err.println("         " + nodes[0] + " : " + nodes[1]);
                }
            }
            catch (RDFException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static Date parseDateTime(Literal l) {
        return Utilities.parseDateTime(l.getContent());
    }

    public static Date parseDate(Literal l) {
        return Utilities.parseDate(l.getContent());
    }

    public static Date parseTime(Literal l) {
        return Utilities.parseTime(l.getContent());
    }

    public static Date parseDateTime(String s) {
        try {
            return s_standardDateTimeFormatter.parse(s);
        }
        catch (ParseException e) {
            try {
                return DateFormat.getDateTimeInstance().parse(s);
            }
            catch (ParseException e2) {
                try {
                    return new Date(Date.parse(s));
                }
                catch (Exception e3) {
                    return null;
                }
            }
        }
    }

    public static Date parseTime(String s) {
        try {
            return s_standardTimeFormatter.parse(s);
        }
        catch (ParseException e) {
            try {
                return DateFormat.getTimeInstance().parse(s);
            }
            catch (ParseException e2) {
                return null;
            }
        }
    }

    public static Date parseDate(String s) {
        Date d;
        try {
            d = s_standardDateFormatter.parse(s);
        }
        catch (ParseException e) {
            try {
                d = DateFormat.getTimeInstance().parse(s);
            }
            catch (ParseException e2) {
                return null;
            }
        }
        Calendar c = Calendar.getInstance(s_timeZone);
        c.setTime(d);
        c.set(13, 0);
        c.set(14, 0);
        c.set(12, 0);
        c.set(11, 0);
        return c.getTime();
    }

    public static Literal generateDateTime(Date d) {
        return new Literal(s_standardDateTimeFormatter.format(d));
    }

    public static Literal generateDate(Date d) {
        return new Literal(s_standardDateFormatter.format(d));
    }

    public static Literal generateTime(Date d) {
        return new Literal(s_standardTimeFormatter.format(d));
    }

    public static String computeMD5(InputStream message) throws IOException {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((ch = message.read()) != -1) {
            out.write(ch);
        }
        out.close();
        return Utilities.computeMD5(out.toByteArray());
    }

    public static String computeMD5(String message) {
        try {
            return Utilities.computeMD5(message.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String computeMD5(byte[] message) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(message);
            byte[] digest = md5.digest();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < digest.length) {
                if ((0xFF & digest[i]) < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(0xFF & digest[i]));
                ++i;
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String toURI(String input) {
        try {
            byte[] bytes = input.getBytes("UTF8");
            StringBuffer sb = new StringBuffer(2 * input.length());
            int i = 0;
            while (i < bytes.length) {
                byte c = bytes[i];
                if (97 <= c && c <= 122 || 64 <= c && c <= 90 || 48 <= c && c <= 59 || 39 <= c && c <= 46 || c == 36 || c == 61 || c == 95 || c == 33) {
                    sb.append((char)c);
                } else {
                    sb.append((0xFF & bytes[i]) < 16 ? "%0" : "%");
                    sb.append(Integer.toHexString(0xFF & bytes[i]).toUpperCase());
                }
                ++i;
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String toLiteral(String input) {
        boolean good = true;
        int len = input.length();
        int i = 0;
        while (i < len) {
            char c = input.charAt(i);
            if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                good = false;
            }
            ++i;
        }
        if (good) {
            return input;
        }
        StringBuffer sb = new StringBuffer(len);
        int i2 = 0;
        while (i2 < len) {
            char c = input.charAt(i2);
            if (c >= ' ' || c == '\t' || c == '\n' || c == '\r') {
                sb.append(c);
            }
            ++i2;
        }
        return sb.toString();
    }

    public static Resource pathToURI(String path, IRDFContainer source) {
        if (path.length() >= 3 && path.charAt(1) == ':' && (path.charAt(2) == '\\' || path.charAt(2) == '/')) {
            String url = Utilities.getURLFromShortcutFile(path, source);
            if (url == null) {
                url = "file://localhost/" + path.replace('\\', '/');
            }
            Utilities.addTitle(url, path, source);
            return new Resource(url);
        }
        if (path.startsWith("\\\\")) {
            String url = Utilities.getURLFromShortcutFile(path, source);
            if (url == null) {
                url = "file:" + path.replace('\\', '/');
            }
            Utilities.addTitle(url, path, source);
            return new Resource(url);
        }
        return new Resource(path);
    }

    public static String getURLFromShortcutFile(String filePath, IRDFContainer source) {
        if (!filePath.endsWith(".url")) {
            return null;
        }
        String result = null;
        try {
            FileInputStream fis = new FileInputStream(filePath);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            try {
                String s;
                while (!(s = br.readLine()).startsWith("URL=")) {
                }
                result = s.substring(4);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            br.close();
            isr.close();
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != null) {
            Utilities.addTitle(result, filePath, source);
        }
        return result;
    }

    protected static void addTitle(String uri, String filePath, IRDFContainer source) {
        int start = filePath.lastIndexOf(92);
        start = start >= 0 ? start : filePath.lastIndexOf(47);
        start = start >= 0 ? start + 1 : 0;
        int end = filePath.lastIndexOf(46);
        end = end >= 0 ? end : filePath.length();
        String title = filePath.substring(start, end);
        try {
            if (source.extract(new Resource(uri), Constants.s_dc_title, null) == null) {
                source.add(new Statement(new Resource(uri), Constants.s_dc_title, new Literal(title)));
            }
        }
        catch (RDFException rDFException) {
            // empty catch block
        }
    }

    public static Set extractFirstItems(Set tuples) {
        HashSet<Object> results = new HashSet<Object>();
        Iterator i = tuples.iterator();
        while (i.hasNext()) {
            Object tuple = i.next();
            if (tuple instanceof Object[]) {
                if (((Object[])tuple).length <= 0) continue;
                results.add(((Object[])tuple)[0]);
                continue;
            }
            results.add(tuple);
        }
        return results;
    }

    public static Set makeSetUnique(Set inp) {
        HashSet<RDFNode[]> results = new HashSet<RDFNode[]>();
        Iterator inpIt = inp.iterator();
        while (inpIt.hasNext()) {
            RDFNode[] inpTuple = (RDFNode[])inpIt.next();
            boolean addTuple = true;
            Iterator resIt = results.iterator();
            block1: while (resIt.hasNext()) {
                RDFNode[] resTuple = (RDFNode[])resIt.next();
                int ndx = 0;
                while (ndx < resTuple.length) {
                    if (resTuple[ndx] != inpTuple[ndx]) continue block1;
                    if (ndx == resTuple.length - 1) {
                        addTuple = false;
                    }
                    ++ndx;
                }
            }
            if (!addTuple) continue;
            results.add(inpTuple);
        }
        return results;
    }

    public static HashMap getTypeHierarchy(Set types, IRDFContainer source) {
        HashMap<Resource, HashSet<Resource>> map = new HashMap<Resource, HashSet<Resource>>();
        HashSet<Resource> subTypes = new HashSet<Resource>();
        Iterator i = types.iterator();
        while (i.hasNext()) {
            Resource type = (Resource)i.next();
            Resource[] superTypes = Utilities.getResourceProperties(type, Constants.s_rdfs_subClassOf, source);
            int j = 0;
            while (j < superTypes.length) {
                if (types.contains(superTypes[j])) {
                    HashSet<Resource> currentSubtypes = (HashSet<Resource>)map.get(superTypes[j]);
                    if (currentSubtypes == null) {
                        currentSubtypes = new HashSet<Resource>();
                        map.put(superTypes[j], currentSubtypes);
                    }
                    currentSubtypes.add(type);
                    subTypes.add(type);
                }
                ++j;
            }
        }
        types.removeAll(subTypes);
        return map;
    }

    public static List getTypePriorityList(Resource[] types, IRDFContainer source) {
        Iterator<Resource> i;
        HashMap<Resource, List<Resource>> subTypesMemo = new HashMap<Resource, List<Resource>>();
        Collection<Resource> currentTypes = Arrays.asList(types);
        HashSet<Resource> baseTypes = new HashSet<Resource>();
        baseTypes.addAll(currentTypes);
        while (subTypesMemo.size() < 100 && currentTypes.size() > 0) {
            HashSet<Resource> newCurrentTypes = new HashSet<Resource>();
            i = currentTypes.iterator();
            while (i.hasNext()) {
                Resource type = i.next();
                if (subTypesMemo.containsKey(type)) {
                    if (!baseTypes.contains(type)) continue;
                    baseTypes.remove(type);
                    continue;
                }
                List<Resource> subTypes = Arrays.asList(Utilities.getResourceProperties(type, Constants.s_rdfs_subClassOf, source));
                subTypesMemo.put(type, subTypes);
                newCurrentTypes.addAll(subTypes);
            }
            currentTypes = newCurrentTypes;
        }
        LinkedList<Resource> results = new LinkedList<Resource>();
        currentTypes = baseTypes;
        while (currentTypes.size() > 0) {
            i = currentTypes.iterator();
            HashSet newCurrentTypes = new HashSet();
            while (i.hasNext()) {
                Resource type = i.next();
                Collection subTypes = (Collection)subTypesMemo.get(type);
                if (subTypes == null) continue;
                newCurrentTypes.addAll(subTypes);
            }
            results.addAll(currentTypes);
            currentTypes = newCurrentTypes;
        }
        if (!results.contains(Constants.s_daml_Thing)) {
            results.add(Constants.s_daml_Thing);
        }
        return results;
    }

    public static void copyBasicInformation(Resource subject, IRDFContainer source, IRDFContainer target) throws RDFException {
        RDFNode[] values = Utilities.getProperties(subject, Constants.s_dc_title, source);
        int i = 0;
        while (i < values.length) {
            target.add(new Statement(subject, Constants.s_dc_title, values[i]));
            ++i;
        }
        values = Utilities.getProperties(subject, Constants.s_rdf_type, source);
        i = 0;
        while (i < values.length) {
            target.add(new Statement(subject, Constants.s_rdf_type, values[i]));
            ++i;
        }
    }

    public static Set extractInformation(Resource subject, IRDFContainer source, IRDFContainer target) throws RDFException {
        HashSet endNodes = new HashSet();
        HashSet visitedNodes = new HashSet();
        Utilities.extractInformationHelper(subject, visitedNodes, endNodes, source, target);
        return endNodes;
    }

    static void extractInformationHelper(Resource subject, Set visitedNodes, Set endNodes, IRDFContainer source, IRDFContainer target) throws RDFException {
        if (visitedNodes.contains(subject)) {
            return;
        }
        visitedNodes.add(subject);
        Set results = source.query(new Statement(subject, Utilities.generateWildcardResource(1), Utilities.generateWildcardResource(2)), Utilities.generateWildcardResourceArray(2));
        Iterator i = results.iterator();
        while (i.hasNext()) {
            RDFNode[] datum = (RDFNode[])i.next();
            if (datum[1] instanceof Resource) {
                Resource obj = (Resource)datum[1];
                Resource pred = (Resource)datum[0];
                if (Utilities.isType(pred, Constants.s_haystack_ProprietalProperty, source) || Utilities.isType(pred, Constants.s_haystack_ContainmentProperty, source)) {
                    Utilities.extractInformationHelper(obj, visitedNodes, endNodes, source, target);
                }
                if (Utilities.isType(pred, Constants.s_haystack_RelationalProperty, source) && !visitedNodes.contains(obj)) {
                    endNodes.add(obj);
                }
            }
            target.add(new Statement(subject, (Resource)datum[0], datum[1]));
        }
    }
}

