/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;

class StatementHandlerImpl
implements StatementHandler {
    IRDFContainer sink;
    String m_unique = Utilities.generateUniqueIdentifier();

    StatementHandlerImpl(IRDFContainer sink) {
        if (sink == null) {
            throw new IllegalArgumentException();
        }
        this.sink = sink;
    }

    Resource translate(AResource res) {
        if (res.isAnonymous()) {
            return new Resource("urn:" + this.m_unique + ":" + res.getAnonymousID());
        }
        return new Resource(res.getURI());
    }

    public void statement(AResource subj, AResource pred, AResource obj) {
        try {
            this.sink.add(new Statement(this.translate(subj), this.translate(pred), this.translate(obj)));
        }
        catch (RDFException rDFException) {
            // empty catch block
        }
    }

    public void statement(AResource subj, AResource pred, ALiteral lit) {
        try {
            this.sink.add(new Statement(this.translate(subj), this.translate(pred), new Literal(Utilities.xmlDecode(lit.toString()))));
        }
        catch (RDFException rDFException) {
            // empty catch block
        }
    }
}

