/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class Statement
implements Serializable {
    protected Resource subject;
    protected Resource predicate;
    protected RDFNode object;
    static String byteChars = "0123456789abcdef";

    public Statement(Resource subject, Resource predicate, RDFNode object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public final Resource getSubject() {
        return this.subject;
    }

    public final Resource getPredicate() {
        return this.predicate;
    }

    public Resource getMD5HashResource() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(this.subject.getContent().length());
            dos.write(this.predicate.getContent().length());
            dos.write(this.object.getContent().length());
            dos.writeBoolean(this.object instanceof Literal);
            dos.writeChars(this.subject.getContent());
            dos.writeChars(this.predicate.getContent());
            dos.writeChars(this.object.getContent());
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(baos.toByteArray());
            StringBuffer sb = new StringBuffer("urn:statement:md5:");
            int i = 0;
            while (i < bytes.length) {
                int loNibble = bytes[i] & 0xF;
                int hiNibble = bytes[i] >> 4 & 0xF;
                sb.append(byteChars.charAt(hiNibble));
                sb.append(byteChars.charAt(loNibble));
                ++i;
            }
            return new Resource(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final RDFNode getObject() {
        return this.object;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Statement)) {
            return false;
        }
        Statement s = (Statement)o;
        return s.subject.equals(this.subject) && s.object.equals(this.object) && s.predicate.equals(this.predicate);
    }

    public int hashCode() {
        return this.subject.hashCode() + this.predicate.hashCode() + this.object.hashCode();
    }

    public final String generateN3() {
        return String.valueOf(this.subject.toString()) + " " + this.predicate.toString() + " " + this.object.toString() + " .";
    }

    public final String generateAdenine() {
        return String.valueOf(this.subject.toString()) + " " + this.predicate.toString() + " " + this.object.toString() + " ";
    }

    public String toString() {
        return this.generateN3();
    }

    public String generateRDF() {
        StringBuffer sb = new StringBuffer("<rdf:Description xmlns:rdf=\"");
        sb.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sb.append("\" rdf:about=\"");
        sb.append(this.subject.getURI());
        sb.append("\">\n\t<x:");
        String namespace = Utilities.guessNamespace(this.predicate.getURI());
        String name = Utilities.guessName(this.predicate.getURI());
        sb.append(name);
        sb.append(" xmlns:x=\"");
        sb.append(namespace);
        sb.append("\"");
        if (this.object instanceof Resource) {
            sb.append(" rdf:resource=\"");
            sb.append(this.object.getContent());
            sb.append("\" />");
        } else {
            sb.append(" rdf:parseType=\"Literal\">");
            sb.append(Utilities.xmlEncode(this.object.getContent()));
            sb.append("</x:");
            sb.append(name);
            sb.append(">");
        }
        sb.append("\n</rdf:Description>");
        return sb.toString();
    }

    public void generateRDF(XMLSerializer xmls) throws SAXException {
        AttributesImpl descAttribs = new AttributesImpl();
        descAttribs.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", "rdf:about", "string", this.subject.getURI());
        xmls.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description", "", (Attributes)descAttribs);
        String namespace = Utilities.guessNamespace(this.predicate.getURI());
        String name = Utilities.guessName(this.predicate.getURI());
        xmls.startPrefixMapping("x", namespace);
        AttributesImpl predAttribs = new AttributesImpl();
        if (this.object instanceof Resource) {
            predAttribs.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", "rdf:resource", "string", this.object.getContent());
        } else {
            predAttribs.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "rdf:parseType", "string", "Literal");
        }
        xmls.startElement(namespace, name, "", (Attributes)predAttribs);
        if (this.object instanceof Literal) {
            xmls.characters(this.object.getContent().toCharArray(), 0, this.object.getContent().length());
        }
        xmls.endElement(namespace, name, "");
        xmls.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description", "");
    }
}

