/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;

public class Resource
extends RDFNode {
    public Resource(String uri) {
        super(uri);
    }

    public Resource(String base, String suffix) {
        super(String.valueOf(base) + suffix);
    }

    public final String getURI() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.hashCode() != this.hashCode) {
            return false;
        }
        return o.getClass() == this.getClass() && ((Resource)o).getContent().equals(this.getContent());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append('<');
        sb.append(this.content);
        sb.append('>');
        return sb.toString();
    }

    public static Resource createUnique(IRDFContainer target, Resource type) throws RDFException {
        Resource res = Utilities.generateUniqueResource();
        target.add(new Statement(res, Constants.s_rdf_type, type));
        return res;
    }

    private static Resource createUnknown(IRDFContainer target, Resource type) throws RDFException {
        Resource res = Utilities.generateUnknownResource();
        target.add(new Statement(res, Constants.s_rdf_type, type));
        return res;
    }
}

