/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.LocalRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.Iterator;
import java.util.Set;

public class PackageFilterRDFContainer
implements IRDFContainer {
    IRDFContainer m_source;
    Resource m_resPackage;

    public PackageFilterRDFContainer(IRDFContainer source, Resource resPackage) {
        this.m_source = source;
        this.m_resPackage = resPackage;
        if (this.m_resPackage != null) {
            try {
                this.m_source.add(new Statement(this.m_resPackage, Constants.s_rdf_type, Constants.s_haystack_Package));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void changePackage(Resource resPackage) {
        this.m_resPackage = resPackage;
        try {
            this.m_source.add(new Statement(this.m_resPackage, Constants.s_rdf_type, Constants.s_haystack_Package));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void add(Statement s) throws RDFException {
        this.m_source.add(s);
        if (this.m_resPackage != null) {
            this.m_source.add(new Statement(this.m_resPackage, Constants.s_haystack_packageStatement, s.getMD5HashResource()));
        }
    }

    public void add(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        this.add(new Statement(subject, predicate, object));
    }

    public void add(IRDFContainer c) throws RDFException {
        this.m_source.add(c);
        if (this.m_resPackage == null) {
            return;
        }
        Iterator i = c.iterator();
        LocalRDFContainer rdfc = new LocalRDFContainer();
        while (i.hasNext()) {
            Statement s = (Statement)i.next();
            rdfc.add(new Statement(this.m_resPackage, Constants.s_haystack_packageStatement, s.getMD5HashResource()));
        }
        this.m_source.add(rdfc);
    }

    public void remove(Statement s, Resource[] existential) throws RDFException {
        this.m_source.remove(s, existential);
    }

    public Set query(Statement[] query, Resource[] variables, Resource[] existential) throws RDFException {
        return this.m_source.query(query, variables, existential);
    }

    public Set query(Statement s, Resource[] existential) throws RDFException {
        return this.m_source.query(s, existential);
    }

    public boolean contains(Statement s) throws RDFException {
        return this.m_source.contains(s);
    }

    public RDFNode extract(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        return this.m_source.extract(subject, predicate, object);
    }

    public Resource[] getAuthoredStatementIDs(Resource author) throws RDFException {
        return this.m_source.getAuthoredStatementIDs(author);
    }

    public Statement[] getAuthoredStatements(Resource author) throws RDFException {
        return this.m_source.getAuthoredStatements(author);
    }

    public Resource[] getAuthors(Resource id) throws RDFException {
        return this.m_source.getAuthors(id);
    }

    public Resource[] getAuthors(Statement s) throws RDFException {
        return this.m_source.getAuthors(s);
    }

    public Statement getStatement(Resource id) throws RDFException {
        return this.m_source.getStatement(id);
    }

    public Resource getStatementID(Statement s) throws RDFException {
        return this.m_source.getStatementID(s);
    }

    public Iterator iterator() throws RDFException {
        return this.m_source.iterator();
    }

    public int size() throws RDFException {
        return this.m_source.size();
    }

    public boolean supportsAuthoring() {
        return this.m_source.supportsAuthoring();
    }

    public boolean supportsEnumeration() {
        return this.m_source.supportsEnumeration();
    }

    public RDFNode[] queryExtract(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        return this.m_source.queryExtract(query, variables, existentials);
    }

    public Set queryMulti(Statement s, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        return this.m_source.queryMulti(s, existentials, hints);
    }

    public Set queryMulti(Statement[] query, Resource[] variables, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        return this.m_source.queryMulti(query, variables, existentials, hints);
    }

    public void replace(Resource subject, Resource predicate, RDFNode object, RDFNode newValue) throws RDFException {
        boolean nullObj;
        boolean nullPred;
        boolean nullSubj = subject == null;
        if ((nullSubj ? 1 : 0) + ((nullPred = predicate == null) ? 1 : 0) + ((nullObj = object == null) ? 1 : 0) != 1) {
            throw new RDFException("replace expects exactly one null parameter");
        }
        Resource wildcard = Utilities.generateWildcardResource(1);
        this.remove(new Statement(nullSubj ? wildcard : subject, nullPred ? wildcard : predicate, nullObj ? wildcard : object), new Resource[]{wildcard});
        this.add(new Statement(nullSubj ? (Resource)newValue : subject, nullPred ? (Resource)newValue : predicate, nullObj ? newValue : object));
    }

    public int querySize(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        return this.m_source.querySize(query, variables, existentials);
    }
}

