/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.ozone.Context;
import edu.mit.lcs.haystack.rdf.DAMLListIterator;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.IRDFEventSource;
import edu.mit.lcs.haystack.rdf.ListWatchRecord;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.NodeListener;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.URIGenerator;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.server.rdfstore.RDFListener;
import edu.mit.lcs.haystack.server.service.ServiceManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class ListUtilities {
    static Logger s_logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.rdf.ListUtilities;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public static DAMLListIterator accessDAMLList(Resource res, IRDFContainer source) {
        if (Utilities.isType(res, Constants.s_haystack_List, source)) {
            Resource damlList = Utilities.getResourceProperty(res, Constants.s_haystack_list, source);
            return new DAMLListIterator(damlList, source);
        }
        return new DAMLListIterator(res, source);
    }

    public static ArrayList retrieveDAMLList(Resource res, IRDFContainer source) {
        DAMLListIterator i = ListUtilities.accessDAMLList(res, source);
        ArrayList al = new ArrayList();
        while (i.hasNext()) {
            al.add(i.next());
        }
        return al;
    }

    public static Resource createHSList(Iterator i, IRDFContainer source) throws RDFException {
        return ListUtilities.createHSList(i, source, new URIGenerator());
    }

    public static Resource createHSList(Iterator i, IRDFContainer source, URIGenerator urig) throws RDFException {
        Resource damlList = ListUtilities.createDAMLList(i, source, urig);
        Resource hsList = urig.generateNewResource();
        source.add(new Statement(hsList, Constants.s_rdf_type, Constants.s_haystack_List));
        source.add(new Statement(hsList, Constants.s_haystack_list, damlList));
        return hsList;
    }

    public static Resource createDAMLList(Iterator i, IRDFContainer source) throws RDFException {
        return ListUtilities.createDAMLList(i, source, new URIGenerator());
    }

    public static Resource createDAMLList(Iterator i, IRDFContainer source, URIGenerator urig) throws RDFException {
        Resource resFirst;
        Resource resLast = null;
        Resource resNext = resFirst = urig.generateNewResource();
        while (i.hasNext()) {
            Object o = i.next();
            RDFNode res1 = o instanceof RDFNode ? (RDFNode)o : (o == null ? new Literal("null") : new Literal(o.toString()));
            source.add(new Statement(resNext, Constants.s_rdf_type, Constants.s_daml_List));
            source.add(new Statement(resNext, Constants.s_daml_first, res1));
            if (resLast != null) {
                source.add(new Statement(resLast, Constants.s_daml_rest, resNext));
            }
            resLast = resNext;
            resNext = urig.generateNewResource();
        }
        if (resLast == null) {
            return Constants.s_daml_nil;
        }
        source.add(new Statement(resLast, Constants.s_daml_rest, Constants.s_daml_nil));
        return resFirst;
    }

    public static boolean addToHSList(Resource list, RDFNode item, int index, IRDFContainer source) {
        Resource current = Utilities.getResourceProperty(list, Constants.s_haystack_list, source);
        Resource previous = list;
        int i = 0;
        while (i < index) {
            previous = current;
            if ((current = Utilities.getResourceProperty(current, Constants.s_daml_rest, source)) == null) {
                return false;
            }
            ++i;
        }
        return ListUtilities.addToHSListAt(previous, current, item, previous.equals(list), source);
    }

    public static boolean appendToHSList(Resource list, RDFNode item, IRDFContainer source) {
        Resource current = Utilities.getResourceProperty(list, Constants.s_haystack_list, source);
        Resource previous = list;
        while (!current.equals(Constants.s_daml_nil)) {
            previous = current;
            if ((current = Utilities.getResourceProperty(current, Constants.s_daml_rest, source)) != null) continue;
            return false;
        }
        return ListUtilities.addToHSListAt(previous, current, item, previous.equals(list), source);
    }

    public static boolean prependToHSList(Resource list, RDFNode item, IRDFContainer source) {
        return ListUtilities.addToHSList(list, item, 0, source);
    }

    public static boolean removeFromHSList(Resource list, RDFNode item, IRDFContainer source) {
        Resource current = Utilities.getResourceProperty(list, Constants.s_haystack_list, source);
        Resource previous = list;
        while (!current.equals(Constants.s_daml_nil) && !item.equals(Utilities.getProperty(current, Constants.s_daml_first, source))) {
            previous = current;
            if ((current = Utilities.getResourceProperty(current, Constants.s_daml_rest, source)) != null) continue;
            return false;
        }
        if (current.equals(Constants.s_daml_nil)) {
            return false;
        }
        return ListUtilities.removeFromHSListAt(previous, current, previous.equals(list), source);
    }

    public static boolean removeFromHSList(Resource list, int index, IRDFContainer source) {
        Resource current = Utilities.getResourceProperty(list, Constants.s_haystack_list, source);
        Resource previous = list;
        int i = 0;
        while (i < index && current != null && !current.equals(Constants.s_daml_nil)) {
            previous = current;
            current = Utilities.getResourceProperty(current, Constants.s_daml_rest, source);
            ++i;
        }
        if (current == null || current.equals(Constants.s_daml_nil)) {
            return false;
        }
        return ListUtilities.removeFromHSListAt(previous, current, previous.equals(list), source);
    }

    static boolean removeFromHSListAt(Resource previousNode, Resource nodeToRemove, boolean head, IRDFContainer source) {
        try {
            Resource nextNode = Utilities.getResourceProperty(nodeToRemove, Constants.s_daml_rest, source);
            source.replace(previousNode, head ? Constants.s_haystack_list : Constants.s_daml_rest, null, nextNode);
            ListUtilities.dismantleDAMLListNode(nodeToRemove, source);
            return true;
        }
        catch (RDFException e) {
            return false;
        }
    }

    static boolean addToHSListAt(Resource previousNode, Resource nextNode, RDFNode item, boolean head, IRDFContainer source) {
        try {
            Resource newNode = new URIGenerator().generateNewResource();
            source.add(new Statement(newNode, Constants.s_rdf_type, Constants.s_daml_List));
            source.add(new Statement(newNode, Constants.s_daml_first, item));
            source.add(new Statement(newNode, Constants.s_daml_rest, nextNode));
            source.replace(previousNode, head ? Constants.s_haystack_list : Constants.s_daml_rest, null, newNode);
            return true;
        }
        catch (RDFException e) {
            return false;
        }
    }

    public static boolean clearHSList(Resource list, IRDFContainer source) {
        try {
            Resource node = (Resource)source.extract(list, Constants.s_haystack_list, null);
            source.replace(list, Constants.s_haystack_list, null, Constants.s_daml_nil);
            while (node != null && !node.equals(Constants.s_daml_nil)) {
                Resource nextNode = (Resource)source.extract(node, Constants.s_daml_rest, null);
                ListUtilities.dismantleDAMLListNode(node, source);
                node = nextNode;
            }
            return true;
        }
        catch (RDFException e) {
            return false;
        }
    }

    public static boolean changeHSList(Resource list, RDFNode item, int index, IRDFContainer source) {
        Resource current = Utilities.getResourceProperty(list, Constants.s_haystack_list, source);
        int i = 0;
        while (i < index && current != null && !current.equals(Constants.s_daml_nil)) {
            current = Utilities.getResourceProperty(current, Constants.s_daml_rest, source);
            ++i;
        }
        if (current == null || current.equals(Constants.s_daml_nil)) {
            return false;
        }
        try {
            source.replace(current, Constants.s_daml_first, null, item);
            return true;
        }
        catch (RDFException e) {
            return false;
        }
    }

    public static boolean isInHSList(Resource list, RDFNode item, IRDFContainer source) {
        Resource current = Utilities.getResourceProperty(list, Constants.s_haystack_list, source);
        try {
            while (current != null && !current.equals(Constants.s_daml_nil)) {
                RDFNode first = source.extract(current, Constants.s_daml_first, null);
                if (item.equals(first)) {
                    return true;
                }
                current = (Resource)source.extract(current, Constants.s_daml_rest, null);
            }
        }
        catch (RDFException rDFException) {
            // empty catch block
        }
        return false;
    }

    static void dismantleDAMLListNode(Resource node, IRDFContainer source) throws RDFException {
        if (!node.equals(Constants.s_daml_nil)) {
            source.remove(new Statement(node, Constants.s_daml_first, Utilities.generateWildcardResource(1)), Utilities.generateWildcardResourceArray(1));
            source.remove(new Statement(node, Constants.s_daml_rest, Utilities.generateWildcardResource(1)), Utilities.generateWildcardResourceArray(1));
            source.remove(new Statement(node, Constants.s_rdf_type, Constants.s_daml_List), new Resource[0]);
        }
    }

    public static Object populateAndWatchHSList(Resource list, List elements, EventListener listener, Context context, IRDFContainer source) {
        ListWatchRecord record = new ListWatchRecord();
        record.m_list = list;
        record.m_source = source;
        record.m_listener = listener;
        record.m_rdfListener = new RDFListener((ServiceManager)context.getServiceAccessor(), (IRDFEventSource)((Object)source)){
            ListWatchRecord m_record;
            EventListener m_listener;

            public void statementAdded(Resource cookie, Statement s) {
                ListWatchRecord listWatchRecord = this.m_record;
                synchronized (listWatchRecord) {
                    NodeListener nodeListener = (NodeListener)this.m_record.m_nodeListeners.get(cookie);
                    if (nodeListener != null) {
                        nodeListener.statementAdded(s, this.m_record);
                    }
                }
            }

            public void statementRemoved(Resource cookie, Statement s) {
                ListWatchRecord listWatchRecord = this.m_record;
                synchronized (listWatchRecord) {
                    NodeListener nodeListener = (NodeListener)this.m_record.m_nodeListeners.get(cookie);
                    if (nodeListener != null) {
                        nodeListener.statementRemoved(s, this.m_record);
                    }
                }
            }

            public RDFListener init(ListWatchRecord record) {
                this.m_record = record;
                return this;
            }
        }.init(record);
        record.m_rdfListener.start();
        ListWatchRecord listWatchRecord = record;
        synchronized (listWatchRecord) {
            try {
                Resource cookie = record.m_rdfListener.addPattern(list, Constants.s_haystack_list, null);
                record.m_nodeListeners.put(cookie, new NodeListener(list, null, cookie){

                    public void statementAdded(Statement s0, ListWatchRecord record) {
                        Resource list = Utilities.getResourceProperty(this.m_node, Constants.s_haystack_list, record.m_source);
                        if (list.equals(Constants.s_daml_nil)) {
                            Iterator i = record.m_nodeListeners.values().iterator();
                            while (i.hasNext()) {
                                NodeListener nodeListener = (NodeListener)i.next();
                                if (nodeListener == this) continue;
                                record.m_rdfListener.removePattern(nodeListener.m_firstCookie);
                                record.m_rdfListener.removePattern(nodeListener.m_restCookie);
                            }
                            record.m_nodeListeners.clear();
                            record.m_nodeListeners.put(this.m_restCookie, this);
                            record.m_nodeListenersAsList.clear();
                            record.m_listener.onListCleared();
                        } else {
                            ListUtilities.processListNodeChanged(record, list, 0);
                        }
                    }
                });
                Resource currentNode = Utilities.getResourceProperty(list, Constants.s_haystack_list, source);
                while (!currentNode.equals(Constants.s_daml_nil)) {
                    elements.add(ListUtilities.makeElementNodeListener(currentNode, record, -1));
                    currentNode = Utilities.getResourceProperty(currentNode, Constants.s_daml_rest, source);
                }
            }
            catch (Exception e) {
                ListUtilities.cleanUpRecord(record);
                s_logger.error((Object)"Failed to process root of HS list", (Throwable)e);
                return null;
            }
        }
        return record;
    }

    static RDFNode makeElementNodeListener(Resource currentNode, ListWatchRecord record, int indexInList) throws RDFException {
        Resource firstCookie = record.m_rdfListener.addPattern(currentNode, Constants.s_daml_first, null);
        Resource restCookie = record.m_rdfListener.addPattern(currentNode, Constants.s_daml_rest, null);
        NodeListener nodeListener = new NodeListener(currentNode, firstCookie, restCookie){

            public void statementAdded(Statement s, ListWatchRecord record) {
                ListWatchRecord listWatchRecord = record;
                synchronized (listWatchRecord) {
                    int index = record.m_nodeListenersAsList.indexOf(this);
                    if (index >= 0) {
                        if (s.getPredicate().equals(Constants.s_daml_first)) {
                            Resource first = Utilities.getResourceProperty(this.m_node, Constants.s_daml_first, record.m_source);
                            record.m_listener.onItemChanged(first, index);
                        } else if (s.getPredicate().equals(Constants.s_daml_rest)) {
                            Resource rest = Utilities.getResourceProperty(this.m_node, Constants.s_daml_rest, record.m_source);
                            if (Constants.s_daml_nil.equals(rest)) {
                                ListUtilities.processListTruncated(record, index + 1);
                            } else if (rest != null) {
                                ListUtilities.processListNodeChanged(record, rest, index + 1);
                            } else {
                                s_logger.error((Object)("Expecting a Resource but got " + rest));
                            }
                        } else {
                            s_logger.error((Object)("Unexpected rdf event with predicate " + s.getPredicate()));
                        }
                    }
                }
            }
        };
        record.m_nodeListeners.put(firstCookie, nodeListener);
        record.m_nodeListeners.put(restCookie, nodeListener);
        if (indexInList == -1) {
            record.m_nodeListenersAsList.add(nodeListener);
        } else {
            record.m_nodeListenersAsList.add(indexInList, nodeListener);
        }
        return Utilities.getProperty(currentNode, Constants.s_daml_first, record.m_source);
    }

    /*
     * Exception decompiling
     */
    static void processListNodeChanged(ListWatchRecord record, Resource newNode, int indexOfChange) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void processListTruncated(ListWatchRecord record, int firstTruncated) {
        int length = record.m_nodeListenersAsList.size();
        ListIterator i = record.m_nodeListenersAsList.listIterator(firstTruncated);
        while (i.hasNext()) {
            NodeListener nodeListener = (NodeListener)i.next();
            record.m_rdfListener.removePattern(nodeListener.m_firstCookie);
            record.m_rdfListener.removePattern(nodeListener.m_restCookie);
            record.m_nodeListeners.remove(nodeListener.m_firstCookie);
            record.m_nodeListeners.remove(nodeListener.m_restCookie);
            i.remove();
        }
        record.m_listener.onItemRemoved(firstTruncated, length - firstTruncated);
    }

    static void cleanUpRecord(ListWatchRecord record) {
        if (record.m_rdfListener != null) {
            record.m_rdfListener.stop();
            record.m_rdfListener = null;
        }
        record.m_nodeListenersAsList.clear();
        record.m_nodeListeners.clear();
    }

    public static void unwatchHSList(Object watchData, IRDFContainer source) {
        ListUtilities.cleanUpRecord((ListWatchRecord)watchData);
    }

    public interface EventListener {
        public void onItemAdded(RDFNode var1, int var2);

        public void onItemChanged(RDFNode var1, int var2);

        public void onItemRemoved(int var1, int var2);

        public void onListCleared();
    }
}

